/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.properties;

import com.denizenscript.denizen.npc.traits.SneakingTrait;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.properties.entity.EntityProperty;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.core.ElementTag;
import net.citizensnpcs.api.npc.NPC;

public class EntitySneaking
extends EntityProperty<ElementTag> {
    public static boolean describes(EntityTag entity) {
        return true;
    }

    public ElementTag getPropertyValue() {
        return new ElementTag(this.getEntity().isSneaking());
    }

    public boolean isDefaultValue(ElementTag value) {
        return !value.asBoolean();
    }

    public void setPropertyValue(ElementTag value, Mechanism mechanism) {
        if (mechanism.requireBoolean()) {
            boolean sneaking = value.asBoolean();
            this.getEntity().setSneaking(sneaking);
            if (((EntityTag)this.object).isCitizensNPC()) {
                NPC npc = ((EntityTag)this.object).getDenizenNPC().getCitizen();
                if (sneaking) {
                    ((SneakingTrait)npc.getOrAddTrait(SneakingTrait.class)).sneak();
                } else if (npc.hasTrait(SneakingTrait.class)) {
                    ((SneakingTrait)npc.getTraitNullable(SneakingTrait.class)).stand();
                    npc.removeTrait(SneakingTrait.class);
                }
            }
        }
    }

    public String getPropertyId() {
        return "is_sneaking";
    }

    public static void register() {
        EntitySneaking.autoRegister((String)"is_sneaking", EntitySneaking.class, ElementTag.class, (boolean)false, (String[])new String[0]);
    }
}

