/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.impl;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.ProfileEditor;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.v1_21.Handler;
import com.denizenscript.denizen.nms.v1_21.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_21.helpers.PacketHelperImpl;
import com.denizenscript.denizen.nms.v1_21.impl.network.handlers.DenizenNetworkManagerImpl;
import com.denizenscript.denizen.scripts.commands.entity.RenameCommand;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.datafixers.util.Either;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.component.ResolvableProfile;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerRespawnEvent;

public class ProfileEditorImpl
extends ProfileEditor {
    public static final Field ClientboundPlayerInfoUpdatePacket_entries = ReflectionHelper.getFields(ClientboundPlayerInfoUpdatePacket.class).getFirstOfType(List.class);
    public static final MethodHandle RESOLVABLEPROFILE_UNPACK = ReflectionHelper.getMethodHandle(ResolvableProfile.class, (String)ReflectionMappingsInfo.ResolvableProfile_unpack_method, (Class[])new Class[0]);
    public static final MethodHandle RESOLVABLEPROFILE_PARTIAL_ID = ReflectionHelper.getFields((Class)ReflectionHelper.getClassOrThrow((String)"net.minecraft.world.item.component.ResolvableProfile$Partial")).getGetter(ReflectionMappingsInfo.ResolvableProfilePartial_id, Optional.class);

    protected void updatePlayer(Player player, boolean isSkinChanging) {
        EntityPlayer nmsPlayer = ((CraftPlayer)player).getHandle();
        UUID uuid = player.getUniqueId();
        ClientboundPlayerInfoRemovePacket removePlayerInfoPacket = new ClientboundPlayerInfoRemovePacket(List.of(uuid));
        ClientboundPlayerInfoUpdatePacket addPlayerInfoPacket = ClientboundPlayerInfoUpdatePacket.a(List.of(nmsPlayer));
        for (Player otherPlayer : Bukkit.getServer().getOnlinePlayers()) {
            PacketHelperImpl.send(otherPlayer, removePlayerInfoPacket);
            PacketHelperImpl.send(otherPlayer, addPlayerInfoPacket);
        }
        for (Player otherPlayer : NMSHandler.entityHelper.getPlayersThatSee((Entity)player)) {
            if (otherPlayer.getUniqueId().equals(uuid)) continue;
            PacketHelperImpl.forceRespawnPlayerEntity((Entity)player, otherPlayer);
        }
        if (isSkinChanging) {
            ((CraftServer)Bukkit.getServer()).getHandle().respawn(nmsPlayer, true, Entity.RemovalReason.e, PlayerRespawnEvent.RespawnReason.PLUGIN);
        } else {
            NMSHandler.playerHelper.refreshPlayer(player);
        }
        player.updateInventory();
    }

    public static void registerHandlers() {
        DenizenNetworkManagerImpl.registerPacketHandler(ClientboundPlayerInfoUpdatePacket.class, ProfileEditorImpl::processPlayerInfoUpdatePacket);
    }

    public static ClientboundPlayerInfoUpdatePacket processPlayerInfoUpdatePacket(DenizenNetworkManagerImpl networkManager, ClientboundPlayerInfoUpdatePacket playerInfoUpdatePacket) {
        if (ProfileEditor.mirrorUUIDs.isEmpty() && !RenameCommand.hasAnyDynamicRenames() && fakeProfiles.isEmpty()) {
            return playerInfoUpdatePacket;
        }
        EnumSet actions = playerInfoUpdatePacket.b();
        if (!actions.contains(ClientboundPlayerInfoUpdatePacket.a.a) && !actions.contains(ClientboundPlayerInfoUpdatePacket.a.f)) {
            return playerInfoUpdatePacket;
        }
        boolean any = false;
        for (ClientboundPlayerInfoUpdatePacket.b entry : playerInfoUpdatePacket.e()) {
            if (!ProfileEditorImpl.shouldChange(entry)) continue;
            any = true;
            break;
        }
        if (!any) {
            return playerInfoUpdatePacket;
        }
        GameProfile ownProfile = networkManager.player.gI();
        ArrayList<ClientboundPlayerInfoUpdatePacket.b> modifiedEntries = new ArrayList<ClientboundPlayerInfoUpdatePacket.b>(playerInfoUpdatePacket.e().size());
        for (ClientboundPlayerInfoUpdatePacket.b entry : playerInfoUpdatePacket.e()) {
            GameProfile baseProfile;
            if (!ProfileEditorImpl.shouldChange(entry)) {
                modifiedEntries.add(entry);
                continue;
            }
            String rename = RenameCommand.getCustomNameFor((UUID)entry.a(), (Player)networkManager.player.getBukkitEntity(), (boolean)false);
            GameProfile gameProfile = baseProfile = fakeProfiles.containsKey(entry.a()) ? ProfileEditorImpl.getGameProfile((PlayerProfile)fakeProfiles.get(entry.a())) : entry.b();
            PropertyMap modifiedProperties = ProfileEditor.mirrorUUIDs.contains(entry.a()) ? ownProfile.properties() : (Denizen.supportsPaper ? entry.b().properties() : baseProfile.properties());
            GameProfile modifiedProfile = new GameProfile(baseProfile.id(), rename != null ? (rename.length() > 16 ? rename.substring(0, 16) : rename) : baseProfile.name(), modifiedProperties);
            String listRename = RenameCommand.getCustomNameFor((UUID)entry.a(), (Player)networkManager.player.getBukkitEntity(), (boolean)true);
            IChatBaseComponent displayName = listRename != null ? Handler.componentToNMS(FormattedTextHelper.parse((String)listRename, (ChatColor)ChatColor.WHITE)) : entry.f();
            ClientboundPlayerInfoUpdatePacket.b modifiedEntry = new ClientboundPlayerInfoUpdatePacket.b(entry.a(), modifiedProfile, entry.c(), entry.d(), entry.e(), displayName, entry.g(), entry.h(), entry.i());
            modifiedEntries.add(modifiedEntry);
        }
        return ProfileEditorImpl.createInfoPacket(actions, modifiedEntries);
    }

    public static boolean shouldChange(ClientboundPlayerInfoUpdatePacket.b entry) {
        return ProfileEditor.mirrorUUIDs.contains(entry.a()) || RenameCommand.customNames.containsKey(entry.a()) || fakeProfiles.containsKey(entry.a());
    }

    public static ClientboundPlayerInfoUpdatePacket createInfoPacket(EnumSet<ClientboundPlayerInfoUpdatePacket.a> actions, List<ClientboundPlayerInfoUpdatePacket.b> entries) {
        ClientboundPlayerInfoUpdatePacket playerInfoUpdatePacket = new ClientboundPlayerInfoUpdatePacket(actions, List.of());
        try {
            ClientboundPlayerInfoUpdatePacket_entries.set(playerInfoUpdatePacket, entries);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
        return playerInfoUpdatePacket;
    }

    public static GameProfile createGameProfile(UUID uuid, String name, String texture, String signature) {
        return new GameProfile(uuid != null ? uuid : NIL_UUID, name != null ? name : "", texture != null ? new PropertyMap((Multimap)ImmutableMultimap.of((Object)"textures", (Object)new Property("textures", texture, signature))) : PropertyMap.EMPTY);
    }

    public static GameProfile getGameProfileNoProperties(PlayerProfile playerProfile) {
        return ProfileEditorImpl.createGameProfile(playerProfile.getUniqueId(), playerProfile.getName(), null, null);
    }

    public static GameProfile getGameProfile(PlayerProfile playerProfile) {
        return ProfileEditorImpl.createGameProfile(playerProfile.getUniqueId(), playerProfile.getName(), playerProfile.getTexture(), playerProfile.getTextureSignature());
    }

    public static UUID getUUID(ResolvableProfile resolvableProfile) {
        try {
            Either unpacked = RESOLVABLEPROFILE_UNPACK.invokeExact(resolvableProfile);
            return (UUID)unpacked.map(GameProfile::id, partial -> {
                try {
                    Optional uuid = RESOLVABLEPROFILE_PARTIAL_ID.invoke(partial);
                    return uuid.orElse(null);
                }
                catch (Throwable e) {
                    Debug.echoError((Throwable)e);
                    return null;
                }
            });
        }
        catch (Throwable e) {
            Debug.echoError((Throwable)e);
            return null;
        }
    }
}

