/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_19.helpers;

import com.denizenscript.denizencore.utilities.ReflectionHelper;
import java.lang.invoke.MethodHandle;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.ByteArrayBinaryTag;
import net.kyori.adventure.nbt.ByteBinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.DoubleBinaryTag;
import net.kyori.adventure.nbt.EndBinaryTag;
import net.kyori.adventure.nbt.FloatBinaryTag;
import net.kyori.adventure.nbt.IntArrayBinaryTag;
import net.kyori.adventure.nbt.IntBinaryTag;
import net.kyori.adventure.nbt.ListBinaryTag;
import net.kyori.adventure.nbt.LongArrayBinaryTag;
import net.kyori.adventure.nbt.LongBinaryTag;
import net.kyori.adventure.nbt.ShortBinaryTag;
import net.kyori.adventure.nbt.StringBinaryTag;

public class NBTAdapter {
    public static final MethodHandle COMPOUND_TAG_MAP_CONSTRUCTOR = ReflectionHelper.getConstructor(re.class, (Class[])new Class[]{Map.class});

    public static rx toNMS(BinaryTag tag) {
        if (tag instanceof ByteBinaryTag) {
            ByteBinaryTag byteTag = (ByteBinaryTag)tag;
            return switch (byteTag.value()) {
                case 0 -> rc.b;
                case 1 -> rc.c;
                default -> rc.a((byte)byteTag.value());
            };
        }
        if (tag instanceof ShortBinaryTag) {
            ShortBinaryTag shortTag = (ShortBinaryTag)tag;
            return rs.a((short)shortTag.value());
        }
        if (tag instanceof IntBinaryTag) {
            IntBinaryTag intTag = (IntBinaryTag)tag;
            return rj.a((int)intTag.value());
        }
        if (tag instanceof LongBinaryTag) {
            LongBinaryTag longTag = (LongBinaryTag)tag;
            return rm.a((long)longTag.value());
        }
        if (tag instanceof FloatBinaryTag) {
            FloatBinaryTag floatTag = (FloatBinaryTag)tag;
            return rh.a((float)floatTag.value());
        }
        if (tag instanceof DoubleBinaryTag) {
            DoubleBinaryTag doubleTag = (DoubleBinaryTag)tag;
            return rf.a((double)doubleTag.value());
        }
        if (tag instanceof ByteArrayBinaryTag) {
            ByteArrayBinaryTag byteArrayTag = (ByteArrayBinaryTag)tag;
            return new rb(byteArrayTag.value());
        }
        if (tag instanceof IntArrayBinaryTag) {
            IntArrayBinaryTag intArrayTag = (IntArrayBinaryTag)tag;
            return new ri(intArrayTag.value());
        }
        if (tag instanceof LongArrayBinaryTag) {
            LongArrayBinaryTag longArrayTag = (LongArrayBinaryTag)tag;
            return new rl(longArrayTag.value());
        }
        if (tag instanceof StringBinaryTag) {
            StringBinaryTag stringTag = (StringBinaryTag)tag;
            return rv.a((String)stringTag.value());
        }
        if (tag instanceof ListBinaryTag) {
            ListBinaryTag listTag = (ListBinaryTag)tag;
            return NBTAdapter.toNMS(listTag);
        }
        if (tag instanceof CompoundBinaryTag) {
            CompoundBinaryTag compoundTag = (CompoundBinaryTag)tag;
            return NBTAdapter.toNMS(compoundTag);
        }
        if (tag instanceof EndBinaryTag) {
            return rg.b;
        }
        throw new IllegalStateException("Unrecognized API tag of type '" + String.valueOf(tag.type()) + "': " + String.valueOf(tag));
    }

    public static BinaryTag toAPI(rx nmsTag) {
        if (nmsTag instanceof rc) {
            rc nmsByteTag = (rc)nmsTag;
            return ByteBinaryTag.byteBinaryTag((byte)nmsByteTag.i());
        }
        if (nmsTag instanceof rs) {
            rs nmsShortTag = (rs)nmsTag;
            return ShortBinaryTag.shortBinaryTag((short)nmsShortTag.h());
        }
        if (nmsTag instanceof rj) {
            rj nmsIntTag = (rj)nmsTag;
            return IntBinaryTag.intBinaryTag((int)nmsIntTag.g());
        }
        if (nmsTag instanceof rm) {
            rm nmsLongTag = (rm)nmsTag;
            return LongBinaryTag.longBinaryTag((long)nmsLongTag.f());
        }
        if (nmsTag instanceof rh) {
            rh nmsFloatTag = (rh)nmsTag;
            return FloatBinaryTag.floatBinaryTag((float)nmsFloatTag.k());
        }
        if (nmsTag instanceof rf) {
            rf nmsDoubleTag = (rf)nmsTag;
            return DoubleBinaryTag.doubleBinaryTag((double)nmsDoubleTag.j());
        }
        if (nmsTag instanceof rb) {
            rb nmsByteArrayTag = (rb)nmsTag;
            return ByteArrayBinaryTag.byteArrayBinaryTag((byte[])nmsByteArrayTag.e());
        }
        if (nmsTag instanceof ri) {
            ri nmsIntArrayTag = (ri)nmsTag;
            return IntArrayBinaryTag.intArrayBinaryTag((int[])nmsIntArrayTag.g());
        }
        if (nmsTag instanceof rl) {
            rl nmsLongArrayTag = (rl)nmsTag;
            return LongArrayBinaryTag.longArrayBinaryTag((long[])nmsLongArrayTag.g());
        }
        if (nmsTag instanceof rv) {
            rv nmsStringTag = (rv)nmsTag;
            return StringBinaryTag.stringBinaryTag((String)nmsStringTag.f_());
        }
        if (nmsTag instanceof rk) {
            rk nmsListTag = (rk)nmsTag;
            return NBTAdapter.toAPI(nmsListTag);
        }
        if (nmsTag instanceof re) {
            re nmsCompoundTag = (re)nmsTag;
            return NBTAdapter.toAPI(nmsCompoundTag);
        }
        if (nmsTag instanceof rg) {
            return EndBinaryTag.endBinaryTag();
        }
        throw new IllegalStateException("Unrecognized NMS tag of type '" + nmsTag.getClass().getName() + "/" + nmsTag.c().a() + "': " + String.valueOf(nmsTag));
    }

    public static ListBinaryTag toAPI(rk nmsListTag) {
        ListBinaryTag.Builder builder = ListBinaryTag.builder();
        for (rx nmsEntry : nmsListTag) {
            builder.add(NBTAdapter.toAPI(nmsEntry));
        }
        return builder.build();
    }

    public static rk toNMS(ListBinaryTag listTag) {
        rk nmsListTag = new rk();
        for (BinaryTag value : listTag) {
            nmsListTag.add((Object)NBTAdapter.toNMS(value));
        }
        return nmsListTag;
    }

    public static CompoundBinaryTag toAPI(re nmsCompoundTag) {
        HashMap<String, BinaryTag> tags = new HashMap<String, BinaryTag>(nmsCompoundTag.f());
        for (String key : nmsCompoundTag.e()) {
            tags.put(key, NBTAdapter.toAPI(nmsCompoundTag.c(key)));
        }
        return CompoundBinaryTag.from(tags);
    }

    public static re toNMS(CompoundBinaryTag compoundTag) {
        HashMap<String, rx> nmsTags = new HashMap<String, rx>(compoundTag.size());
        for (Map.Entry entry : compoundTag) {
            nmsTags.put((String)entry.getKey(), NBTAdapter.toNMS((BinaryTag)entry.getValue()));
        }
        try {
            return COMPOUND_TAG_MAP_CONSTRUCTOR.invokeExact(nmsTags);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

