/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.impl.network.handlers.packet;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.v1_21.helpers.PacketHelperImpl;
import com.denizenscript.denizen.nms.v1_21.impl.network.handlers.DenizenNetworkManagerImpl;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.commands.player.DisguiseCommand;
import com.denizenscript.denizen.utilities.entity.EntityAttachmentHelper;
import com.denizenscript.denizen.utilities.entity.FakeEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.ToIntFunction;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;

public class DisguisePacketHandlers {
    private static boolean antiDuplicate = false;

    public static void registerHandlers() {
        DisguisePacketHandlers.registerPacketHandler(agp.class, agp::b, DisguisePacketHandlers::processEntityDataPacket);
        DisguisePacketHandlers.registerPacketHandler(ahu.class, ahu::b, DisguisePacketHandlers::processAttributesPacket);
        DisguisePacketHandlers.registerPacketHandler(adc.class, adc::b, DisguisePacketHandlers::sendDisguiseForPacket);
        DisguisePacketHandlers.registerPacketHandler(aho.class, aho::b, DisguisePacketHandlers::processTeleportPacket);
        DisguisePacketHandlers.registerPacketHandler(afa.c.class, afa::a, DisguisePacketHandlers::processMoveEntityRotPacket);
        DisguisePacketHandlers.registerPacketHandler(afa.b.class, afa::a, DisguisePacketHandlers::processMoveEntityPosRotPacket);
    }

    public static <T extends aay<adb>> void registerPacketHandler(Class<T> packetType, ToIntFunction<T> idGetter, DisguisePacketHandler<T> handler) {
        DisguisePacketHandlers.registerPacketHandler(packetType, (T packet, dwo level) -> level.a(idGetter.applyAsInt(packet)), handler);
    }

    public static <T extends aay<adb>> void registerPacketHandler(Class<T> packetType, BiFunction<T, dwo, cgk> entityGetter, DisguisePacketHandler<T> handler) {
        DenizenNetworkManagerImpl.registerPacketHandler(packetType, (networkManager, packet) -> {
            if (DisguiseCommand.disguises.isEmpty() || antiDuplicate) {
                return packet;
            }
            cgk entity = (cgk)entityGetter.apply((Object)packet, (dwo)networkManager.player.A());
            if (entity == null) {
                return packet;
            }
            Map playerMap = (Map)DisguiseCommand.disguises.get(entity.cY());
            if (playerMap == null) {
                return packet;
            }
            DisguiseCommand.TrackedDisguise disguise = (DisguiseCommand.TrackedDisguise)playerMap.get(networkManager.player.cY());
            if (disguise == null) {
                disguise = (DisguiseCommand.TrackedDisguise)playerMap.get(null);
            }
            if (disguise == null || !disguise.isActive) {
                return packet;
            }
            if (NMSHandler.debugPackets) {
                DenizenNetworkManagerImpl.doPacketOutput("DISGUISED packet " + packet.getClass().getName() + " for entity " + entity.aA() + " to player " + networkManager.player.da());
            }
            try {
                return handler.handle(networkManager, packet, disguise);
            }
            catch (Exception e2) {
                antiDuplicate = false;
                throw e2;
            }
        });
    }

    public static agp processEntityDataPacket(DenizenNetworkManagerImpl networkManager, agp entityDataPacket, DisguiseCommand.TrackedDisguise disguise) {
        if (entityDataPacket.b() == networkManager.player.aA()) {
            if (!disguise.shouldFake) {
                return entityDataPacket;
            }
            for (ama.c dataValue : entityDataPacket.e()) {
                if (dataValue.a() != 0) continue;
                ArrayList<ama.c<Byte>> newData = new ArrayList<ama.c<Byte>>(entityDataPacket.e());
                newData.remove(dataValue);
                byte flags = (Byte)dataValue.c();
                flags = (byte)(flags | 0x20);
                newData.add(PacketHelperImpl.createEntityData(PacketHelperImpl.ENTITY_DATA_ACCESSOR_FLAGS, flags));
                return new agp(entityDataPacket.b(), newData);
            }
        } else {
            List data = ((CraftEntity)disguise.toOthers.entity.entity).getHandle().aD().c();
            return data != null ? new agp(entityDataPacket.b(), data) : null;
        }
        return entityDataPacket;
    }

    public static ahu processAttributesPacket(DenizenNetworkManagerImpl networkManager, ahu attributesPacket, DisguiseCommand.TrackedDisguise disguise) {
        FakeEntity fake = attributesPacket.b() == networkManager.player.aA() ? disguise.fakeToSelf : disguise.toOthers;
        return fake == null || fake.entity.entity instanceof LivingEntity ? attributesPacket : null;
    }

    public static aho processTeleportPacket(DenizenNetworkManagerImpl networkManager, aho teleportEntityPacket, DisguiseCommand.TrackedDisguise disguise) throws IllegalAccessException {
        if (disguise.as.getBukkitEntityType() == EntityType.ENDER_DRAGON) {
            chy oldChange = teleportEntityPacket.e();
            return new aho(teleportEntityPacket.b(), new chy(oldChange.a(), oldChange.b(), EntityAttachmentHelper.normalizeAngle((float)(oldChange.c() + 180.0f)), oldChange.d()), teleportEntityPacket.f(), teleportEntityPacket.g());
        }
        return DisguisePacketHandlers.sendDisguiseForPacket(networkManager, teleportEntityPacket, disguise);
    }

    public static afa.c processMoveEntityRotPacket(DenizenNetworkManagerImpl networkManager, afa.c rotPacket, DisguiseCommand.TrackedDisguise disguise) {
        if (disguise.as.getBukkitEntityType() == EntityType.ENDER_DRAGON) {
            return new afa.c(disguise.entity.getBukkitEntity().getEntityId(), EntityAttachmentHelper.compressAngle((float)(rotPacket.g() + 180.0f)), bgj.e((float)rotPacket.h()), rotPacket.k());
        }
        return DisguisePacketHandlers.sendDisguiseForPacket(networkManager, rotPacket, disguise);
    }

    public static afa.b processMoveEntityPosRotPacket(DenizenNetworkManagerImpl networkManager, afa.b posRotPacket, DisguiseCommand.TrackedDisguise disguise) {
        if (disguise.as.getBukkitEntityType() == EntityType.ENDER_DRAGON) {
            return new afa.b(disguise.entity.getBukkitEntity().getEntityId(), posRotPacket.b(), posRotPacket.e(), posRotPacket.f(), EntityAttachmentHelper.compressAngle((float)(posRotPacket.g() + 180.0f)), bgj.e((float)posRotPacket.h()), posRotPacket.k());
        }
        return DisguisePacketHandlers.sendDisguiseForPacket(networkManager, posRotPacket, disguise);
    }

    public static <T extends aay<adb>> T sendDisguiseForPacket(DenizenNetworkManagerImpl networkManager, T packet, DisguiseCommand.TrackedDisguise disguise) {
        antiDuplicate = true;
        disguise.sendTo(List.of(new PlayerTag(networkManager.player.cY())));
        antiDuplicate = false;
        return null;
    }

    @FunctionalInterface
    public static interface DisguisePacketHandler<T extends aay<adb>> {
        public T handle(DenizenNetworkManagerImpl var1, T var2, DisguiseCommand.TrackedDisguise var3) throws Exception;
    }
}

