/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_20.helpers;

import com.denizenscript.denizencore.utilities.ReflectionHelper;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.ByteArrayBinaryTag;
import net.kyori.adventure.nbt.ByteBinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.DoubleBinaryTag;
import net.kyori.adventure.nbt.EndBinaryTag;
import net.kyori.adventure.nbt.FloatBinaryTag;
import net.kyori.adventure.nbt.IntArrayBinaryTag;
import net.kyori.adventure.nbt.IntBinaryTag;
import net.kyori.adventure.nbt.ListBinaryTag;
import net.kyori.adventure.nbt.LongArrayBinaryTag;
import net.kyori.adventure.nbt.LongBinaryTag;
import net.kyori.adventure.nbt.ShortBinaryTag;
import net.kyori.adventure.nbt.StringBinaryTag;

public class NBTAdapter {
    public static final MethodHandle COMPOUND_TAG_MAP_CONSTRUCTOR = ReflectionHelper.getConstructor(us.class, (Class[])new Class[]{Map.class});

    public static vp toNMS(BinaryTag tag) {
        if (tag instanceof ByteBinaryTag) {
            ByteBinaryTag byteTag = (ByteBinaryTag)tag;
            return switch (byteTag.value()) {
                case 0 -> uq.b;
                case 1 -> uq.c;
                default -> uq.a((byte)byteTag.value());
            };
        }
        if (tag instanceof ShortBinaryTag) {
            ShortBinaryTag shortTag = (ShortBinaryTag)tag;
            return vk.a((short)shortTag.value());
        }
        if (tag instanceof IntBinaryTag) {
            IntBinaryTag intTag = (IntBinaryTag)tag;
            return ux.a((int)intTag.value());
        }
        if (tag instanceof LongBinaryTag) {
            LongBinaryTag longTag = (LongBinaryTag)tag;
            return va.a((long)longTag.value());
        }
        if (tag instanceof FloatBinaryTag) {
            FloatBinaryTag floatTag = (FloatBinaryTag)tag;
            return uv.a((float)floatTag.value());
        }
        if (tag instanceof DoubleBinaryTag) {
            DoubleBinaryTag doubleTag = (DoubleBinaryTag)tag;
            return ut.a((double)doubleTag.value());
        }
        if (tag instanceof ByteArrayBinaryTag) {
            ByteArrayBinaryTag byteArrayTag = (ByteArrayBinaryTag)tag;
            return new up(byteArrayTag.value());
        }
        if (tag instanceof IntArrayBinaryTag) {
            IntArrayBinaryTag intArrayTag = (IntArrayBinaryTag)tag;
            return new uw(intArrayTag.value());
        }
        if (tag instanceof LongArrayBinaryTag) {
            LongArrayBinaryTag longArrayTag = (LongArrayBinaryTag)tag;
            return new uz(longArrayTag.value());
        }
        if (tag instanceof StringBinaryTag) {
            StringBinaryTag stringTag = (StringBinaryTag)tag;
            return vn.a((String)stringTag.value());
        }
        if (tag instanceof ListBinaryTag) {
            ListBinaryTag listTag = (ListBinaryTag)tag;
            return NBTAdapter.toNMS(listTag);
        }
        if (tag instanceof CompoundBinaryTag) {
            CompoundBinaryTag compoundTag = (CompoundBinaryTag)tag;
            return NBTAdapter.toNMS(compoundTag);
        }
        if (tag instanceof EndBinaryTag) {
            return uu.b;
        }
        throw new IllegalStateException("Unrecognized API tag of type '" + String.valueOf(tag.type()) + "': " + String.valueOf(tag));
    }

    public static BinaryTag toAPI(vp nmsTag) {
        if (nmsTag instanceof uq) {
            uq nmsByteTag = (uq)nmsTag;
            return ByteBinaryTag.byteBinaryTag((byte)nmsByteTag.i());
        }
        if (nmsTag instanceof vk) {
            vk nmsShortTag = (vk)nmsTag;
            return ShortBinaryTag.shortBinaryTag((short)nmsShortTag.h());
        }
        if (nmsTag instanceof ux) {
            ux nmsIntTag = (ux)nmsTag;
            return IntBinaryTag.intBinaryTag((int)nmsIntTag.g());
        }
        if (nmsTag instanceof va) {
            va nmsLongTag = (va)nmsTag;
            return LongBinaryTag.longBinaryTag((long)nmsLongTag.f());
        }
        if (nmsTag instanceof uv) {
            uv nmsFloatTag = (uv)nmsTag;
            return FloatBinaryTag.floatBinaryTag((float)nmsFloatTag.k());
        }
        if (nmsTag instanceof ut) {
            ut nmsDoubleTag = (ut)nmsTag;
            return DoubleBinaryTag.doubleBinaryTag((double)nmsDoubleTag.j());
        }
        if (nmsTag instanceof up) {
            up nmsByteArrayTag = (up)nmsTag;
            return ByteArrayBinaryTag.byteArrayBinaryTag((byte[])nmsByteArrayTag.e());
        }
        if (nmsTag instanceof uw) {
            uw nmsIntArrayTag = (uw)nmsTag;
            return IntArrayBinaryTag.intArrayBinaryTag((int[])nmsIntArrayTag.g());
        }
        if (nmsTag instanceof uz) {
            uz nmsLongArrayTag = (uz)nmsTag;
            return LongArrayBinaryTag.longArrayBinaryTag((long[])nmsLongArrayTag.g());
        }
        if (nmsTag instanceof vn) {
            vn nmsStringTag = (vn)nmsTag;
            return StringBinaryTag.stringBinaryTag((String)nmsStringTag.s_());
        }
        if (nmsTag instanceof uy) {
            uy nmsListTag = (uy)nmsTag;
            return NBTAdapter.toAPI(nmsListTag);
        }
        if (nmsTag instanceof us) {
            us nmsCompoundTag = (us)nmsTag;
            return NBTAdapter.toAPI(nmsCompoundTag);
        }
        if (nmsTag instanceof uu) {
            return EndBinaryTag.endBinaryTag();
        }
        throw new IllegalStateException("Unrecognized NMS tag of type '" + nmsTag.getClass().getName() + "/" + nmsTag.c().a() + "': " + String.valueOf(nmsTag));
    }

    public static ListBinaryTag toAPI(uy nmsListTag) {
        ListBinaryTag.Builder builder = ListBinaryTag.builder((int)nmsListTag.size());
        for (vp nmsValue : nmsListTag) {
            builder.add(NBTAdapter.toAPI(nmsValue));
        }
        return builder.build();
    }

    public static uy toNMS(ListBinaryTag listTag) {
        ArrayList<vp> nmsTags = new ArrayList<vp>(listTag.size());
        for (BinaryTag value : listTag) {
            nmsTags.add(NBTAdapter.toNMS(value));
        }
        return new uy(nmsTags, listTag.elementType().id());
    }

    public static CompoundBinaryTag toAPI(us nmsCompoundTag) {
        CompoundBinaryTag.Builder builder = CompoundBinaryTag.builder((int)nmsCompoundTag.f());
        for (String key : nmsCompoundTag.e()) {
            builder.put(key, NBTAdapter.toAPI(nmsCompoundTag.c(key)));
        }
        return builder.build();
    }

    public static us toNMS(CompoundBinaryTag compoundTag) {
        HashMap<String, vp> nmsTags = new HashMap<String, vp>(compoundTag.size());
        for (Map.Entry entry : compoundTag) {
            nmsTags.put((String)entry.getKey(), NBTAdapter.toNMS((BinaryTag)entry.getValue()));
        }
        try {
            return COMPOUND_TAG_MAP_CONSTRUCTOR.invokeExact(nmsTags);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

