/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_17.helpers;

import com.denizenscript.denizen.nms.interfaces.WorldHelper;
import com.denizenscript.denizen.nms.v1_17.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_17.impl.BiomeNMSImpl;
import com.denizenscript.denizen.objects.BiomeTag;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.players.SleepStatus;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.level.World;
import net.minecraft.world.level.storage.WorldDataServer;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_17_R1.CraftWorld;

public class WorldHelperImpl
implements WorldHelper {
    public boolean isStatic(org.bukkit.World world) {
        return ((CraftWorld)world).getHandle().y;
    }

    public void setStatic(org.bukkit.World world, boolean isStatic) {
        WorldServer worldServer = ((CraftWorld)world).getHandle();
        ReflectionHelper.setFieldValue(World.class, (String)ReflectionMappingsInfo.Level_isClientSide, (Object)worldServer, (Object)isStatic);
    }

    public float getLocalDifficulty(Location location) {
        BlockPosition pos = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        DifficultyDamageScaler scaler = ((CraftWorld)location.getWorld()).getHandle().getDamageScaler(pos);
        return scaler.b();
    }

    public Location getNearestBiomeLocation(Location start, BiomeTag biome) {
        BlockPosition result = ((CraftWorld)start.getWorld()).getHandle().a(((BiomeNMSImpl)biome.getBiome()).biomeBase, new BlockPosition(start.getBlockX(), start.getBlockY(), start.getBlockZ()), 6400, 8);
        if (result == null) {
            return null;
        }
        return new Location(start.getWorld(), (double)result.getX(), (double)result.getY(), (double)result.getZ());
    }

    public boolean areEnoughSleeping(org.bukkit.World world, int percentage) {
        SleepStatus status = (SleepStatus)ReflectionHelper.getFieldValue(WorldServer.class, (String)ReflectionMappingsInfo.ServerLevel_sleepStatus, (Object)((CraftWorld)world).getHandle());
        return status.a(percentage);
    }

    public boolean areEnoughDeepSleeping(org.bukkit.World world, int percentage) {
        WorldServer level = ((CraftWorld)world).getHandle();
        SleepStatus status = (SleepStatus)ReflectionHelper.getFieldValue(WorldServer.class, (String)ReflectionMappingsInfo.ServerLevel_sleepStatus, (Object)level);
        return status.a(percentage, level.getPlayers());
    }

    public int getSkyDarken(org.bukkit.World world) {
        return ((CraftWorld)world).getHandle().n_();
    }

    public boolean isDay(org.bukkit.World world) {
        return ((CraftWorld)world).getHandle().isDay();
    }

    public boolean isNight(org.bukkit.World world) {
        return ((CraftWorld)world).getHandle().isNight();
    }

    public void setDayTime(org.bukkit.World world, long time) {
        ((CraftWorld)world).getHandle().setDayTime(time);
    }

    public void wakeUpAllPlayers(org.bukkit.World world) {
        WorldServer nmsWorld = ((CraftWorld)world).getHandle();
        SleepStatus status = (SleepStatus)ReflectionHelper.getFieldValue(WorldServer.class, (String)ReflectionMappingsInfo.ServerLevel_sleepStatus, (Object)nmsWorld);
        status.a();
        nmsWorld.a(EntityLiving::isSleeping).forEach(player -> player.wakeup(false, false));
    }

    public void clearWeather(org.bukkit.World world) {
        WorldDataServer data = ((CraftWorld)world).getHandle().E;
        data.setStorm(false);
        if (!data.hasStorm()) {
            data.setWeatherDuration(0);
        }
        data.setThundering(false);
        if (!data.isThundering()) {
            data.setThunderDuration(0);
        }
    }
}

