/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.item;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizen.utilities.inventory.InventoryViewUtil;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import java.util.Arrays;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.Recipe;

public class ItemRecipeFormedScriptEvent
extends BukkitScriptEvent
implements Listener {
    public PrepareItemCraftEvent event;
    public ItemTag result;

    public ItemRecipeFormedScriptEvent() {
        this.registerCouldMatcher("<item> recipe formed");
        this.registerOptionalDetermination(null, ObjectTag.class, (evt, context, determination) -> {
            if (determination.canBeType(ItemTag.class)) {
                ItemTag result = determination.asType(ItemTag.class, context);
                evt.event.getInventory().setResult(result.getItemStack());
                return true;
            }
            return false;
        });
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!path.tryArgObject(0, this.result)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(EntityTag.getPlayerFrom((Entity)InventoryViewUtil.getPlayer(this.event.getView())), null);
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "item" -> this.result;
            case "inventory" -> InventoryTag.mirrorBukkitInventory((Inventory)this.event.getInventory());
            case "recipe" -> new ListTag(Arrays.asList(this.event.getInventory().getMatrix()), ItemTag::new);
            case "recipe_id" -> {
                Recipe var5_4 = this.event.getRecipe();
                if (var5_4 instanceof Keyed) {
                    Keyed keyed = (Keyed)var5_4;
                    yield new ElementTag(keyed.getKey().toString(), true);
                }
                yield null;
            }
            case "is_repair" -> new ElementTag(this.event.isRepair());
            default -> super.getContext(name);
        };
    }

    @Override
    public void cancellationChanged() {
        if (this.cancelled) {
            this.event.getInventory().setResult(null);
        }
        super.cancellationChanged();
    }

    @EventHandler
    public void onRecipeFormed(PrepareItemCraftEvent event) {
        this.event = event;
        if (event.getRecipe() == null) {
            return;
        }
        this.result = new ItemTag(event.getInventory().getResult());
        if (this.result.getBukkitMaterial() == Material.AIR) {
            this.result = new ItemTag(event.getRecipe().getResult());
        }
        this.cancelled = false;
        this.fire((Event)event);
    }
}

