/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.properties.item.ItemProperty;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;

public class ItemComponentsPatch
extends ItemProperty<MapTag> {
    public static final String DATA_VERSION_KEY = "denizen:__data_version";
    public static final PerIdPropertyDataRemover ENTITY_DATA_REMOVER = new PerIdPropertyDataRemover("minecraft:entity_data");
    public static final PerIdPropertyDataRemover BLOCK_ENTITY_DATA_REMOVER = new PerIdPropertyDataRemover("minecraft:block_entity_data");
    public static final StringHolder INSTRUMENT_COMPONENT = new StringHolder("minecraft:instrument");
    public static final Set<String> propertyHandledComponents = new HashSet<String>();

    public static void registerHandledComponent(String component) {
        propertyHandledComponents.add("minecraft:" + component);
    }

    public static boolean describes(ItemTag item) {
        return item.getBukkitMaterial() != Material.AIR;
    }

    @Override
    public MapTag getPropertyValue() {
        MapTag rawComponents = NMSHandler.itemHelper.getRawComponentsPatch(this.getItemStack(), true);
        if (rawComponents.isEmpty()) {
            return rawComponents;
        }
        ENTITY_DATA_REMOVER.removeFrom(rawComponents);
        BLOCK_ENTITY_DATA_REMOVER.removeFrom(rawComponents);
        rawComponents.map.computeIfPresent(INSTRUMENT_COMPONENT, (key, value) -> value instanceof ElementTag ? null : value);
        if (rawComponents.size() == 1) {
            return new MapTag();
        }
        return rawComponents;
    }

    @Override
    public boolean isDefaultValue(MapTag value) {
        return value.isEmpty();
    }

    @Override
    public void setPropertyValue(MapTag value, Mechanism mechanism) {
        int dataVersion;
        ElementTag dataVersionInput = value.getElement(DATA_VERSION_KEY);
        if (dataVersionInput == null) {
            dataVersion = Integer.MAX_VALUE;
        } else {
            if (!dataVersionInput.isInt()) {
                mechanism.echoError("Invalid data version '" + String.valueOf(dataVersionInput) + "' specified: must be a valid non-decimal number.");
                return;
            }
            dataVersion = dataVersionInput.asInt();
            value.remove(DATA_VERSION_KEY);
        }
        this.setItemStack(NMSHandler.itemHelper.setRawComponentsPatch(this.getItemStack(), value, dataVersion, mechanism::echoError));
    }

    @Override
    public String getPropertyId() {
        return "components_patch";
    }

    public static void register() {
        ItemComponentsPatch.autoRegister("components_patch", ItemComponentsPatch.class, MapTag.class, false, new String[0]);
        PropertyParser.registerTag(ItemComponentsPatch.class, MapTag.class, "full_components_patch", (attribute, property) -> NMSHandler.itemHelper.getRawComponentsPatch(property.getItemStack(), false), new String[0]);
    }

    static {
        ENTITY_DATA_REMOVER.registerRemoval((Keyed)EntityType.ITEM_FRAME, "Invisible");
        ENTITY_DATA_REMOVER.registerRemoval((Keyed)EntityType.ARMOR_STAND, "Pose", "Small", "NoBasePlate", "Marker", "Invisible", "ShowArms");
        BLOCK_ENTITY_DATA_REMOVER.registerRemoval("minecraft:sign", "front_text", "back_text", "is_waxed");
        BLOCK_ENTITY_DATA_REMOVER.registerRemoval("minecraft:hanging_sign", "front_text", "back_text", "is_waxed");
        BLOCK_ENTITY_DATA_REMOVER.registerRemoval("minecraft:spawner", "SpawnCount", "Delay", "MinSpawnDelay", "MaxSpawnDelay", "MaxNearbyEntities", "RequiredPlayerRange", "SpawnRange");
    }

    public record PerIdPropertyDataRemover(StringHolder propertyId, Map<String, Set<StringHolder>> removalsPerId) {
        public static final StringHolder ID_STRING_HOLDER = new StringHolder("id");

        public PerIdPropertyDataRemover(String propertyId) {
            this(new StringHolder(propertyId), new HashMap<String, Set<StringHolder>>());
        }

        public void registerRemoval(Keyed type, String ... keys) {
            this.registerRemoval(type.getKey().toString(), keys);
        }

        public void registerRemoval(String id, String ... keys) {
            HashSet<StringHolder> toRemove = new HashSet<StringHolder>(keys.length + 1);
            toRemove.add(ID_STRING_HOLDER);
            for (String key : keys) {
                toRemove.add(new StringHolder(key));
            }
            this.removalsPerId.put("string:" + id, toRemove);
        }

        public void removeFrom(MapTag rawComponents) {
            rawComponents.map.computeIfPresent(this.propertyId, (key, rawValue) -> {
                MapTag value = (MapTag)rawValue;
                Set<StringHolder> toRemove = this.removalsPerId.get(value.getObject(ID_STRING_HOLDER).toString());
                if (toRemove != null && toRemove.size() >= value.size() && toRemove.containsAll(value.keySet())) {
                    return null;
                }
                return rawValue;
            });
        }
    }
}

