/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.destroystokyo.paper.event.player.PlayerReadyArrowEvent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class PlayerChoosesArrowScriptEvent
extends BukkitScriptEvent
implements Listener {
    public PlayerReadyArrowEvent event;

    public PlayerChoosesArrowScriptEvent() {
        this.registerCouldMatcher("player chooses arrow");
        this.registerSwitches(new String[]{"arrow", "bow"});
    }

    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!path.tryObjectSwitch("arrow", (ObjectTag)new ItemTag(this.event.getArrow()))) {
            return false;
        }
        if (!path.tryObjectSwitch("bow", (ObjectTag)new ItemTag(this.event.getBow()))) {
            return false;
        }
        if (!this.runInCheck(path, this.event.getPlayer().getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    public ObjectTag getContext(String name) {
        switch (name) {
            case "arrow": {
                return new ItemTag(this.event.getArrow());
            }
            case "bow": {
                return new ItemTag(this.event.getBow());
            }
        }
        return super.getContext(name);
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(new PlayerTag(this.event.getPlayer()), null);
    }

    public void cancellationChanged() {
        if (this.cancelled) {
            Player p = this.event.getPlayer();
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Denizen.getInstance(), () -> ((Player)p).updateInventory(), 1L);
        }
        super.cancellationChanged();
    }

    @EventHandler
    public void onPlayerChoosesArrow(PlayerReadyArrowEvent event) {
        this.event = event;
        this.fire((Event)event);
    }
}

