/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_17.helpers;

import com.denizenscript.denizencore.utilities.ReflectionHelper;
import java.lang.invoke.MethodHandle;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.ByteArrayBinaryTag;
import net.kyori.adventure.nbt.ByteBinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.DoubleBinaryTag;
import net.kyori.adventure.nbt.EndBinaryTag;
import net.kyori.adventure.nbt.FloatBinaryTag;
import net.kyori.adventure.nbt.IntArrayBinaryTag;
import net.kyori.adventure.nbt.IntBinaryTag;
import net.kyori.adventure.nbt.ListBinaryTag;
import net.kyori.adventure.nbt.LongArrayBinaryTag;
import net.kyori.adventure.nbt.LongBinaryTag;
import net.kyori.adventure.nbt.ShortBinaryTag;
import net.kyori.adventure.nbt.StringBinaryTag;

public class NBTAdapter {
    public static final MethodHandle COMPOUND_TAG_MAP_CONSTRUCTOR = ReflectionHelper.getConstructor(na.class, (Class[])new Class[]{Map.class});

    public static ns toNMS(BinaryTag tag) {
        if (tag instanceof ByteBinaryTag) {
            ByteBinaryTag byteTag = (ByteBinaryTag)tag;
            return switch (byteTag.value()) {
                case 0 -> my.b;
                case 1 -> my.c;
                default -> my.a((byte)byteTag.value());
            };
        }
        if (tag instanceof ShortBinaryTag) {
            ShortBinaryTag shortTag = (ShortBinaryTag)tag;
            return no.a((short)shortTag.value());
        }
        if (tag instanceof IntBinaryTag) {
            IntBinaryTag intTag = (IntBinaryTag)tag;
            return nf.a((int)intTag.value());
        }
        if (tag instanceof LongBinaryTag) {
            LongBinaryTag longTag = (LongBinaryTag)tag;
            return ni.a((long)longTag.value());
        }
        if (tag instanceof FloatBinaryTag) {
            FloatBinaryTag floatTag = (FloatBinaryTag)tag;
            return nd.a((float)floatTag.value());
        }
        if (tag instanceof DoubleBinaryTag) {
            DoubleBinaryTag doubleTag = (DoubleBinaryTag)tag;
            return nb.a((double)doubleTag.value());
        }
        if (tag instanceof ByteArrayBinaryTag) {
            ByteArrayBinaryTag byteArrayTag = (ByteArrayBinaryTag)tag;
            return new mx(byteArrayTag.value());
        }
        if (tag instanceof IntArrayBinaryTag) {
            IntArrayBinaryTag intArrayTag = (IntArrayBinaryTag)tag;
            return new ne(intArrayTag.value());
        }
        if (tag instanceof LongArrayBinaryTag) {
            LongArrayBinaryTag longArrayTag = (LongArrayBinaryTag)tag;
            return new nh(longArrayTag.value());
        }
        if (tag instanceof StringBinaryTag) {
            StringBinaryTag stringTag = (StringBinaryTag)tag;
            return nq.a((String)stringTag.value());
        }
        if (tag instanceof ListBinaryTag) {
            ListBinaryTag listTag = (ListBinaryTag)tag;
            return NBTAdapter.toNMS(listTag);
        }
        if (tag instanceof CompoundBinaryTag) {
            CompoundBinaryTag compoundTag = (CompoundBinaryTag)tag;
            return NBTAdapter.toNMS(compoundTag);
        }
        if (tag instanceof EndBinaryTag) {
            return nc.b;
        }
        throw new IllegalStateException("Unrecognized API tag of type '" + String.valueOf(tag.type()) + "': " + String.valueOf(tag));
    }

    public static BinaryTag toAPI(ns nmsTag) {
        if (nmsTag instanceof my) {
            my nmsByteTag = (my)nmsTag;
            return ByteBinaryTag.byteBinaryTag((byte)nmsByteTag.h());
        }
        if (nmsTag instanceof no) {
            no nmsShortTag = (no)nmsTag;
            return ShortBinaryTag.shortBinaryTag((short)nmsShortTag.g());
        }
        if (nmsTag instanceof nf) {
            nf nmsIntTag = (nf)nmsTag;
            return IntBinaryTag.intBinaryTag((int)nmsIntTag.f());
        }
        if (nmsTag instanceof ni) {
            ni nmsLongTag = (ni)nmsTag;
            return LongBinaryTag.longBinaryTag((long)nmsLongTag.e());
        }
        if (nmsTag instanceof nd) {
            nd nmsFloatTag = (nd)nmsTag;
            return FloatBinaryTag.floatBinaryTag((float)nmsFloatTag.j());
        }
        if (nmsTag instanceof nb) {
            nb nmsDoubleTag = (nb)nmsTag;
            return DoubleBinaryTag.doubleBinaryTag((double)nmsDoubleTag.i());
        }
        if (nmsTag instanceof mx) {
            mx nmsByteArrayTag = (mx)nmsTag;
            return ByteArrayBinaryTag.byteArrayBinaryTag((byte[])nmsByteArrayTag.d());
        }
        if (nmsTag instanceof ne) {
            ne nmsIntArrayTag = (ne)nmsTag;
            return IntArrayBinaryTag.intArrayBinaryTag((int[])nmsIntArrayTag.f());
        }
        if (nmsTag instanceof nh) {
            nh nmsLongArrayTag = (nh)nmsTag;
            return LongArrayBinaryTag.longArrayBinaryTag((long[])nmsLongArrayTag.f());
        }
        if (nmsTag instanceof nq) {
            nq nmsStringTag = (nq)nmsTag;
            return StringBinaryTag.stringBinaryTag((String)nmsStringTag.d_());
        }
        if (nmsTag instanceof ng) {
            ng nmsListTag = (ng)nmsTag;
            return NBTAdapter.toAPI(nmsListTag);
        }
        if (nmsTag instanceof na) {
            na nmsCompoundTag = (na)nmsTag;
            return NBTAdapter.toAPI(nmsCompoundTag);
        }
        if (nmsTag instanceof nc) {
            return EndBinaryTag.endBinaryTag();
        }
        throw new IllegalStateException("Unrecognized NMS tag of type '" + nmsTag.getClass().getName() + "/" + nmsTag.b().a() + "': " + String.valueOf(nmsTag));
    }

    public static ListBinaryTag toAPI(ng nmsListTag) {
        ListBinaryTag.Builder builder = ListBinaryTag.builder((int)nmsListTag.size());
        for (ns nmsValue : nmsListTag) {
            builder.add(NBTAdapter.toAPI(nmsValue));
        }
        return builder.build();
    }

    public static ng toNMS(ListBinaryTag listTag) {
        ng nmsListTag = new ng();
        for (BinaryTag value : listTag) {
            nmsListTag.add((Object)NBTAdapter.toNMS(value));
        }
        return nmsListTag;
    }

    public static CompoundBinaryTag toAPI(na nmsCompoundTag) {
        CompoundBinaryTag.Builder builder = CompoundBinaryTag.builder((int)nmsCompoundTag.e());
        for (String key : nmsCompoundTag.d()) {
            builder.put(key, NBTAdapter.toAPI(nmsCompoundTag.c(key)));
        }
        return builder.build();
    }

    public static na toNMS(CompoundBinaryTag compoundTag) {
        HashMap<String, ns> nmsTags = new HashMap<String, ns>(compoundTag.size());
        for (Map.Entry entry : compoundTag) {
            nmsTags.put((String)entry.getKey(), NBTAdapter.toNMS((BinaryTag)entry.getValue()));
        }
        try {
            return COMPOUND_TAG_MAP_CONSTRUCTOR.invokeExact(nmsTags);
        }
        catch (Throwable e2) {
            throw new RuntimeException(e2);
        }
    }
}

