/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.block;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.CrafterCraftEvent;

public class CrafterCraftsScriptEvent
extends BukkitScriptEvent
implements Listener {
    public LocationTag location;
    public ItemTag result;
    public CrafterCraftEvent event;

    public CrafterCraftsScriptEvent() {
        this.registerCouldMatcher("crafter crafts <item>");
        this.registerDetermination("item", ItemTag.class, (evt, context, result) -> this.event.setResult(result.getItemStack()));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        if (!path.tryArgObject(2, this.result)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "item" -> new ItemTag(this.event.getResult());
            case "location" -> this.location;
            case "recipe_id" -> new ElementTag(this.event.getRecipe().getKey().toString(), true);
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onCrafterCrafts(CrafterCraftEvent event) {
        this.location = new LocationTag(event.getBlock().getLocation());
        this.result = new ItemTag(event.getResult());
        this.event = event;
        this.fire((Event)event);
    }
}

