/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.properties.item.ItemCustomData;
import com.denizenscript.denizen.objects.properties.item.ItemProperty;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import com.denizenscript.shaded.net.adventure.nbt.BinaryTag;
import com.denizenscript.shaded.net.adventure.nbt.BinaryTagType;
import com.denizenscript.shaded.net.adventure.nbt.ByteArrayBinaryTag;
import com.denizenscript.shaded.net.adventure.nbt.ByteBinaryTag;
import com.denizenscript.shaded.net.adventure.nbt.CompoundBinaryTag;
import com.denizenscript.shaded.net.adventure.nbt.DoubleBinaryTag;
import com.denizenscript.shaded.net.adventure.nbt.EndBinaryTag;
import com.denizenscript.shaded.net.adventure.nbt.FloatBinaryTag;
import com.denizenscript.shaded.net.adventure.nbt.IntArrayBinaryTag;
import com.denizenscript.shaded.net.adventure.nbt.IntBinaryTag;
import com.denizenscript.shaded.net.adventure.nbt.ListBinaryTag;
import com.denizenscript.shaded.net.adventure.nbt.LongArrayBinaryTag;
import com.denizenscript.shaded.net.adventure.nbt.LongBinaryTag;
import com.denizenscript.shaded.net.adventure.nbt.ShortBinaryTag;
import com.denizenscript.shaded.net.adventure.nbt.StringBinaryTag;
import com.denizenscript.shaded.net.adventure.nbt.TagStringIO;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;

public class ItemRawNBT
extends ItemProperty<MapTag> {
    public static String[] defaultNbtKeys = new String[]{"Denizen Item Script", "DenizenItemScript", "Denizen NBT", "Denizen", "Damage", "Unbreakable", "CanDestroy", "CustomModelData", "trim", "display", "HideFlags", "CanPlaceOn", "BlockEntityTag", "BlockStateTag", "Enchantments", "StoredEnchantments", "RepairCost", "AttributeModifiers", "CustomPotionEffects", "Potion", "CustomPotionColor", "ChargedProjectiles", "Charged", "resolved", "generation", "author", "title", "pages", "SkullOwner", "Explosion", "Fireworks", "map", "map_scale_direction", "Effects", "LodestoneTracked", "Items", "instrument"};
    public static final BinaryTagType<?>[] BY_ID;
    public static final boolean HAS_NBT_LIST_TYPES;
    public static final TagStringIO SNBT_PARSER;

    public static boolean describes(ItemTag item) {
        return item.getBukkitMaterial() != Material.AIR;
    }

    public ItemRawNBT(ItemTag item) {
        this.object = item;
    }

    public MapTag getNonDefaultNBTMap() {
        MapTag entityMap;
        MapTag result = this.getFullNBTMap();
        for (String key : defaultNbtKeys) {
            result.remove(key);
        }
        if (this.getMaterial() == Material.ITEM_FRAME && (entityMap = (MapTag)result.getObject("EntityTag")) != null) {
            entityMap.putObject("Invisible", null);
            if (entityMap.isEmpty()) {
                result.putObject("EntityTag", null);
            }
        }
        if (this.getMaterial() == Material.ARMOR_STAND && (entityMap = (MapTag)result.getObject("EntityTag")) != null) {
            entityMap.putObject("Pose", null);
            entityMap.putObject("Small", null);
            entityMap.putObject("NoBasePlate", null);
            entityMap.putObject("Marker", null);
            entityMap.putObject("Invisible", null);
            entityMap.putObject("ShowArms", null);
            if (entityMap.isEmpty()) {
                result.putObject("EntityTag", null);
            }
        }
        return result;
    }

    public MapTag getFullNBTMap() {
        return (MapTag)ItemRawNBT.nbtTagToObject(NMSHandler.itemHelper.getNbtData(this.getItemStack()));
    }

    public static CompoundBinaryTag compoundOrEmpty(CompoundBinaryTag compoundTag) {
        return compoundTag != null ? compoundTag : CompoundBinaryTag.empty();
    }

    public static BinaryTag convertObjectToNbt(ObjectTag inputObject, TagContext context, String path) {
        if (inputObject.canBeType(MapTag.class)) {
            MapTag map = inputObject.asType(MapTag.class, context);
            CompoundBinaryTag.Builder resultBuilder = CompoundBinaryTag.builder(map.size());
            for (Map.Entry<StringHolder, ObjectTag> entry : map.entrySet()) {
                try {
                    resultBuilder.put(entry.getKey().str, ItemRawNBT.convertObjectToNbt(entry.getValue(), context, path + "." + entry.getKey().str));
                }
                catch (Exception ex) {
                    Debug.echoError("Object NBT interpretation failed for key '" + path + "." + entry.getKey().str + "'.");
                    Debug.echoError(ex);
                    return null;
                }
            }
            return resultBuilder.build();
        }
        if (!HAS_NBT_LIST_TYPES && inputObject.shouldBeType(ListTag.class)) {
            ListTag list = inputObject.asType(ListTag.class, context);
            ListBinaryTag.Builder<BinaryTag> resultBuilder = ListBinaryTag.heterogeneousListBinaryTag(list.size());
            for (int i = 0; i < list.size(); ++i) {
                try {
                    resultBuilder.add(ItemRawNBT.convertObjectToNbt(list.getObject(i), context, path + "[" + i + "]"));
                    continue;
                }
                catch (Exception ex) {
                    Debug.echoError("Object NBT interpretation failed for list key '" + path + "' at index " + i + ".");
                    Debug.echoError(ex);
                    return null;
                }
            }
            return resultBuilder.build();
        }
        String input = inputObject.identify();
        if (input.equals("end")) {
            return EndBinaryTag.endBinaryTag();
        }
        int colonIndex = input.indexOf(58);
        if (colonIndex == -1) {
            Debug.echoError("Object NBT interpretation failed for key '" + path + "': missing object type.");
            return null;
        }
        String type = input.substring(0, colonIndex);
        String value = input.substring(colonIndex + 1);
        return switch (type) {
            case "list" -> {
                int nextColonIndex = value.indexOf(58);
                int typeCode = Integer.parseInt(value.substring(0, nextColonIndex));
                String listValue = value.substring(nextColonIndex + 1);
                ArrayList<BinaryTag> result = new ArrayList<BinaryTag>();
                ListTag listTag = ListTag.valueOf(listValue, context);
                for (int i = 0; i < listTag.size(); ++i) {
                    try {
                        result.add(ItemRawNBT.convertObjectToNbt(listTag.getObject(i), context, path + "[" + i + "]"));
                        continue;
                    }
                    catch (Exception ex) {
                        Debug.echoError("Object NBT interpretation failed for list key '" + path + "' at index " + i + ".");
                        Debug.echoError(ex);
                        Object var9_34 = null;
                        yield var9_34;
                    }
                }
                ListBinaryTag var9_35 = ListBinaryTag.listBinaryTag(BY_ID[typeCode], result);
                yield var9_35;
            }
            case "byte_array" -> {
                ListTag numberStrings = ListTag.valueOf(value, context);
                byte[] result = new byte[numberStrings.size()];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = Byte.parseByte(numberStrings.get(i));
                }
                ByteArrayBinaryTag var9_36 = ByteArrayBinaryTag.byteArrayBinaryTag(result);
                yield var9_36;
            }
            case "int_array" -> {
                ListTag numberStrings = ListTag.valueOf(value, context);
                int[] result = new int[numberStrings.size()];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = Integer.parseInt(numberStrings.get(i));
                }
                IntArrayBinaryTag var9_37 = IntArrayBinaryTag.intArrayBinaryTag(result);
                yield var9_37;
            }
            case "long_array" -> {
                ListTag numberStrings = ListTag.valueOf(value, context);
                long[] result = new long[numberStrings.size()];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = Long.parseLong(numberStrings.get(i));
                }
                LongArrayBinaryTag var9_38 = LongArrayBinaryTag.longArrayBinaryTag(result);
                yield var9_38;
            }
            case "byte" -> {
                ByteBinaryTag var9_39 = ByteBinaryTag.byteBinaryTag(Byte.parseByte(value));
                yield var9_39;
            }
            case "short" -> {
                ShortBinaryTag var9_40 = ShortBinaryTag.shortBinaryTag(Short.parseShort(value));
                yield var9_40;
            }
            case "int" -> {
                IntBinaryTag var9_41 = IntBinaryTag.intBinaryTag(Integer.parseInt(value));
                yield var9_41;
            }
            case "long" -> {
                LongBinaryTag var9_42 = LongBinaryTag.longBinaryTag(Long.parseLong(value));
                yield var9_42;
            }
            case "float" -> {
                FloatBinaryTag var9_43 = FloatBinaryTag.floatBinaryTag(Float.parseFloat(value));
                yield var9_43;
            }
            case "double" -> {
                DoubleBinaryTag var9_44 = DoubleBinaryTag.doubleBinaryTag(Double.parseDouble(value));
                yield var9_44;
            }
            case "string" -> {
                StringBinaryTag var9_45;
                yield var9_45 = StringBinaryTag.stringBinaryTag(value);
            }
            default -> {
                if (context == null || context.showErrors()) {
                    Debug.echoError("Unknown raw NBT value: " + String.valueOf(inputObject));
                }
                Object var9_46 = null;
                yield var9_46;
            }
        };
    }

    public static ObjectTag nbtTagToObject(BinaryTag tag) {
        return ItemRawNBT.nbtTagToObject(tag, false);
    }

    public static ObjectTag nbtTagToObject(BinaryTag tag, boolean unwrapLists) {
        if (tag instanceof CompoundBinaryTag) {
            CompoundBinaryTag compoundTag = (CompoundBinaryTag)tag;
            MapTag result = new MapTag();
            for (Map.Entry entry : compoundTag) {
                result.putObject((String)entry.getKey(), ItemRawNBT.nbtTagToObject((BinaryTag)entry.getValue(), unwrapLists));
            }
            return result;
        }
        if (tag instanceof ListBinaryTag) {
            ListBinaryTag listTag = (ListBinaryTag)tag;
            if (!HAS_NBT_LIST_TYPES && unwrapLists) {
                listTag = listTag.unwrapHeterogeneity();
            }
            ListTag result = new ListTag(listTag.size());
            for (BinaryTag entry : listTag) {
                result.addObject(ItemRawNBT.nbtTagToObject(entry, unwrapLists));
            }
            return HAS_NBT_LIST_TYPES ? new ElementTag("list:" + listTag.elementType().id() + ":" + result.identify()) : result;
        }
        if (tag instanceof ByteArrayBinaryTag) {
            ByteArrayBinaryTag byteArrayTag = (ByteArrayBinaryTag)tag;
            byte[] data = byteArrayTag.value();
            StringBuilder output = new StringBuilder(data.length * 4);
            for (byte value : data) {
                output.append(value).append('|');
            }
            return new ElementTag("byte_array:" + String.valueOf(output));
        }
        if (tag instanceof IntArrayBinaryTag) {
            IntArrayBinaryTag intArrayTag = (IntArrayBinaryTag)tag;
            int[] data = intArrayTag.value();
            StringBuilder output = new StringBuilder(data.length * 4);
            for (int value : data) {
                output.append(value).append('|');
            }
            return new ElementTag("int_array:" + String.valueOf(output));
        }
        if (tag instanceof LongArrayBinaryTag) {
            LongArrayBinaryTag longArrayTag = (LongArrayBinaryTag)tag;
            long[] data = longArrayTag.value();
            StringBuilder output = new StringBuilder(data.length * 4);
            for (long value : data) {
                output.append(value).append('|');
            }
            return new ElementTag("long_array:" + String.valueOf(output));
        }
        if (tag instanceof ByteBinaryTag) {
            ByteBinaryTag byteTag = (ByteBinaryTag)tag;
            return new ElementTag("byte:" + byteTag.value());
        }
        if (tag instanceof ShortBinaryTag) {
            ShortBinaryTag shortTag = (ShortBinaryTag)tag;
            return new ElementTag("short:" + shortTag.value());
        }
        if (tag instanceof IntBinaryTag) {
            IntBinaryTag intTag = (IntBinaryTag)tag;
            return new ElementTag("int:" + intTag.value());
        }
        if (tag instanceof LongBinaryTag) {
            LongBinaryTag longTag = (LongBinaryTag)tag;
            return new ElementTag("long:" + longTag.value());
        }
        if (tag instanceof FloatBinaryTag) {
            FloatBinaryTag floatTag = (FloatBinaryTag)tag;
            return new ElementTag("float:" + floatTag.value());
        }
        if (tag instanceof DoubleBinaryTag) {
            DoubleBinaryTag doubleTag = (DoubleBinaryTag)tag;
            return new ElementTag("double:" + doubleTag.value());
        }
        if (tag instanceof StringBinaryTag) {
            StringBinaryTag stringTag = (StringBinaryTag)tag;
            return new ElementTag("string:" + stringTag.value());
        }
        if (tag instanceof EndBinaryTag) {
            return new ElementTag("end");
        }
        throw new IllegalStateException("Unrecognized API tag of type '" + String.valueOf(tag.type()) + "': " + String.valueOf(tag));
    }

    @Override
    public MapTag getPropertyValue() {
        if (NMSHandler.getVersion().isAtMost(NMSVersion.v1_19)) {
            MapTag nonDefaultNBT = this.getNonDefaultNBTMap();
            return nonDefaultNBT.isEmpty() ? null : nonDefaultNBT;
        }
        return null;
    }

    @Override
    public void setPropertyValue(MapTag value, Mechanism mechanism) {
        CompoundBinaryTag oldNbtData;
        if (NMSHandler.getVersion().isAtMost(NMSVersion.v1_19)) {
            this.setFullNBT((ItemTag)this.object, value, mechanism.context, true);
            return;
        }
        BukkitImplDeprecations.oldNbtProperty.warn(mechanism.context);
        try {
            oldNbtData = (CompoundBinaryTag)ItemRawNBT.convertObjectToNbt(value, mechanism.context, "(item)");
        }
        catch (Exception ex) {
            mechanism.echoError("Invalid NBT data specified:");
            Debug.echoError(ex);
            return;
        }
        if (oldNbtData == null) {
            mechanism.echoError("Invalid NBT data specified.");
            return;
        }
        this.setItemStack(NMSHandler.itemHelper.setPartialOldNbt(this.getItemStack(), oldNbtData));
    }

    public static void register() {
        PropertyParser.registerTag(ItemRawNBT.class, MapTag.class, "raw_nbt", (attribute, prop) -> {
            if (NMSHandler.getVersion().isAtMost(NMSVersion.v1_19)) {
                return prop.getPropertyValue();
            }
            BukkitImplDeprecations.oldNbtProperty.warn(attribute.context);
            return new ItemCustomData((ItemTag)prop.object).getPropertyValue();
        }, new String[0]);
        PropertyParser.registerMechanism(ItemRawNBT.class, MapTag.class, "raw_nbt", (prop, mechanism, value) -> prop.setPropertyValue((MapTag)value, mechanism), new String[0]);
        PropertyParser.registerTag(ItemRawNBT.class, MapTag.class, "all_raw_nbt", (attribute, prop) -> prop.getFullNBTMap(), new String[0]);
    }

    @Override
    public String getPropertyId() {
        return "raw_nbt";
    }

    public void setFullNBT(ItemTag item, MapTag input, TagContext context, boolean retainOld) {
        CompoundBinaryTag currentTag = retainOld ? NMSHandler.itemHelper.getNbtData(item.getItemStack()) : null;
        CompoundBinaryTag.Builder compoundTagBuilder = currentTag != null ? (CompoundBinaryTag.Builder)CompoundBinaryTag.builder().put(currentTag) : CompoundBinaryTag.builder();
        for (Map.Entry<StringHolder, ObjectTag> entry : input.entrySet()) {
            try {
                BinaryTag tag = ItemRawNBT.convertObjectToNbt(entry.getValue(), context, "(item).");
                if (tag == null) continue;
                compoundTagBuilder.put(entry.getKey().str, tag);
            }
            catch (Exception ex) {
                Debug.echoError("Raw_Nbt input failed for root key '" + entry.getKey().str + "'.");
                Debug.echoError(ex);
                return;
            }
        }
        item.setItemStack(NMSHandler.itemHelper.setNbtData(item.getItemStack(), compoundTagBuilder.build()));
    }

    static {
        HAS_NBT_LIST_TYPES = NMSHandler.getVersion().isAtMost(NMSVersion.v1_20);
        SNBT_PARSER = TagStringIO.builder().emitHeterogeneousLists(HAS_NBT_LIST_TYPES).acceptHeterogeneousLists(!HAS_NBT_LIST_TYPES).build();
        List allTypes = (List)ReflectionHelper.getFieldValue(BinaryTagType.class, "TYPES", null);
        BY_ID = new BinaryTagType[allTypes.size()];
        Iterator iterator = allTypes.iterator();
        while (iterator.hasNext()) {
            BinaryTagType type;
            ItemRawNBT.BY_ID[type.id()] = type = (BinaryTagType)iterator.next();
        }
    }
}

