/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.helpers;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.interfaces.EntityHelper;
import com.denizenscript.denizen.nms.v1_21.Handler;
import com.denizenscript.denizen.nms.v1_21.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_21.helpers.BlockHelperImpl;
import com.denizenscript.denizen.nms.v1_21.helpers.EntityDataNameMapper;
import com.denizenscript.denizen.nms.v1_21.helpers.NBTAdapter;
import com.denizenscript.denizen.nms.v1_21.helpers.PacketHelperImpl;
import com.denizenscript.denizen.nms.v1_21.impl.network.handlers.DenizenNetworkManagerImpl;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.packets.NetworkInterceptHelper;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.scripts.commands.core.ReflectionSetCommand;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_21_R7.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftAbstractHorse;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEnderman;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftExperienceOrb;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftFallingBlock;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftItem;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftMob;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftZombie;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftLocation;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;

public class EntityHelperImpl
extends EntityHelper {
    public static final MethodHandle ENTITY_ONGROUND_SETTER = ReflectionHelper.getFinalSetter(cgk.class, (String)ReflectionMappingsInfo.Entity_onGround, Boolean.TYPE);
    public static final alw<Boolean> ENDERMAN_DATA_ACCESSOR_SCREAMING = (alw)ReflectionHelper.getFieldValue(czs.class, (String)ReflectionMappingsInfo.EnderMan_DATA_CREEPY, null);
    public static final MethodHandle LIVINGENTITY_AUTOSPINATTACK_SETTER = ReflectionHelper.getFinalSetter(chl.class, (String)ReflectionMappingsInfo.LivingEntity_autoSpinAttackTicks);
    public static final MethodHandle LIVINGENTITY_SETLIVINGENTITYFLAG = ReflectionHelper.getMethodHandle(chl.class, (String)ReflectionMappingsInfo.LivingEntity_setLivingEntityFlag_method, (Class[])new Class[]{Integer.TYPE, Boolean.TYPE});
    private static final Map<UUID, BukkitTask> followTasks = new HashMap<UUID, BukkitTask>();
    public static final Field EXPERIENCE_ORB_AGE = ReflectionHelper.getFields(cgz.class).get(ReflectionMappingsInfo.ExperienceOrb_age, Integer.TYPE);
    public static cey backupDamageSources;
    public static final Field FALLINGBLOCK_BLOCK_STATE;
    public static final Field ZOMBIE_INWATERTIME;
    public static final MethodHandle TRACKING_RANGE_SETTER;
    public static final MethodHandle PLAYERLIST_REMOVE;
    public static final Field SynchedEntityData_itemsById;

    public void setInvisible(Entity entity, boolean invisible) {
        ((CraftEntity)entity).getHandle().l(invisible);
    }

    public boolean isInvisible(Entity entity) {
        return ((CraftEntity)entity).getHandle().cG();
    }

    public void setPose(Entity entity, Pose pose) {
        ((CraftEntity)entity).getHandle().c(chx.values()[pose.ordinal()]);
    }

    public double getDamageTo(LivingEntity attacker, Entity target) {
        chl living;
        chl nmsLivingTarget;
        cex source;
        double damage = 0.0;
        AttributeInstance attrib = attacker.getAttribute(Attribute.ATTACK_DAMAGE);
        if (attrib != null) {
            damage = attrib.getValue();
        }
        if (damage <= 0.0) {
            return 0.0;
        }
        if (target == null) {
            target = attacker;
        }
        cgk nmsTarget = ((CraftEntity)target).getHandle();
        axf nmsWorld = ((CraftWorld)attacker.getWorld()).getHandle();
        if (attacker instanceof CraftPlayer) {
            CraftPlayer playerAttacker = (CraftPlayer)attacker;
            source = nmsTarget.ao().as().a((ddm)playerAttacker.getHandle());
        } else {
            source = nmsTarget.ao().as().b(((CraftLivingEntity)attacker).getHandle());
        }
        chl chl2 = nmsLivingTarget = nmsTarget instanceof chl ? (living = (chl)nmsTarget) : null;
        if (nmsLivingTarget != null ? nmsLivingTarget.a(nmsWorld, source) : nmsTarget.d(source)) {
            return 0.0;
        }
        if (attacker.getEquipment() != null) {
            damage = dsq.a((axf)nmsWorld, (dlt)CraftItemStack.asNMSCopy((ItemStack)attacker.getEquipment().getItemInMainHand()), (cgk)nmsTarget, (cex)source, (float)((float)damage));
        }
        if (nmsLivingTarget == null) {
            return damage;
        }
        damage = cet.a((chl)nmsLivingTarget, (float)((float)damage), (cex)source, (float)nmsLivingTarget.fn(), (float)((float)nmsLivingTarget.i(cis.c)));
        float enchantDamageModifier = dsq.b((axf)nmsWorld, (chl)nmsLivingTarget, (cex)source);
        if (enchantDamageModifier > 0.0f) {
            damage = cet.a((float)((float)damage), (float)enchantDamageModifier);
        }
        return damage;
    }

    public void setRiptide(Entity entity, boolean state) {
        try {
            chl nmsEntity = ((CraftLivingEntity)entity).getHandle();
            LIVINGENTITY_AUTOSPINATTACK_SETTER.invoke(nmsEntity, state ? 0 : 1);
            LIVINGENTITY_SETLIVINGENTITYFLAG.invoke(nmsEntity, 4, true);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void forceInteraction(Player player, Location location) {
        axg nmsPlayer = ((CraftPlayer)player).getHandle();
        ((CraftBlock)location.getBlock()).getNMS().a(nmsPlayer.fx(), (dwo)((CraftWorld)location.getWorld()).getHandle(), (ddm)nmsPlayer, cdb.a, new fti(new ftm(0.0, 0.0, 0.0), null, CraftLocation.toBlockPosition((Location)location), false));
    }

    public CompoundBinaryTag getNbtData(Entity entity) {
        uz nmsTag = Handler.useValueOutput(arg_0 -> ((cgk)((CraftEntity)entity).getHandle()).b(arg_0));
        return NBTAdapter.toAPI(nmsTag);
    }

    public void setNbtData(Entity entity, CompoundBinaryTag compoundTag) {
        Handler.useValueInput(NBTAdapter.toNMS(compoundTag), arg_0 -> ((cgk)((CraftEntity)entity).getHandle()).d(arg_0));
    }

    public void stopFollowing(Entity follower) {
        if (follower == null) {
            return;
        }
        UUID uuid = follower.getUniqueId();
        if (followTasks.containsKey(uuid)) {
            followTasks.get(uuid).cancel();
        }
    }

    public void stopWalking(Entity entity) {
        cgk cgk2 = ((CraftEntity)entity).getHandle();
        if (cgk2 instanceof chn) {
            chn nmsMob = (chn)cgk2;
            nmsMob.N().n();
        }
    }

    public void follow(final Entity target, final Entity follower, final double speed, final double lead, final double maxRange, final boolean allowWander, final boolean teleport) {
        if (target == null || follower == null) {
            return;
        }
        cgk nmsEntityFollower = ((CraftEntity)follower).getHandle();
        if (!(nmsEntityFollower instanceof chn)) {
            return;
        }
        final chn nmsFollower = (chn)nmsEntityFollower;
        final cre followerNavigation = nmsFollower.N();
        UUID uuid = follower.getUniqueId();
        if (followTasks.containsKey(uuid)) {
            followTasks.get(uuid).cancel();
        }
        final int locationNearInt = (int)Math.floor(lead);
        final boolean hasMax = maxRange > lead;
        followTasks.put(follower.getUniqueId(), new BukkitRunnable(){
            private boolean inRadius = false;

            public void run() {
                if (!target.isValid() || !follower.isValid()) {
                    this.cancel();
                }
                followerNavigation.a(2.0);
                Location targetLocation = target.getLocation();
                if (hasMax && !Utilities.checkLocation((Location)targetLocation, (Location)follower.getLocation(), (double)maxRange) && !target.isDead() && target.isOnGround()) {
                    if (!this.inRadius) {
                        if (teleport) {
                            follower.teleport(Utilities.getWalkableLocationNear((Location)targetLocation, (int)locationNearInt));
                        } else {
                            this.cancel();
                        }
                    } else {
                        this.inRadius = false;
                        flp path = followerNavigation.a(targetLocation.getX(), targetLocation.getY(), targetLocation.getZ(), 0);
                        if (path != null) {
                            followerNavigation.a(path, 1.0);
                            followerNavigation.a(2.0);
                        }
                    }
                } else if (!this.inRadius && !Utilities.checkLocation((Location)targetLocation, (Location)follower.getLocation(), (double)lead)) {
                    flp path = followerNavigation.a(targetLocation.getX(), targetLocation.getY(), targetLocation.getZ(), 0);
                    if (path != null) {
                        followerNavigation.a(path, 1.0);
                        followerNavigation.a(2.0);
                    }
                } else {
                    this.inRadius = true;
                }
                if (this.inRadius && !allowWander) {
                    followerNavigation.n();
                }
                nmsFollower.h(cis.x).a(speed);
            }
        }.runTaskTimer((Plugin)NMSHandler.getJavaPlugin(), 0L, 10L));
    }

    public void walkTo(final LivingEntity entity, Location location, final Double speed, final Runnable callback) {
        flp path;
        boolean aiDisabled;
        if (entity == null || location == null) {
            return;
        }
        cgk nmsEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntity instanceof chn)) {
            return;
        }
        final chn nmsMob = (chn)nmsEntity;
        final cre entityNavigation = nmsMob.N();
        boolean bl = aiDisabled = !entity.hasAI();
        if (aiDisabled) {
            entity.setAI(true);
            try {
                ENTITY_ONGROUND_SETTER.invoke(nmsMob, true);
            }
            catch (Throwable ex) {
                Debug.echoError((Throwable)ex);
            }
        }
        if ((path = entityNavigation.a(location.getX(), location.getY(), location.getZ(), 1)) != null) {
            nmsMob.cs.b(cop.a.a);
            entityNavigation.a(path, 1.0);
            final double oldSpeed = nmsMob.h(cis.x).b();
            if (speed != null) {
                nmsMob.h(cis.x).a(speed.doubleValue());
            }
            new BukkitRunnable(){

                public void run() {
                    if (!entity.isValid()) {
                        if (callback != null) {
                            callback.run();
                        }
                        this.cancel();
                        return;
                    }
                    if (aiDisabled && entity instanceof Wolf) {
                        Wolf wolf = (Wolf)entity;
                        wolf.setAngry(false);
                    }
                    if (entityNavigation.l() || path.c()) {
                        if (callback != null) {
                            callback.run();
                        }
                        if (speed != null) {
                            nmsMob.h(cis.x).a(oldSpeed);
                        }
                        if (aiDisabled) {
                            entity.setAI(false);
                        }
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)NMSHandler.getJavaPlugin(), 1L, 1L);
        } else {
            entity.teleport(location);
        }
    }

    public void sendAllUpdatePackets(Entity entity) {
        awj tracker = ((axf)((CraftEntity)entity).getHandle().ao()).p().a;
        awj.b entityTracker = (awj.b)tracker.G.get(entity.getEntityId());
        if (entityTracker == null) {
            return;
        }
        try {
            axd serverEntity = (axd)PacketHelperImpl.ENTITY_TRACKER_ENTRY_GETTER.get(entityTracker);
            serverEntity.a();
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void sendHidePacket(Player pl, Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            pl.hidePlayer((Plugin)Denizen.getInstance(), player);
            return;
        }
        axg nmsPlayer = ((CraftPlayer)pl).getHandle();
        if (nmsPlayer.g != null && !pl.equals((Object)entity)) {
            awj.b entry = (awj.b)nmsPlayer.A().p().a.G.get(entity.getEntityId());
            if (entry != null) {
                entry.a(nmsPlayer);
            }
            if (Denizen.supportsPaper) {
                nmsPlayer.g.b((aay)new afv(new int[]{entity.getEntityId()}));
            }
        }
    }

    public void sendShowPacket(Player pl, Entity entity) {
        awj.b entry;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            pl.showPlayer((Plugin)Denizen.getInstance(), player);
            return;
        }
        axg nmsPlayer = ((CraftPlayer)pl).getHandle();
        if (nmsPlayer.g != null && !pl.equals((Object)entity) && (entry = (awj.b)nmsPlayer.A().p().a.G.get(entity.getEntityId())) != null) {
            entry.a(nmsPlayer);
            entry.b(nmsPlayer);
        }
    }

    public void rotate(Entity entity, float yaw, float pitch) {
        Player player;
        if (entity instanceof Player && (player = (Player)entity).isOnline()) {
            NetworkInterceptHelper.enable();
            float relYaw = (yaw - entity.getLocation().getYaw()) % 360.0f;
            if (relYaw > 180.0f) {
                relYaw -= 360.0f;
            }
            float actualRelYaw = relYaw;
            float relPitch = pitch - entity.getLocation().getPitch();
            NMSHandler.packetHelper.sendRelativeLookPacket(player, actualRelYaw, relPitch);
        } else if (entity instanceof LivingEntity) {
            if (entity instanceof EnderDragon) {
                yaw = EntityHelperImpl.normalizeYaw((float)(yaw - 180.0f));
            }
            this.look(entity, yaw, pitch);
        } else {
            cgk handle = ((CraftEntity)entity).getHandle();
            handle.v(yaw - 360.0f);
            handle.w(pitch);
        }
    }

    public float getBaseYaw(LivingEntity entity) {
        return ((CraftLivingEntity)entity).getHandle().bC;
    }

    public void look(Entity entity, float yaw, float pitch) {
        cgk handle = ((CraftEntity)entity).getHandle();
        if (handle == null) {
            Debug.echoError((String)("Cannot set look direction for unspawned entity " + String.valueOf(entity.getUniqueId())));
            return;
        }
        handle.v(yaw);
        if (handle instanceof chl) {
            chl nmsLivingEntity = (chl)handle;
            while (yaw < -180.0f) {
                yaw += 360.0f;
            }
            while (yaw >= 180.0f) {
                yaw -= 360.0f;
            }
            nmsLivingEntity.bD = yaw;
            if (!(handle instanceof ddm)) {
                nmsLivingEntity.s(yaw);
            }
            nmsLivingEntity.r(yaw);
        }
        handle.w(pitch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ftk rayTrace(World world, Vector start, Vector end) {
        try {
            NMSHandler.chunkHelper.changeChunkServerThread(world);
            fti fti2 = ((CraftWorld)world).getHandle().a(new dvw(new ftm(start.getX(), start.getY(), start.getZ()), new ftm(end.getX(), end.getY(), end.getZ()), dvw.a.b, dvw.b.a, ftr.a()));
            return fti2;
        }
        finally {
            NMSHandler.chunkHelper.restoreServerThread(world);
        }
    }

    public boolean canTrace(World world, Vector start, Vector end) {
        ftk pos = EntityHelperImpl.rayTrace(world, start, end);
        if (pos == null) {
            return true;
        }
        return pos.d() == ftk.a.a;
    }

    public void snapPositionTo(Entity entity, Vector vector) {
        ((CraftEntity)entity).getHandle().n(vector.getX(), vector.getY(), vector.getZ());
    }

    public void move(Entity entity, Vector vector) {
        ((CraftEntity)entity).getHandle().a(chp.a, new ftm(vector.getX(), vector.getY(), vector.getZ()));
    }

    public boolean internalLook(Player player, Location at) {
        PacketHelperImpl.send(player, new afo(ep.a.b, at.getX(), at.getY(), at.getZ()));
        return true;
    }

    public static long entityToPacket(double x) {
        return bgj.d((double)(x * 4096.0));
    }

    public void fakeMove(Entity entity, Vector vector) {
        long x = EntityHelperImpl.entityToPacket(vector.getX());
        long y = EntityHelperImpl.entityToPacket(vector.getY());
        long z = EntityHelperImpl.entityToPacket(vector.getZ());
        afa.a packet = new afa.a(entity.getEntityId(), (short)x, (short)y, (short)z, entity.isOnGround());
        for (Player player : this.getPlayersThatSee(entity)) {
            PacketHelperImpl.send(player, packet);
        }
    }

    public void fakeTeleport(Entity entity, Location location) {
        wx packetData = new wx(Unpooled.buffer());
        packetData.c(entity.getEntityId());
        packetData.a(location.getX());
        packetData.a(location.getY());
        packetData.a(location.getZ());
        packetData.l((int)((byte)(location.getYaw() * 256.0f / 360.0f)));
        packetData.l((int)((byte)(location.getPitch() * 256.0f / 360.0f)));
        packetData.a(entity.isOnGround());
        aho packet = (aho)aho.a.decode((Object)packetData);
        for (Player player : this.getPlayersThatSee(entity)) {
            PacketHelperImpl.send(player, packet);
        }
    }

    public void clientResetLoc(Entity entity) {
        aho packet = new aho(entity.getEntityId(), chy.a((cgk)((CraftEntity)entity).getHandle()), Set.of(), entity.isOnGround());
        for (Player player : this.getPlayersThatSee(entity)) {
            PacketHelperImpl.send(player, packet);
        }
    }

    public void teleport(Entity entity, Location loc) {
        cgk nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.v(loc.getYaw());
        nmsEntity.w(loc.getPitch());
        if (nmsEntity instanceof axg) {
            nmsEntity.b(loc.getX(), loc.getY(), loc.getZ());
        }
        nmsEntity.a_(loc.getX(), loc.getY(), loc.getZ());
    }

    public void setBoundingBox(Entity entity, BoundingBox box) {
        ((CraftEntity)entity).getHandle().a(new fth(box.getMinX(), box.getMinY(), box.getMinZ(), box.getMaxX(), box.getMaxY(), box.getMaxZ()));
    }

    public void setTicksLived(Entity entity, int ticks) {
        ((CraftEntity)entity).getHandle().at = ticks;
        if (entity instanceof CraftFallingBlock) {
            CraftFallingBlock craftFallingBlock = (CraftFallingBlock)entity;
            craftFallingBlock.getHandle().a = ticks;
        } else if (entity instanceof CraftItem) {
            CraftItem craftItem = (CraftItem)entity;
            craftItem.getHandle().k = ticks;
        } else if (entity instanceof CraftExperienceOrb) {
            CraftExperienceOrb craftExperienceOrb = (CraftExperienceOrb)entity;
            try {
                EXPERIENCE_ORB_AGE.setInt(craftExperienceOrb.getHandle(), ticks);
            }
            catch (Throwable ex) {
                Debug.echoError((Throwable)ex);
            }
        }
    }

    public void setHeadAngle(LivingEntity entity, float angle) {
        ((CraftLivingEntity)entity).getHandle().r(angle);
    }

    public void setEndermanAngry(Enderman enderman, boolean angry) {
        ((CraftEnderman)enderman).getHandle().aD().a(ENDERMAN_DATA_ACCESSOR_SCREAMING, (Object)angry);
    }

    public static cey getReusableDamageSources() {
        if (backupDamageSources == null) {
            backupDamageSources = ((CraftWorld)Bukkit.getWorlds().get(0)).getHandle().as();
        }
        return backupDamageSources;
    }

    public static cex getSourceFor(cgk nmsSource, EntityDamageEvent.DamageCause cause, cgk nmsSourceProvider) {
        cey sources = nmsSourceProvider == null ? EntityHelperImpl.getReusableDamageSources() : nmsSourceProvider.ao().as();
        cex src = sources.p();
        if (nmsSource != null) {
            if (nmsSource instanceof ddm) {
                ddm nmsPlayer = (ddm)nmsSource;
                src = nmsSource.ao().as().a(nmsPlayer);
            } else if (nmsSource instanceof chl) {
                chl nmsLivingEntity = (chl)nmsSource;
                src = nmsSource.ao().as().b(nmsLivingEntity);
            }
        }
        if (cause == null) {
            return src;
        }
        return switch (cause) {
            default -> throw new IncompatibleClassChangeError();
            case EntityDamageEvent.DamageCause.CONTACT -> sources.k();
            case EntityDamageEvent.DamageCause.ENTITY_ATTACK -> {
                chl nmsLivingEntity;
                yield sources.b(nmsSource instanceof chl ? (nmsLivingEntity = (chl)nmsSource) : null);
            }
            case EntityDamageEvent.DamageCause.ENTITY_SWEEP_ATTACK -> {
                if (src != sources.p()) {
                    yield src.sweep();
                }
                yield src;
            }
            case EntityDamageEvent.DamageCause.PROJECTILE -> {
                cgk v1;
                Projectile projectile;
                CraftEntity var7_7;
                if (nmsSource != null && (var7_7 = nmsSource.getBukkitEntity()) instanceof Projectile && (var7_7 = (projectile = (Projectile)var7_7).getShooter()) instanceof CraftEntity) {
                    CraftEntity shooter = var7_7;
                    v1 = shooter.getHandle();
                } else {
                    v1 = null;
                }
                yield sources.b(nmsSource, v1);
            }
            case EntityDamageEvent.DamageCause.SUFFOCATION -> sources.g();
            case EntityDamageEvent.DamageCause.FALL -> sources.l();
            case EntityDamageEvent.DamageCause.FIRE -> sources.a();
            case EntityDamageEvent.DamageCause.FIRE_TICK -> sources.d();
            case EntityDamageEvent.DamageCause.MELTING -> sources.melting();
            case EntityDamageEvent.DamageCause.LAVA -> sources.e();
            case EntityDamageEvent.DamageCause.DROWNING -> sources.i();
            case EntityDamageEvent.DamageCause.BLOCK_EXPLOSION -> {
                if (nmsSource instanceof czm) {
                    czm primedTnt = (czm)nmsSource;
                    yield sources.d((cgk)primedTnt, (cgk)primedTnt.e());
                }
                yield sources.a(null);
            }
            case EntityDamageEvent.DamageCause.ENTITY_EXPLOSION -> sources.d(nmsSource, null);
            case EntityDamageEvent.DamageCause.VOID -> sources.o();
            case EntityDamageEvent.DamageCause.LIGHTNING -> sources.c();
            case EntityDamageEvent.DamageCause.STARVATION -> sources.j();
            case EntityDamageEvent.DamageCause.POISON -> sources.poison();
            case EntityDamageEvent.DamageCause.MAGIC -> sources.q();
            case EntityDamageEvent.DamageCause.WITHER -> sources.r();
            case EntityDamageEvent.DamageCause.FALLING_BLOCK -> sources.a(nmsSource);
            case EntityDamageEvent.DamageCause.THORNS -> sources.d(nmsSource);
            case EntityDamageEvent.DamageCause.DRAGON_BREATH -> sources.s();
            case EntityDamageEvent.DamageCause.CUSTOM -> sources.p();
            case EntityDamageEvent.DamageCause.FLY_INTO_WALL -> sources.n();
            case EntityDamageEvent.DamageCause.HOT_FLOOR -> sources.f();
            case EntityDamageEvent.DamageCause.CAMPFIRE -> sources.b();
            case EntityDamageEvent.DamageCause.CRAMMING -> sources.h();
            case EntityDamageEvent.DamageCause.DRYOUT -> sources.t();
            case EntityDamageEvent.DamageCause.FREEZE -> sources.v();
            case EntityDamageEvent.DamageCause.SONIC_BOOM -> sources.e(nmsSource);
            case EntityDamageEvent.DamageCause.WORLD_BORDER -> sources.x();
            case EntityDamageEvent.DamageCause.KILL -> sources.y();
            case EntityDamageEvent.DamageCause.SUICIDE -> new FakeDamageSrc(src);
        };
    }

    public void damage(LivingEntity target, float amount, EntityTag source, Location sourceLoc, EntityDamageEvent.DamageCause cause) {
        chl nmsTarget;
        if (target == null) {
            return;
        }
        cgk nmsSource = source == null ? null : ((CraftEntity)source.getBukkitEntity()).getHandle();
        cex src = EntityHelperImpl.getSourceFor(nmsSource, cause, (cgk)(nmsTarget = ((CraftLivingEntity)target).getHandle()));
        if (src instanceof FakeDamageSrc) {
            FakeDamageSrc fakeDamageSrc = (FakeDamageSrc)src;
            src = fakeDamageSrc.real;
            if (EntityHelperImpl.fireFakeDamageEvent((Entity)target, (EntityTag)source, (Location)sourceLoc, (EntityDamageEvent.DamageCause)cause, (float)amount).isCancelled()) {
                return;
            }
        }
        nmsTarget.a(src, amount);
    }

    public void setLastHurtBy(LivingEntity mob, LivingEntity damager) {
        ((CraftLivingEntity)mob).getHandle().a(((CraftLivingEntity)damager).getHandle());
    }

    public void setFallingBlockType(FallingBlock fallingBlock, BlockData block) {
        eoh state = ((CraftBlockData)block).getState();
        czk nmsEntity = ((CraftFallingBlock)fallingBlock).getHandle();
        try {
            FALLINGBLOCK_BLOCK_STATE.set(nmsEntity, state);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public EntityTag getMobSpawnerDisplayEntity(CreatureSpawner spawner) {
        emw nmsSpawner = (emw)BlockHelperImpl.getTE((CraftCreatureSpawner)spawner);
        axf level = ((CraftWorld)spawner.getWorld()).getHandle();
        cgk nmsEntity = nmsSpawner.c().b((dwo)level, nmsSpawner.aD_());
        return new EntityTag((Entity)nmsEntity.getBukkitEntity());
    }

    public int getInWaterTime(Zombie zombie) {
        try {
            return ZOMBIE_INWATERTIME.getInt(((CraftZombie)zombie).getHandle());
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
            return 0;
        }
    }

    public void setInWaterTime(Zombie zombie, int ticks) {
        try {
            ZOMBIE_INWATERTIME.setInt(((CraftZombie)zombie).getHandle(), ticks);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void setTrackingRange(Entity entity, int range) {
        try {
            awj map = ((CraftWorld)entity.getWorld()).getHandle().p().a;
            awj.b entry = (awj.b)map.G.get(entity.getEntityId());
            if (entry != null) {
                TRACKING_RANGE_SETTER.invoke(entry, range);
            }
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public boolean isAggressive(Mob mob) {
        return ((CraftMob)mob).getHandle().gI();
    }

    public void setAggressive(Mob mob, boolean aggressive) {
        ((CraftMob)mob).getHandle().w(aggressive);
    }

    public void setUUID(Entity entity, UUID id) {
        try {
            axg nmsPlayer;
            cgk nmsEntity = ((CraftEntity)entity).getHandle();
            nmsEntity.cf();
            nmsEntity.dn().forEach(cgk::cf);
            dwo level = nmsEntity.ao();
            arx playerList = ((CraftServer)Bukkit.getServer()).getHandle();
            if (nmsEntity instanceof axg) {
                nmsPlayer = (axg)nmsEntity;
                PLAYERLIST_REMOVE.invoke(playerList, nmsPlayer);
            } else {
                nmsEntity.a(cgk.e.b);
            }
            nmsEntity.ej();
            nmsEntity.a(id);
            if (nmsEntity instanceof axg) {
                nmsPlayer = (axg)nmsEntity;
                playerList.a(DenizenNetworkManagerImpl.getConnection(nmsPlayer), nmsPlayer, new axu(nmsPlayer.gI(), nmsPlayer.g.k(), nmsPlayer.E(), nmsPlayer.g.isTransferred()));
            } else {
                level.b(nmsEntity);
            }
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public static Int2ObjectMap<ama.b<Object>> getDataItems(Entity entity) {
        try {
            return (Int2ObjectMap)SynchedEntityData_itemsById.get(((CraftEntity)entity).getHandle().aD());
        }
        catch (IllegalAccessException e2) {
            throw new RuntimeException(e2);
        }
    }

    public static void convertToInternalData(Entity entity, MapTag internalData, BiConsumer<ama.b<Object>, Object> processConverted) {
        Int2ObjectMap<ama.b<Object>> dataItemsById = EntityHelperImpl.getDataItems(entity);
        for (Map.Entry entry : internalData.entrySet()) {
            int id = EntityDataNameMapper.getIdForName(((CraftEntity)entity).getHandle().getClass(), ((StringHolder)entry.getKey()).low);
            if (id == -1) {
                Debug.echoError((String)("Invalid internal data key: " + String.valueOf(entry.getKey())));
                return;
            }
            ama.b dataItem = (ama.b)dataItemsById.get(id);
            if (dataItem == null) {
                Debug.echoError((String)("Invalid internal data id '" + id + "': couldn't be matched to any internal data for entity of type '" + String.valueOf(entity.getType()) + "'."));
                return;
            }
            Object converted = ReflectionSetCommand.convertObjectTypeFor(dataItem.b().getClass(), (ObjectTag)((ObjectTag)entry.getValue()));
            if (converted == null) continue;
            processConverted.accept((ama.b<Object>)dataItem, converted);
        }
    }

    public List<Object> convertInternalEntityDataValues(Entity entity, MapTag internalData) {
        ArrayList<Object> dataValues = new ArrayList<Object>(internalData.size());
        EntityHelperImpl.convertToInternalData(entity, internalData, (dataItem, converted) -> dataValues.add(PacketHelperImpl.createEntityData(dataItem.a(), converted)));
        return dataValues;
    }

    public void modifyInternalEntityData(Entity entity, MapTag internalData) {
        ama nmsEntityData = ((CraftEntity)entity).getHandle().aD();
        EntityHelperImpl.convertToInternalData(entity, internalData, (dataItem, converted) -> nmsEntityData.a(dataItem.a(), converted));
    }

    public void startUsingItem(LivingEntity entity, EquipmentSlot hand) {
        ((CraftLivingEntity)entity).getHandle().c(hand == EquipmentSlot.HAND ? cdb.a : cdb.b);
    }

    public void stopUsingItem(LivingEntity entity) {
        ((CraftLivingEntity)entity).getHandle().gf();
    }

    public void openHorseInventory(Player player, AbstractHorse horse) {
        cup nmsHorse = ((CraftAbstractHorse)horse).getHandle();
        ((CraftPlayer)player).getHandle().a(nmsHorse, (ccv)nmsHorse.cM);
    }

    private uz getRawEntityNBT(cgk entity) {
        return Handler.useValueOutput(arg_0 -> ((cgk)entity).d(arg_0));
    }

    public CompoundBinaryTag getRawNBT(Entity entity) {
        return NBTAdapter.toAPI(this.getRawEntityNBT(((CraftEntity)entity).getHandle()));
    }

    public void modifyRawNBT(Entity entity, CompoundBinaryTag tag) {
        cgk nmsEntity = ((CraftEntity)entity).getHandle();
        uz nmsTag = NBTAdapter.toNMS(tag);
        uz nmsMergedTag = this.getRawEntityNBT(nmsEntity).a(nmsTag);
        UUID uuid = nmsEntity.cY();
        Handler.useValueInput(nmsMergedTag, arg_0 -> ((cgk)nmsEntity).d(arg_0));
        nmsEntity.a(uuid);
    }

    static {
        FALLINGBLOCK_BLOCK_STATE = ReflectionHelper.getFields(czk.class).getFirstOfType(eoh.class);
        ZOMBIE_INWATERTIME = ReflectionHelper.getFields(dcn.class).get(ReflectionMappingsInfo.Zombie_inWaterTime, Integer.TYPE);
        TRACKING_RANGE_SETTER = ReflectionHelper.getFinalSetterForFirstOfType(awj.b.class, Integer.TYPE);
        PLAYERLIST_REMOVE = ReflectionHelper.getMethodHandle(bbz.class, (String)"remove", (Class[])new Class[]{axg.class});
        SynchedEntityData_itemsById = ReflectionHelper.getFields(ama.class).get(ReflectionMappingsInfo.SynchedEntityData_itemsById);
    }

    public static class FakeDamageSrc
    extends cex {
        public cex real;

        public FakeDamageSrc(cex src) {
            super(null);
            this.real = src;
        }
    }
}

