/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.block;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.CauldronLevelChangeEvent;

public class CauldronLevelChangeScriptEvent
extends BukkitScriptEvent
implements Listener {
    public LocationTag location;
    public CauldronLevelChangeEvent event;
    public Material cauldronType;
    public int oldLevel;
    public int newLevel;

    public CauldronLevelChangeScriptEvent() {
        this.registerCouldMatcher("cauldron level changes|raises|lowers");
        this.registerSwitches("cause");
        this.registerOptionalDetermination(null, ElementTag.class, (evt, context, value) -> {
            BlockData patt0$temp;
            if (!value.isInt()) {
                return false;
            }
            int level = value.asInt();
            BlockState cauldronState = evt.event.getNewState();
            if (level <= 0) {
                cauldronState.setType(Material.CAULDRON);
                return true;
            }
            if (level > 3) {
                return false;
            }
            if (cauldronState.getType() != Material.WATER_CAULDRON && cauldronState.getType() != Material.LAVA_CAULDRON) {
                cauldronState.setType(this.cauldronType);
            }
            if ((patt0$temp = cauldronState.getBlockData()) instanceof Levelled) {
                Levelled levelled = (Levelled)patt0$temp;
                levelled.setLevel(level);
                cauldronState.setBlockData((BlockData)levelled);
                evt.newLevel = level;
                return true;
            }
            return false;
        });
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        if (!CauldronLevelChangeScriptEvent.runGenericSwitchCheck(path, "cause", this.event.getReason().name())) {
            return false;
        }
        String changeType = path.eventArgLowerAt(2);
        if (changeType.equals("raises") ? this.newLevel <= this.oldLevel : (changeType.equals("lowers") ? this.newLevel >= this.oldLevel : !changeType.equals("changes"))) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "location" -> this.location;
            case "cause" -> new ElementTag((Enum<?>)this.event.getReason());
            case "old_level" -> new ElementTag(this.oldLevel);
            case "new_level" -> new ElementTag(this.newLevel);
            case "entity" -> {
                if (this.event.getEntity() != null) {
                    yield new EntityTag(this.event.getEntity()).getDenizenObject();
                }
                yield null;
            }
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onCauldronLevelChange(CauldronLevelChangeEvent event) {
        int n;
        int n2;
        Levelled levelled;
        this.location = new LocationTag(event.getBlock().getLocation());
        this.cauldronType = event.getBlock().getType();
        BlockData blockData = event.getBlock().getBlockData();
        if (blockData instanceof Levelled) {
            levelled = (Levelled)blockData;
            n2 = levelled.getLevel();
        } else {
            n2 = 0;
        }
        this.oldLevel = n2;
        blockData = event.getNewState().getBlockData();
        if (blockData instanceof Levelled) {
            levelled = (Levelled)blockData;
            n = levelled.getLevel();
        } else {
            n = 0;
        }
        this.newLevel = n;
        this.event = event;
        this.fire((Event)event);
    }
}

