/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.block;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import org.bukkit.Instrument;
import org.bukkit.Sound;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.NotePlayEvent;

public class NoteBlockPlaysNoteScriptEvent
extends BukkitScriptEvent
implements Listener {
    public NotePlayEvent event;
    public LocationTag location;

    public NoteBlockPlaysNoteScriptEvent() {
        this.registerCouldMatcher("noteblock plays note");
        this.registerSwitches("instrument");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        if (!NoteBlockPlaysNoteScriptEvent.runGenericSwitchCheck(path, "instrument", this.event.getInstrument().name())) {
            return false;
        }
        return super.matches(path);
    }

    public Sound getSound() {
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_20)) {
            return this.event.getInstrument().getSound();
        }
        return switch (this.event.getInstrument()) {
            case Instrument.PIANO -> Sound.BLOCK_NOTE_BLOCK_HARP;
            case Instrument.BASS_DRUM -> Sound.BLOCK_NOTE_BLOCK_BASEDRUM;
            case Instrument.SNARE_DRUM -> Sound.BLOCK_NOTE_BLOCK_SNARE;
            case Instrument.STICKS -> Sound.BLOCK_NOTE_BLOCK_HAT;
            case Instrument.BASS_GUITAR -> Sound.BLOCK_NOTE_BLOCK_BASS;
            case Instrument.FLUTE -> Sound.BLOCK_NOTE_BLOCK_FLUTE;
            case Instrument.BELL -> Sound.BLOCK_NOTE_BLOCK_BELL;
            case Instrument.GUITAR -> Sound.BLOCK_NOTE_BLOCK_GUITAR;
            case Instrument.CHIME -> Sound.BLOCK_NOTE_BLOCK_CHIME;
            case Instrument.XYLOPHONE -> Sound.BLOCK_NOTE_BLOCK_XYLOPHONE;
            case Instrument.IRON_XYLOPHONE -> Sound.BLOCK_NOTE_BLOCK_IRON_XYLOPHONE;
            case Instrument.COW_BELL -> Sound.BLOCK_NOTE_BLOCK_COW_BELL;
            case Instrument.DIDGERIDOO -> Sound.BLOCK_NOTE_BLOCK_DIDGERIDOO;
            case Instrument.BIT -> Sound.BLOCK_NOTE_BLOCK_BIT;
            case Instrument.BANJO -> Sound.BLOCK_NOTE_BLOCK_BANJO;
            case Instrument.PLING -> Sound.BLOCK_NOTE_BLOCK_PLING;
            default -> null;
        };
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "location" -> this.location;
            case "instrument" -> new ElementTag((Enum<?>)this.event.getInstrument());
            case "sound" -> Utilities.enumLikeToLegacyElement(this.getSound());
            case "tone" -> new ElementTag((Enum<?>)this.event.getNote().getTone());
            case "octave" -> new ElementTag(this.event.getNote().getOctave());
            case "sharp" -> new ElementTag(this.event.getNote().isSharped());
            case "pitch" -> new ElementTag(Math.pow(2.0, (double)(this.event.getNote().getId() - 12) / 12.0));
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onNotePlay(NotePlayEvent event) {
        this.location = new LocationTag(event.getBlock().getLocation());
        this.event = event;
        this.fire((Event)event);
    }
}

