/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_17.impl.network.packets;

import com.denizenscript.denizen.nms.interfaces.packets.PacketOutTradeList;
import com.denizenscript.denizen.nms.util.TradeOffer;
import com.denizenscript.denizen.nms.v1_17.ReflectionMappingsInfo;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindowMerchant;
import net.minecraft.world.item.trading.MerchantRecipe;
import net.minecraft.world.item.trading.MerchantRecipeList;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;

public class PacketOutTradeListImpl
implements PacketOutTradeList {
    private PacketPlayOutOpenWindowMerchant internal;
    private int container;
    private List<TradeOffer> tradeOffers;
    private static final Field CONTAINER = ReflectionHelper.getFields(PacketPlayOutOpenWindowMerchant.class).get(ReflectionMappingsInfo.ClientboundMerchantOffersPacket_containerId);
    private static final Field RECIPE_LIST = ReflectionHelper.getFields(PacketPlayOutOpenWindowMerchant.class).getFirstOfType(MerchantRecipeList.class);

    public PacketOutTradeListImpl(PacketPlayOutOpenWindowMerchant internal) {
        this.internal = internal;
        try {
            this.container = (Integer)CONTAINER.get(internal);
            MerchantRecipeList list = (MerchantRecipeList)RECIPE_LIST.get(internal);
            this.tradeOffers = new ArrayList<TradeOffer>();
            for (MerchantRecipe recipe : list) {
                this.tradeOffers.add(new TradeOffer(CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)recipe.c), CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)recipe.a), CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)recipe.b), recipe.isFullyUsed(), recipe.d, recipe.e, recipe.f, recipe.j, recipe.i));
            }
        }
        catch (IllegalAccessException e) {
            Debug.echoError((Throwable)e);
        }
    }

    public List<TradeOffer> getTradeOffers() {
        return this.tradeOffers;
    }

    public void setTradeOffers(List<TradeOffer> tradeOffers) {
        MerchantRecipeList list = new MerchantRecipeList();
        for (TradeOffer offer : tradeOffers) {
            MerchantRecipe recipe = new MerchantRecipe(CraftItemStack.asNMSCopy((ItemStack)offer.getFirstCost()), CraftItemStack.asNMSCopy((ItemStack)offer.getSecondCost()), CraftItemStack.asNMSCopy((ItemStack)offer.getProduct()), offer.getCurrentUses(), offer.getMaxUses(), offer.xp, offer.priceMultiplier);
            recipe.f = offer.rewardExp;
            list.add((Object)recipe);
        }
        try {
            RECIPE_LIST.set(this.internal, list);
        }
        catch (IllegalAccessException e) {
            Debug.echoError((Throwable)e);
        }
    }
}

