/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.PaperAPITools;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.Arrays;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemSignContents
implements Property {
    public static final String[] handledTags = new String[]{"sign_contents"};
    public static final String[] handledMechs = new String[]{"sign_contents"};
    ItemTag item;

    public static boolean describes(ObjectTag item) {
        return item instanceof ItemTag && ((ItemTag)item).getItemMeta() instanceof BlockStateMeta && ((BlockStateMeta)((ItemTag)item).getItemMeta()).getBlockState() instanceof Sign;
    }

    public static ItemSignContents getFrom(ObjectTag _item) {
        if (!ItemSignContents.describes(_item)) {
            return null;
        }
        return new ItemSignContents((ItemTag)_item);
    }

    public ListTag getSignContents() {
        return new ListTag(Arrays.asList(PaperAPITools.instance.getSignLines((Sign)((BlockStateMeta)this.item.getItemMeta()).getBlockState())), true);
    }

    public ItemSignContents(ItemTag _item) {
        this.item = _item;
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("sign_contents")) {
            return this.getSignContents().getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        for (String line : this.getSignContents()) {
            if (line.length() <= 0) continue;
            return this.getSignContents().identify();
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "sign_contents";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("sign_contents")) {
            BlockStateMeta bsm = (BlockStateMeta)this.item.getItemMeta();
            Sign sign = (Sign)bsm.getBlockState();
            for (int i = 0; i < 4; ++i) {
                PaperAPITools.instance.setSignLine(sign, i, "");
            }
            ListTag list = mechanism.valueAsType(ListTag.class);
            CoreUtilities.fixNewLinesToListSeparation(list);
            if (list.size() > 4) {
                Debug.echoError("Sign can only hold four lines!");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    PaperAPITools.instance.setSignLine(sign, i, list.get(i));
                }
            }
            bsm.setBlockState((BlockState)sign);
            this.item.setItemMeta((ItemMeta)bsm);
        }
    }
}

