/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_17.helpers;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.events.entity.EntityEntersVehicleScriptEvent;
import com.denizenscript.denizen.events.entity.EntityExitsVehicleScriptEvent;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.interfaces.EntityHelper;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.v1_17.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_17.helpers.BlockHelperImpl;
import com.denizenscript.denizen.nms.v1_17.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.world.EnumHand;
import net.minecraft.world.IInventory;
import net.minecraft.world.damagesource.CombatMath;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityEnderman;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.entity.TileEntityMobSpawner;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Art;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_17_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_17_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_17_R1.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_17_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftAbstractHorse;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftEnderman;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftFallingBlock;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftFirework;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftGhast;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftItem;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftMob;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftZombie;
import org.bukkit.craftbukkit.v1_17_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftItemStack;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import org.spigotmc.event.entity.EntityDismountEvent;
import org.spigotmc.event.entity.EntityMountEvent;

public class EntityHelperImpl
extends EntityHelper {
    public static final MethodHandle ENTITY_ONGROUND_SETTER = ReflectionHelper.getFinalSetter(net.minecraft.world.entity.Entity.class, ReflectionMappingsInfo.Entity_onGround, Boolean.TYPE);
    public static final DataWatcherObject<Boolean> ENTITY_ENDERMAN_DATAWATCHER_SCREAMING = (DataWatcherObject)ReflectionHelper.getFieldValue(EntityEnderman.class, ReflectionMappingsInfo.EnderMan_DATA_CREEPY, null);
    private static final Map<UUID, BukkitTask> followTasks = new HashMap<UUID, BukkitTask>();
    public static final MethodHandle FALLINGBLOCK_TYPE_SETTER = ReflectionHelper.getFinalSetterForFirstOfType(EntityFallingBlock.class, IBlockData.class);
    public static final Field ZOMBIE_INWATERTIME = ReflectionHelper.getFields(EntityZombie.class).get(ReflectionMappingsInfo.Zombie_inWaterTime, Integer.TYPE);
    public static final MethodHandle TRACKING_RANGE_SETTER = ReflectionHelper.getFinalSetterForFirstOfType(PlayerChunkMap.EntityTracker.class, Integer.TYPE);

    @Override
    public int getBlockHeight(Art art) {
        return art.getBlockHeight();
    }

    @Override
    public int getBlockWidth(Art art) {
        return art.getBlockWidth();
    }

    @Override
    public void setInvisible(Entity entity, boolean invisible) {
        ((CraftEntity)entity).getHandle().setInvisible(invisible);
    }

    @Override
    public boolean isInvisible(Entity entity) {
        return ((CraftEntity)entity).getHandle().isInvisible();
    }

    @Override
    public void setPose(Entity entity, Pose pose) {
        ((CraftEntity)entity).getHandle().setPose(EntityPose.values()[pose.ordinal()]);
    }

    @Override
    public double getDamageTo(LivingEntity attacker, Entity target) {
        EnumMonsterType monsterType = target instanceof LivingEntity ? ((CraftLivingEntity)target).getHandle().getMonsterType() : EnumMonsterType.a;
        double damage = 0.0;
        AttributeInstance attrib = attacker.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE);
        if (attrib != null) {
            damage = attrib.getValue();
        }
        if (attacker.getEquipment() != null && attacker.getEquipment().getItemInMainHand() != null) {
            damage += (double)EnchantmentManager.a((net.minecraft.world.item.ItemStack)CraftItemStack.asNMSCopy((ItemStack)attacker.getEquipment().getItemInMainHand()), (EnumMonsterType)monsterType);
        }
        if (damage <= 0.0) {
            return 0.0;
        }
        if (target != null) {
            DamageSource source = attacker instanceof Player ? DamageSource.playerAttack((EntityHuman)((CraftPlayer)attacker).getHandle()) : DamageSource.mobAttack((EntityLiving)((CraftLivingEntity)attacker).getHandle());
            net.minecraft.world.entity.Entity nmsTarget = ((CraftEntity)target).getHandle();
            if (nmsTarget.isInvulnerable(source)) {
                return 0.0;
            }
            if (!(nmsTarget instanceof EntityLiving)) {
                return damage;
            }
            EntityLiving livingTarget = (EntityLiving)nmsTarget;
            damage = CombatMath.a((float)((float)damage), (float)livingTarget.getArmorStrength(), (float)((float)livingTarget.b(GenericAttributes.j)));
            int enchantDamageModifier = EnchantmentManager.a((Iterable)livingTarget.getArmorItems(), (DamageSource)source);
            if (enchantDamageModifier > 0) {
                damage = CombatMath.a((float)((float)damage), (float)enchantDamageModifier);
            }
        }
        return damage;
    }

    @Override
    public void setRiptide(Entity entity, boolean state) {
        ((CraftLivingEntity)entity).getHandle().s(state ? 0 : 1);
    }

    @Override
    public void forceInteraction(Player player, Location location) {
        CraftPlayer craftPlayer = (CraftPlayer)player;
        BlockPosition pos = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        ((CraftBlock)location.getBlock()).getNMS().interact((net.minecraft.world.level.World)((CraftWorld)location.getWorld()).getHandle(), (EntityHuman)(craftPlayer != null ? craftPlayer.getHandle() : null), EnumHand.a, new MovingObjectPositionBlock(new Vec3D(0.0, 0.0, 0.0), null, pos, false));
    }

    @Override
    public CompoundTag getNbtData(Entity entity) {
        NBTTagCompound compound = new NBTTagCompound();
        ((CraftEntity)entity).getHandle().d(compound);
        return CompoundTagImpl.fromNMSTag(compound);
    }

    @Override
    public void setNbtData(Entity entity, CompoundTag compoundTag) {
        ((CraftEntity)entity).getHandle().load(((CompoundTagImpl)compoundTag).toNMSTag());
    }

    @Override
    public void stopFollowing(Entity follower) {
        if (follower == null) {
            return;
        }
        UUID uuid = follower.getUniqueId();
        if (followTasks.containsKey(uuid)) {
            followTasks.get(uuid).cancel();
        }
    }

    @Override
    public void stopWalking(Entity entity) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntity instanceof EntityInsentient)) {
            return;
        }
        ((EntityInsentient)nmsEntity).getNavigation().o();
    }

    @Override
    public void follow(final Entity target, final Entity follower, final double speed, final double lead, final double maxRange, final boolean allowWander, final boolean teleport) {
        if (target == null || follower == null) {
            return;
        }
        net.minecraft.world.entity.Entity nmsEntityFollower = ((CraftEntity)follower).getHandle();
        if (!(nmsEntityFollower instanceof EntityInsentient)) {
            return;
        }
        final EntityInsentient nmsFollower = (EntityInsentient)nmsEntityFollower;
        final NavigationAbstract followerNavigation = nmsFollower.getNavigation();
        UUID uuid = follower.getUniqueId();
        if (followTasks.containsKey(uuid)) {
            followTasks.get(uuid).cancel();
        }
        final int locationNearInt = (int)Math.floor(lead);
        final boolean hasMax = maxRange > lead;
        followTasks.put(follower.getUniqueId(), new BukkitRunnable(){
            private boolean inRadius = false;

            public void run() {
                if (!target.isValid() || !follower.isValid()) {
                    this.cancel();
                }
                followerNavigation.a(2.0);
                Location targetLocation = target.getLocation();
                if (hasMax && !Utilities.checkLocation(targetLocation, follower.getLocation(), maxRange) && !target.isDead() && target.isOnGround()) {
                    if (!this.inRadius) {
                        if (teleport) {
                            follower.teleport(Utilities.getWalkableLocationNear(targetLocation, locationNearInt));
                        } else {
                            this.cancel();
                        }
                    } else {
                        this.inRadius = false;
                        PathEntity path = followerNavigation.a(targetLocation.getX(), targetLocation.getY(), targetLocation.getZ(), 0);
                        if (path != null) {
                            followerNavigation.a(path, 1.0);
                            followerNavigation.a(2.0);
                        }
                    }
                } else if (!this.inRadius && !Utilities.checkLocation(targetLocation, follower.getLocation(), lead)) {
                    PathEntity path = followerNavigation.a(targetLocation.getX(), targetLocation.getY(), targetLocation.getZ(), 0);
                    if (path != null) {
                        followerNavigation.a(path, 1.0);
                        followerNavigation.a(2.0);
                    }
                } else {
                    this.inRadius = true;
                }
                if (this.inRadius && !allowWander) {
                    followerNavigation.o();
                }
                nmsFollower.getAttributeInstance(GenericAttributes.d).setValue(speed);
            }
        }.runTaskTimer((Plugin)NMSHandler.getJavaPlugin(), 0L, 10L));
    }

    @Override
    public void walkTo(final LivingEntity entity, Location location, final Double speed, final Runnable callback) {
        PathEntity path;
        boolean aiDisabled;
        if (entity == null || location == null) {
            return;
        }
        net.minecraft.world.entity.Entity nmsEntityEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntityEntity instanceof EntityInsentient)) {
            return;
        }
        final EntityInsentient nmsEntity = (EntityInsentient)nmsEntityEntity;
        final NavigationAbstract entityNavigation = nmsEntity.getNavigation();
        boolean bl = aiDisabled = !entity.hasAI();
        if (aiDisabled) {
            entity.setAI(true);
            try {
                ENTITY_ONGROUND_SETTER.invoke(nmsEntity, true);
            }
            catch (Throwable ex) {
                Debug.echoError(ex);
            }
        }
        if ((path = entityNavigation.a(location.getX(), location.getY(), location.getZ(), 1)) != null) {
            nmsEntity.bP.b(PathfinderGoal.Type.a);
            entityNavigation.a(path, 1.0);
            entityNavigation.a(2.0);
            final double oldSpeed = nmsEntity.getAttributeInstance(GenericAttributes.d).getBaseValue();
            if (speed != null) {
                nmsEntity.getAttributeInstance(GenericAttributes.d).setValue(speed.doubleValue());
            }
            new BukkitRunnable(){

                public void run() {
                    if (!entity.isValid()) {
                        if (callback != null) {
                            callback.run();
                        }
                        this.cancel();
                        return;
                    }
                    if (aiDisabled && entity instanceof Wolf) {
                        ((Wolf)entity).setAngry(false);
                    }
                    if (entityNavigation.m() || path.c()) {
                        if (callback != null) {
                            callback.run();
                        }
                        if (speed != null) {
                            nmsEntity.getAttributeInstance(GenericAttributes.d).setValue(oldSpeed);
                        }
                        if (aiDisabled) {
                            entity.setAI(false);
                        }
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)NMSHandler.getJavaPlugin(), 1L, 1L);
        } else {
            entity.teleport(location);
        }
    }

    @Override
    public List<Player> getPlayersThatSee(Entity entity) {
        PlayerChunkMap tracker = ((WorldServer)((CraftEntity)entity).getHandle().t).getChunkProvider().a;
        PlayerChunkMap.EntityTracker entityTracker = (PlayerChunkMap.EntityTracker)tracker.G.get(entity.getEntityId());
        ArrayList<Player> output = new ArrayList<Player>();
        if (entityTracker == null) {
            return output;
        }
        for (ServerPlayerConnection player : entityTracker.f) {
            output.add((Player)player.d().getBukkitEntity());
        }
        return output;
    }

    @Override
    public void sendHidePacket(Player pl, Entity entity) {
        if (entity instanceof Player) {
            pl.hidePlayer((Plugin)Denizen.getInstance(), (Player)entity);
            return;
        }
        CraftPlayer craftPlayer = (CraftPlayer)pl;
        EntityPlayer entityPlayer = craftPlayer.getHandle();
        if (entityPlayer.b != null && !craftPlayer.equals((Object)entity)) {
            PlayerChunkMap tracker = ((WorldServer)craftPlayer.getHandle().t).getChunkProvider().a;
            net.minecraft.world.entity.Entity other = ((CraftEntity)entity).getHandle();
            PlayerChunkMap.EntityTracker entry = (PlayerChunkMap.EntityTracker)tracker.G.get(other.getId());
            if (entry != null) {
                entry.clear(entityPlayer);
            }
            if (Denizen.supportsPaper) {
                entityPlayer.b.sendPacket((Packet)new PacketPlayOutEntityDestroy(new int[]{other.getId()}));
            }
        }
    }

    @Override
    public void sendShowPacket(Player pl, Entity entity) {
        if (entity instanceof Player) {
            pl.showPlayer((Plugin)Denizen.getInstance(), (Player)entity);
            return;
        }
        CraftPlayer craftPlayer = (CraftPlayer)pl;
        EntityPlayer entityPlayer = craftPlayer.getHandle();
        if (entityPlayer.b != null && !craftPlayer.equals((Object)entity)) {
            PlayerChunkMap tracker = ((WorldServer)craftPlayer.getHandle().t).getChunkProvider().a;
            net.minecraft.world.entity.Entity other = ((CraftEntity)entity).getHandle();
            PlayerChunkMap.EntityTracker entry = (PlayerChunkMap.EntityTracker)tracker.G.get(other.getId());
            if (entry != null) {
                entry.clear(entityPlayer);
                entry.updatePlayer(entityPlayer);
            }
        }
    }

    @Override
    public void rotate(Entity entity, float yaw, float pitch) {
        if (entity instanceof Player && ((Player)entity).isOnline()) {
            Location location = entity.getLocation();
            location.setYaw(yaw);
            location.setPitch(pitch);
            this.teleport(entity, location);
        } else if (entity instanceof LivingEntity) {
            if (entity instanceof EnderDragon) {
                yaw = EntityHelperImpl.normalizeYaw(yaw - 180.0f);
            }
            this.look(entity, yaw, pitch);
        } else {
            net.minecraft.world.entity.Entity handle = ((CraftEntity)entity).getHandle();
            handle.setYRot(yaw - 360.0f);
            handle.setXRot(pitch);
        }
    }

    @Override
    public float getBaseYaw(LivingEntity entity) {
        return ((CraftLivingEntity)entity).getHandle().aX;
    }

    @Override
    public void look(Entity entity, float yaw, float pitch) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)entity).getHandle();
        if (handle != null) {
            handle.setYRot(yaw);
            if (handle instanceof EntityLiving) {
                EntityLiving livingHandle = (EntityLiving)handle;
                while (yaw < -180.0f) {
                    yaw += 360.0f;
                }
                while (yaw >= 180.0f) {
                    yaw -= 360.0f;
                }
                livingHandle.aY = yaw;
                if (!(handle instanceof EntityHuman)) {
                    livingHandle.m(yaw);
                }
                livingHandle.setHeadRotation(yaw);
            }
            handle.setXRot(pitch);
        } else {
            Debug.echoError("Cannot set look direction for unspawned entity " + String.valueOf(entity.getUniqueId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MovingObjectPosition rayTrace(World world, Vector start, Vector end) {
        try {
            NMSHandler.chunkHelper.changeChunkServerThread(world);
            MovingObjectPositionBlock movingObjectPositionBlock = ((CraftWorld)world).getHandle().rayTrace(new RayTrace(new Vec3D(start.getX(), start.getY(), start.getZ()), new Vec3D(end.getX(), end.getY(), end.getZ()), RayTrace.BlockCollisionOption.b, RayTrace.FluidCollisionOption.a, null));
            return movingObjectPositionBlock;
        }
        finally {
            NMSHandler.chunkHelper.restoreServerThread(world);
        }
    }

    @Override
    public boolean canTrace(World world, Vector start, Vector end) {
        MovingObjectPosition pos = EntityHelperImpl.rayTrace(world, start, end);
        if (pos == null) {
            return true;
        }
        return pos.getType() == MovingObjectPosition.EnumMovingObjectType.a;
    }

    @Override
    public void snapPositionTo(Entity entity, Vector vector) {
        ((CraftEntity)entity).getHandle().setPositionRaw(vector.getX(), vector.getY(), vector.getZ());
    }

    @Override
    public void move(Entity entity, Vector vector) {
        ((CraftEntity)entity).getHandle().move(EnumMoveType.a, new Vec3D(vector.getX(), vector.getY(), vector.getZ()));
    }

    @Override
    public void teleport(Entity entity, Location loc) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.setYRot(loc.getYaw());
        nmsEntity.setXRot(loc.getPitch());
        if (nmsEntity instanceof EntityPlayer) {
            nmsEntity.enderTeleportTo(loc.getX(), loc.getY(), loc.getZ());
        }
        nmsEntity.setPosition(loc.getX(), loc.getY(), loc.getZ());
    }

    @Override
    public void setBoundingBox(Entity entity, BoundingBox box) {
        ((CraftEntity)entity).getHandle().a(new AxisAlignedBB(box.getMinX(), box.getMinY(), box.getMinZ(), box.getMaxX(), box.getMaxY(), box.getMaxZ()));
    }

    @Override
    public void setTicksLived(Entity entity, int ticks) {
        ((CraftEntity)entity).getHandle().R = ticks;
        if (entity instanceof CraftFallingBlock) {
            ((CraftFallingBlock)entity).getHandle().b = ticks;
        } else if (entity instanceof CraftItem) {
            ((EntityItem)((CraftItem)entity).getHandle()).ao = ticks;
        }
    }

    @Override
    public void setHeadAngle(LivingEntity entity, float angle) {
        EntityLiving handle = ((CraftLivingEntity)entity).getHandle();
        handle.aZ = angle;
        handle.setHeadRotation(angle);
    }

    @Override
    public void setGhastAttacking(Ghast ghast, boolean attacking) {
        ((CraftGhast)ghast).getHandle().v(attacking);
    }

    @Override
    public void setEndermanAngry(Enderman enderman, boolean angry) {
        ((CraftEnderman)enderman).getHandle().getDataWatcher().set(ENTITY_ENDERMAN_DATAWATCHER_SCREAMING, (Object)angry);
    }

    public static DamageSource getSourceFor(net.minecraft.world.entity.Entity nmsSource, EntityDamageEvent.DamageCause cause) {
        DamageSource src = DamageSource.n;
        if (nmsSource != null) {
            if (nmsSource instanceof EntityHuman) {
                src = DamageSource.playerAttack((EntityHuman)((EntityHuman)nmsSource));
            } else if (nmsSource instanceof EntityLiving) {
                src = DamageSource.mobAttack((EntityLiving)((EntityLiving)nmsSource));
            }
        }
        if (cause == null) {
            return src;
        }
        switch (cause) {
            case CONTACT: {
                return DamageSource.j;
            }
            case ENTITY_ATTACK: {
                return DamageSource.mobAttack((EntityLiving)(nmsSource instanceof EntityLiving ? (EntityLiving)nmsSource : null));
            }
            case ENTITY_SWEEP_ATTACK: {
                if (src != DamageSource.n) {
                    src.sweep();
                }
                return src;
            }
            case PROJECTILE: {
                return DamageSource.projectile((net.minecraft.world.entity.Entity)nmsSource, nmsSource != null && nmsSource.getBukkitEntity() instanceof Projectile && ((Projectile)nmsSource.getBukkitEntity()).getShooter() instanceof Entity ? ((CraftEntity)((Projectile)nmsSource.getBukkitEntity()).getShooter()).getHandle() : null);
            }
            case SUFFOCATION: {
                return DamageSource.f;
            }
            case FALL: {
                return DamageSource.k;
            }
            case FIRE: {
                return DamageSource.a;
            }
            case FIRE_TICK: {
                return DamageSource.c;
            }
            case MELTING: {
                return CraftEventFactory.MELTING;
            }
            case LAVA: {
                return DamageSource.d;
            }
            case DROWNING: {
                return DamageSource.h;
            }
            case BLOCK_EXPLOSION: {
                return DamageSource.d(nmsSource instanceof TNTPrimed && ((TNTPrimed)nmsSource).getSource() instanceof EntityLiving ? (EntityLiving)((TNTPrimed)nmsSource).getSource() : null);
            }
            case ENTITY_EXPLOSION: {
                return DamageSource.d((EntityLiving)(nmsSource instanceof EntityLiving ? (EntityLiving)nmsSource : null));
            }
            case VOID: {
                return DamageSource.m;
            }
            case LIGHTNING: {
                return DamageSource.b;
            }
            case STARVATION: {
                return DamageSource.i;
            }
            case POISON: {
                return CraftEventFactory.POISON;
            }
            case MAGIC: {
                return DamageSource.o;
            }
            case WITHER: {
                return DamageSource.p;
            }
            case FALLING_BLOCK: {
                return DamageSource.r;
            }
            case THORNS: {
                return DamageSource.a((net.minecraft.world.entity.Entity)nmsSource);
            }
            case DRAGON_BREATH: {
                return DamageSource.s;
            }
            case CUSTOM: {
                return DamageSource.n;
            }
            case FLY_INTO_WALL: {
                return DamageSource.l;
            }
            case HOT_FLOOR: {
                return DamageSource.e;
            }
            case CRAMMING: {
                return DamageSource.g;
            }
            case DRYOUT: {
                return DamageSource.t;
            }
        }
        return new FakeDamageSrc(src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void damage(LivingEntity target, float amount, EntityTag source, Location sourceLoc, EntityDamageEvent.DamageCause cause) {
        net.minecraft.world.entity.Entity nmsSource;
        if (target == null) {
            return;
        }
        EntityLiving nmsTarget = ((CraftLivingEntity)target).getHandle();
        CraftEventFactory.entityDamage = nmsSource = source == null ? null : ((CraftEntity)source.getBukkitEntity()).getHandle();
        CraftEventFactory.blockDamage = sourceLoc == null ? null : sourceLoc.getBlock();
        try {
            DamageSource src = EntityHelperImpl.getSourceFor(nmsSource, cause);
            if (src instanceof FakeDamageSrc) {
                src = ((FakeDamageSrc)src).real;
                EntityDamageEvent ede = EntityHelperImpl.fireFakeDamageEvent((Entity)target, source, sourceLoc, cause, amount);
                if (ede.isCancelled()) {
                    return;
                }
            }
            nmsTarget.damageEntity(src, amount);
        }
        finally {
            CraftEventFactory.entityDamage = null;
            CraftEventFactory.blockDamage = null;
        }
    }

    @Override
    public void setLastHurtBy(LivingEntity mob, LivingEntity damager) {
        ((CraftLivingEntity)mob).getHandle().setLastDamager(((CraftLivingEntity)damager).getHandle());
    }

    @Override
    public void setFallingBlockType(FallingBlock fallingBlock, BlockData block) {
        IBlockData state = ((CraftBlockData)block).getState();
        EntityFallingBlock nmsEntity = ((CraftFallingBlock)fallingBlock).getHandle();
        try {
            FALLINGBLOCK_TYPE_SETTER.invoke(nmsEntity, state);
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
    }

    @Override
    public EntityTag getMobSpawnerDisplayEntity(CreatureSpawner spawner) {
        TileEntityMobSpawner nmsSpawner = (TileEntityMobSpawner)BlockHelperImpl.getTE((CraftCreatureSpawner)spawner);
        net.minecraft.world.entity.Entity nmsEntity = nmsSpawner.getSpawner().a((net.minecraft.world.level.World)((CraftWorld)spawner.getWorld()).getHandle());
        return new EntityTag((Entity)nmsEntity.getBukkitEntity());
    }

    @Override
    public void setFireworkLifetime(Firework firework, int ticks) {
        ((CraftFirework)firework).getHandle().f = ticks;
    }

    @Override
    public int getFireworkLifetime(Firework firework) {
        return ((CraftFirework)firework).getHandle().f;
    }

    @Override
    public int getInWaterTime(Zombie zombie) {
        try {
            return ZOMBIE_INWATERTIME.getInt(((CraftZombie)zombie).getHandle());
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
            return 0;
        }
    }

    @Override
    public void setInWaterTime(Zombie zombie, int ticks) {
        try {
            ZOMBIE_INWATERTIME.setInt(((CraftZombie)zombie).getHandle(), ticks);
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
    }

    @Override
    public void setTrackingRange(Entity entity, int range) {
        try {
            PlayerChunkMap map = ((CraftWorld)entity.getWorld()).getHandle().getChunkProvider().a;
            PlayerChunkMap.EntityTracker entry = (PlayerChunkMap.EntityTracker)map.G.get(entity.getEntityId());
            TRACKING_RANGE_SETTER.invoke(entry, range);
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
    }

    @Override
    public boolean isAggressive(Mob mob) {
        return ((CraftMob)mob).getHandle().isAggressive();
    }

    @Override
    public void setAggressive(Mob mob, boolean aggressive) {
        ((CraftMob)mob).getHandle().setAggressive(aggressive);
    }

    @Override
    public void openHorseInventory(Player player, AbstractHorse horse) {
        EntityHorseAbstract nmsHorse = ((CraftAbstractHorse)horse).getHandle();
        ((CraftPlayer)player).getHandle().openHorseInventory(nmsHorse, (IInventory)nmsHorse.ce);
    }

    @Override
    public Class<? extends EntityEntersVehicleScriptEvent> getEntersVehicleEventImpl() {
        return EntityEntersVehicleScriptEventImpl.class;
    }

    @Override
    public Class<? extends EntityExitsVehicleScriptEvent> getExitsVehicleEventImpl() {
        return EntityExitsVehicleScriptEventImpl.class;
    }

    public static class FakeDamageSrc
    extends DamageSource {
        public DamageSource real;

        public FakeDamageSrc(DamageSource src) {
            super("fake");
            this.real = src;
        }
    }

    public static class EntityEntersVehicleScriptEventImpl
    extends EntityEntersVehicleScriptEvent {
        @EventHandler
        public void onEntityMount(EntityMountEvent event) {
            this.fire((EntityEvent)event, event.getMount());
        }
    }

    public static class EntityExitsVehicleScriptEventImpl
    extends EntityExitsVehicleScriptEvent {
        @EventHandler
        public void onEntityMount(EntityDismountEvent event) {
            this.fire((EntityEvent)event, event.getDismounted());
        }
    }
}

