/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.core;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsRuntimeException;
import com.denizenscript.denizencore.objects.core.ImageTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.Holdable;
import com.denizenscript.denizencore.scripts.commands.file.FileReadCommand;
import com.denizenscript.denizencore.scripts.commands.file.FileWriteCommand;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultNull;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultText;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;

public class ImageCommand
extends AbstractCommand
implements Holdable {
    public static final Map<String, ImageTag> loadedImages = new HashMap<String, ImageTag>();

    public ImageCommand() {
        this.setName("image");
        this.setSyntax("image [id:<id>] [load [image:<image>/path:<path>]]/[save [path:<path>] [format:<format>]]/[unload]");
        this.setRequiredArguments(2, 4);
        this.autoCompile();
    }

    public static ImageTag getImageFrom(String id) {
        ImageTag image = loadedImages.get(CoreUtilities.toLowerCase(id));
        if (image == null) {
            throw new InvalidArgumentsRuntimeException("No loaded image with id '" + id + "'.");
        }
        return image;
    }

    public static void autoExecute(ScriptEntry scriptEntry, @ArgName(value="operation") Operation operation, @ArgName(value="id") @ArgPrefixed String id, @ArgName(value="path") @ArgPrefixed @ArgDefaultNull String path, @ArgName(value="format") @ArgPrefixed @ArgDefaultText(value="png") String format, @ArgName(value="image") @ArgPrefixed @ArgDefaultNull ImageTag toLoad) {
        String idLower = CoreUtilities.toLowerCase(id);
        switch (operation.ordinal()) {
            case 0: {
                if (toLoad == null && path == null) {
                    throw new InvalidArgumentsRuntimeException("Must specify a path or image to load.");
                }
                if (loadedImages.containsKey(idLower)) {
                    Debug.echoError(scriptEntry, "Id '" + id + "' is already in use.");
                    scriptEntry.setFinished(true);
                    return;
                }
                if (toLoad != null) {
                    ImageTag toLoadCopy = toLoad.duplicateIgnoreId();
                    toLoadCopy.id = idLower;
                    loadedImages.put(idLower, toLoadCopy);
                    scriptEntry.setFinished(true);
                    return;
                }
                File imageFile = FileReadCommand.getFileIfSafe(path, scriptEntry);
                if (imageFile == null) {
                    return;
                }
                Runnable readImage = () -> {
                    try {
                        BufferedImage image = ImageIO.read(imageFile);
                        if (image == null) {
                            Debug.echoError(scriptEntry, "Failed to recognize image format for image.");
                            scriptEntry.setFinished(true);
                            return;
                        }
                        DenizenCore.runOnMainThread(() -> {
                            ImageTag imageTag = new ImageTag(image);
                            imageTag.id = idLower;
                            loadedImages.put(idLower, imageTag);
                            scriptEntry.setFinished(true);
                        });
                    }
                    catch (IOException e) {
                        Debug.echoError(scriptEntry, "An error occurred while trying to load image, see stacktrace below:");
                        Debug.echoError(scriptEntry, e);
                        scriptEntry.setFinished(true);
                    }
                };
                if (scriptEntry.shouldWaitFor()) {
                    DenizenCore.runAsync(readImage);
                    break;
                }
                readImage.run();
                break;
            }
            case 1: {
                if (path == null) {
                    throw new InvalidArgumentsRuntimeException("Must specify a path.");
                }
                ImageTag image = ImageCommand.getImageFrom(idLower);
                File imageFile = FileWriteCommand.getFileIfSafe(path, scriptEntry);
                if (imageFile == null) {
                    return;
                }
                Runnable saveImage = () -> {
                    try {
                        ImageTag corrected = image.correctType(format);
                        if (corrected == null) {
                            Debug.echoError(scriptEntry, "Invalid/unfitting image format specified: " + format + ".");
                            scriptEntry.setFinished(true);
                            return;
                        }
                        ImageIO.write((RenderedImage)corrected.image, format, imageFile);
                        scriptEntry.setFinished(true);
                    }
                    catch (IOException e) {
                        Debug.echoError(scriptEntry, "An error occurred while trying to save image, see stacktrace below:");
                        Debug.echoError(scriptEntry, e);
                        scriptEntry.setFinished(true);
                    }
                };
                if (scriptEntry.shouldWaitFor()) {
                    DenizenCore.runAsync(saveImage);
                    break;
                }
                saveImage.run();
                break;
            }
            case 2: {
                if (loadedImages.remove(idLower) != null) break;
                Debug.echoError("No loaded image with id '" + id + "'.");
            }
        }
    }

    public static enum Operation {
        LOAD,
        SAVE,
        UNLOAD;

    }
}

