/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.npc.traits;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.scripts.commands.entity.FakeEquipCommand;
import com.denizenscript.denizen.scripts.commands.entity.RenameCommand;
import com.denizenscript.denizen.utilities.packets.NetworkInterceptHelper;
import java.util.HashMap;
import java.util.UUID;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.BlockDispenseArmorEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EntityEquipment;

public class MirrorEquipmentTrait
extends Trait {
    @Persist(value="")
    public boolean mirror = true;
    public UUID mirroredUUID = null;
    public static MirrorOverride overrideInstance = new MirrorOverride();

    public MirrorEquipmentTrait() {
        super("mirrorequipment");
    }

    public void resend() {
        for (Player player : NMSHandler.entityHelper.getPlayersThatSee(this.npc.getEntity())) {
            NMSHandler.packetHelper.resetEquipment(player, (LivingEntity)this.npc.getEntity());
        }
    }

    public void resendIfNeeded(Player player) {
        if (player == null || !this.mirror || !this.npc.isSpawned()) {
            return;
        }
        if (!player.getWorld().equals((Object)this.npc.getEntity().getWorld())) {
            return;
        }
        if (player.getLocation().distanceSquared(this.npc.getStoredLocation()) > 10000.0) {
            return;
        }
        if (!NMSHandler.entityHelper.getPlayersThatSee(this.npc.getEntity()).contains(player)) {
            return;
        }
        NMSHandler.packetHelper.resetEquipment(player, (LivingEntity)this.npc.getEntity());
    }

    @EventHandler
    public void onPlayerInventoryClick(InventoryClickEvent event) {
        this.resendIfNeeded((Player)event.getWhoClicked());
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        this.resendIfNeeded(event.getPlayer());
    }

    @EventHandler
    public void onArmorDispense(BlockDispenseArmorEvent event) {
        if (event.getTargetEntity() instanceof Player) {
            this.resendIfNeeded((Player)event.getTargetEntity());
        }
    }

    public void mirrorOn() {
        NetworkInterceptHelper.enable();
        if (!this.npc.isSpawned()) {
            return;
        }
        if (!(this.npc.getEntity() instanceof LivingEntity)) {
            this.mirrorOff();
            return;
        }
        this.mirroredUUID = this.npc.getEntity().getUniqueId();
        HashMap mapping = FakeEquipCommand.overrides.computeIfAbsent(null, k -> new HashMap());
        mapping.put(this.mirroredUUID, overrideInstance);
    }

    public void mirrorOff() {
        if (this.mirroredUUID == null) {
            return;
        }
        HashMap<UUID, FakeEquipCommand.EquipmentOverride> mapping = FakeEquipCommand.overrides.get(null);
        if (mapping == null) {
            return;
        }
        if (mapping.remove(this.mirroredUUID) != null && this.npc.isSpawned()) {
            this.resend();
        }
    }

    public void enableMirror() {
        this.mirror = true;
        this.mirrorOn();
        if (this.npc.isSpawned()) {
            this.resend();
        }
    }

    public void disableMirror() {
        this.mirror = false;
        this.mirrorOff();
        if (RenameCommand.customNames.remove(this.mirroredUUID) != null && this.npc.isSpawned()) {
            this.resend();
        }
    }

    public void onSpawn() {
        if (this.mirror) {
            this.mirrorOn();
        }
    }

    public void onRemove() {
        if (this.mirror) {
            this.mirrorOff();
        }
    }

    public void onAttach() {
        if (this.mirror) {
            this.mirrorOn();
        }
    }

    public static class MirrorOverride
    extends FakeEquipCommand.EquipmentOverride {
        @Override
        public FakeEquipCommand.EquipmentOverride getVariantFor(Player player) {
            FakeEquipCommand.EquipmentOverride result = new FakeEquipCommand.EquipmentOverride();
            EntityEquipment playerEquip = player.getEquipment();
            result.hand = new ItemTag(playerEquip.getItemInMainHand());
            result.offhand = new ItemTag(playerEquip.getItemInOffHand());
            result.head = new ItemTag(playerEquip.getHelmet());
            result.chest = new ItemTag(playerEquip.getChestplate());
            result.legs = new ItemTag(playerEquip.getLeggings());
            result.boots = new ItemTag(playerEquip.getBoots());
            return result;
        }
    }
}

