/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.block;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.TNTPrimeEvent;

public class TNTPrimesScriptEvent
extends BukkitScriptEvent
implements Listener {
    public TNTPrimeEvent event;
    public LocationTag location;

    public TNTPrimesScriptEvent() {
        this.registerCouldMatcher("tnt primes");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.event.getPrimingEntity());
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "entity" -> {
                if (this.event.getPrimingEntity() != null) {
                    yield new EntityTag(this.event.getPrimingEntity()).getDenizenObject();
                }
                yield null;
            }
            case "block" -> {
                if (this.event.getPrimingBlock() != null) {
                    yield new LocationTag(this.event.getPrimingBlock().getLocation());
                }
                yield null;
            }
            case "location" -> this.location;
            case "cause" -> new ElementTag((Enum<?>)this.event.getCause());
            case "reason" -> new ElementTag(this.event.getCause() == TNTPrimeEvent.PrimeCause.PLAYER ? "ITEM" : this.event.getCause().name(), true);
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onTntPrimesEvent(TNTPrimeEvent event) {
        this.event = event;
        this.location = new LocationTag(event.getBlock().getLocation());
        this.fire((Event)event);
    }
}

