/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.properties.item.ItemProperty;
import com.denizenscript.denizencore.objects.Mechanism;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemSpawnerType
extends ItemProperty<EntityTag> {
    public static boolean describes(ItemTag item) {
        BlockStateMeta meta;
        ItemMeta itemMeta = item.getItemMeta();
        return itemMeta instanceof BlockStateMeta && (meta = (BlockStateMeta)itemMeta).getBlockState() instanceof CreatureSpawner;
    }

    @Override
    public EntityTag getPropertyValue() {
        EntityType spawnedType = ((CreatureSpawner)((BlockStateMeta)this.getItemMeta()).getBlockState()).getSpawnedType();
        return spawnedType != null ? new EntityTag(spawnedType) : null;
    }

    @Override
    public void setPropertyValue(EntityTag entity, Mechanism mechanism) {
        if (entity == null && NMSHandler.getVersion().isAtMost(NMSVersion.v1_19)) {
            mechanism.echoError("must have input of type 'EntityTag', but none was given.");
            return;
        }
        this.editMeta(BlockStateMeta.class, meta -> {
            CreatureSpawner spawner = (CreatureSpawner)meta.getBlockState();
            spawner.setSpawnedType(entity != null ? entity.getBukkitEntityType() : null);
            meta.setBlockState((BlockState)spawner);
        });
    }

    @Override
    public String getPropertyId() {
        return "spawner_type";
    }

    public static void register() {
        ItemSpawnerType.autoRegisterNullable("spawner_type", ItemSpawnerType.class, EntityTag.class, false, new String[0]);
    }
}

