/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import io.papermc.paper.event.player.PlayerShieldDisableEvent;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class PlayerShieldDisableScriptEvent
extends BukkitScriptEvent
implements Listener {
    public PlayerShieldDisableEvent event;
    public LocationTag location;

    public PlayerShieldDisableScriptEvent() {
        this.registerCouldMatcher("player shield disables");
        this.registerDetermination("cooldown", DurationTag.class, (evt, context, duration) -> evt.event.setCooldown(duration.getTicksAsInt()));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "damager" -> new EntityTag(this.event.getDamager()).getDenizenObject();
            case "cooldown" -> new DurationTag((long)this.event.getCooldown());
            default -> super.getContext(name);
        };
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((Entity)this.event.getPlayer());
    }

    @EventHandler
    public void playerShieldDisableEvent(PlayerShieldDisableEvent event) {
        this.location = new LocationTag(event.getPlayer().getLocation());
        this.event = event;
        this.fire((Event)event);
    }
}

