/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_18.helpers;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.ImprovedOfflinePlayer;
import com.denizenscript.denizen.nms.enums.CustomEntityType;
import com.denizenscript.denizen.nms.interfaces.PlayerHelper;
import com.denizenscript.denizen.nms.v1_18.Handler;
import com.denizenscript.denizen.nms.v1_18.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_18.helpers.ItemHelperImpl;
import com.denizenscript.denizen.nms.v1_18.helpers.PacketHelperImpl;
import com.denizenscript.denizen.nms.v1_18.impl.ImprovedOfflinePlayerImpl;
import com.denizenscript.denizen.nms.v1_18.impl.entities.CraftFakePlayerImpl;
import com.denizenscript.denizen.nms.v1_18.impl.entities.EntityItemProjectileImpl;
import com.denizenscript.denizen.nms.v1_18.impl.network.handlers.AbstractListenerPlayInImpl;
import com.denizenscript.denizen.nms.v1_18.impl.network.handlers.DenizenNetworkManagerImpl;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizen.utilities.entity.DenizenEntityType;
import com.denizenscript.denizen.utilities.entity.FakeEntity;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import it.unimi.dsi.fastutil.ints.IntList;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.boss.BossBar;
import org.bukkit.craftbukkit.v1_18_R2.CraftServer;
import org.bukkit.craftbukkit.v1_18_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R2.boss.CraftBossBar;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftNamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerHelperImpl
extends PlayerHelper {
    public static final Field ATTACK_COOLDOWN_TICKS = ReflectionHelper.getFields(axy.class).get(ReflectionMappingsInfo.LivingEntity_attackStrengthTicker, Integer.TYPE);
    public static final Field FLY_TICKS = ReflectionHelper.getFields(aeo.class).get(ReflectionMappingsInfo.ServerGamePacketListenerImpl_aboveGroundTickCount, Integer.TYPE);
    public static final Field VEHICLE_FLY_TICKS = ReflectionHelper.getFields(aeo.class).get(ReflectionMappingsInfo.ServerGamePacketListenerImpl_aboveGroundVehicleTickCount, Integer.TYPE);
    public static final MethodHandle PLAYER_RESPAWNFORCED_SETTER = ReflectionHelper.getFinalSetter(adx.class, (String)ReflectionMappingsInfo.ServerPlayer_respawnForced, Boolean.TYPE);
    public static final yb<Byte> ENTITY_HUMAN_SKINLAYERS_DATAWATCHER;

    public void stopSound(Player player, NamespacedKey sound, SoundCategory category) {
        yt soundKey = sound == null ? null : CraftNamespacedKey.toMinecraft((NamespacedKey)sound);
        ahl nmsCategory = category == null ? null : ahl.valueOf((String)category.name());
        ((CraftPlayer)player).getHandle().b.a((rc)new uw(soundKey, nmsCategory));
    }

    public void deTrackEntity(Player player, Entity entity) {
        adx nmsPlayer = ((CraftPlayer)player).getHandle();
        adw world = (adw)nmsPlayer.s;
        adj.b tracker = (adj.b)world.k().a.J.get(entity.getEntityId());
        if (tracker == null) {
            if (NMSHandler.debugPackets) {
                DenizenNetworkManagerImpl.doPacketOutput("Failed to de-track entity " + entity.getEntityId() + " for " + player.getName() + ": tracker null");
            }
            return;
        }
        this.sendEntityDestroy(player, entity);
        tracker.a(nmsPlayer);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FakeEntity sendEntitySpawn(List<PlayerTag> players, DenizenEntityType entityType, LocationTag location, ArrayList<Mechanism> mechanisms, int customId, UUID customUUID, boolean autoTrack) {
        void var9_15;
        CraftWorld world = (CraftWorld)location.getWorld();
        if (entityType.isCustom()) {
            if (entityType.customEntityType == CustomEntityType.ITEM_PROJECTILE) {
                ItemStack itemStack = new ItemStack(Material.STONE);
                for (Mechanism mechanism : mechanisms) {
                    if (!mechanism.matches("item") || !mechanism.requireObject(ItemTag.class)) continue;
                    itemStack = ((ItemTag)mechanism.valueAsType(ItemTag.class)).getItemStack();
                }
                EntityItemProjectileImpl entityItemProjectileImpl = new EntityItemProjectileImpl((cav)world.getHandle(), (Location)location, CraftItemStack.asNMSCopy((ItemStack)itemStack));
            } else {
                if (entityType.customEntityType != CustomEntityType.FAKE_PLAYER) throw new IllegalArgumentException("entityType");
                String name = null;
                Object skin = null;
                String blob = null;
                for (Mechanism mechanism : new ArrayList<Mechanism>(mechanisms)) {
                    if (mechanism.matches("name")) {
                        name = mechanism.getValue().asString();
                        mechanisms.remove(mechanism);
                    } else if (mechanism.matches("skin")) {
                        skin = mechanism.getValue().asString();
                        mechanisms.remove(mechanism);
                    } else if (mechanism.matches("skin_blob")) {
                        blob = mechanism.getValue().asString();
                        mechanisms.remove(mechanism);
                    }
                    if (name == null || skin == null && blob == null) continue;
                    break;
                }
                adx adx2 = ((CraftFakePlayerImpl)NMSHandler.customEntityHelper.spawnFakePlayer((Location)location, name, skin, blob, false)).getHandle();
            }
        } else {
            axk axk2 = world.createEntity((Location)location, entityType.getBukkitEntityType().getEntityClass());
        }
        if (customUUID != null) {
            var9_15.e(customId);
            var9_15.a_(customUUID);
        }
        EntityTag entity = new EntityTag((Entity)var9_15.getBukkitEntity());
        entity.isFake = true;
        entity.isFakeValid = true;
        for (Mechanism mechanism : mechanisms) {
            entity.safeAdjustDuplicate(mechanism);
        }
        var9_15.dr();
        FakeEntity fake = new FakeEntity(players, location, entity.getBukkitEntity().getEntityId());
        fake.entity = new EntityTag(entity.getBukkitEntity());
        fake.entity.isFake = true;
        fake.entity.isFakeValid = true;
        ArrayList trackers = new ArrayList();
        fake.triggerSpawnPacket = arg_0 -> this.lambda$sendEntitySpawn$0(world, (axk)var9_15, trackers, autoTrack, fake, arg_0);
        for (PlayerTag player : players) {
            fake.triggerSpawnPacket.accept(player);
        }
        fake.triggerUpdatePacket = () -> {
            for (TrackerData tracker : trackers) {
                if (!tracker.player.isOnline()) continue;
                tracker.tracker.a();
            }
        };
        fake.triggerDestroyPacket = () -> {
            for (TrackerData tracker : trackers) {
                if (!tracker.player.isOnline()) continue;
                tracker.tracker.a(((CraftPlayer)tracker.player.getPlayerEntity()).getHandle());
            }
            trackers.clear();
        };
        return fake;
    }

    public void sendEntityDestroy(Player player, Entity entity) {
        ((CraftPlayer)player).getHandle().b.a((rc)new tm(new int[]{entity.getEntityId()}));
    }

    public int getFlyKickCooldown(Player player) {
        aeo conn = ((CraftPlayer)player).getHandle().b;
        if (conn instanceof AbstractListenerPlayInImpl) {
            conn = ((AbstractListenerPlayInImpl)conn).oldListener;
        }
        try {
            return Math.max(80 - Math.max(FLY_TICKS.getInt(conn), VEHICLE_FLY_TICKS.getInt(conn)), 0);
        }
        catch (IllegalAccessException e2) {
            Debug.echoError((Throwable)e2);
            return 80;
        }
    }

    public void setFlyKickCooldown(Player player, int ticks) {
        ticks = 80 - ticks;
        aeo conn = ((CraftPlayer)player).getHandle().b;
        if (conn instanceof AbstractListenerPlayInImpl) {
            conn = ((AbstractListenerPlayInImpl)conn).oldListener;
        }
        try {
            FLY_TICKS.setInt(conn, ticks);
            VEHICLE_FLY_TICKS.setInt(conn, ticks);
        }
        catch (IllegalAccessException e2) {
            Debug.echoError((Throwable)e2);
        }
    }

    public int ticksPassedDuringCooldown(Player player) {
        try {
            return ATTACK_COOLDOWN_TICKS.getInt(((CraftPlayer)player).getHandle());
        }
        catch (IllegalAccessException e2) {
            Debug.echoError((Throwable)e2);
            return -1;
        }
    }

    public float getMaxAttackCooldownTicks(Player player) {
        return ((CraftPlayer)player).getHandle().fJ() + 3.0f;
    }

    public void setAttackCooldown(Player player, int ticks) {
        try {
            ATTACK_COOLDOWN_TICKS.setInt(((CraftPlayer)player).getHandle(), ticks);
        }
        catch (IllegalAccessException e2) {
            Debug.echoError((Throwable)e2);
        }
    }

    public boolean hasChunkLoaded(Player player, Chunk chunk) {
        return ((CraftWorld)chunk.getWorld()).getHandle().k().a.a(new cac(chunk.getX(), chunk.getZ()), false).stream().anyMatch(entityPlayer -> entityPlayer.cm().equals(player.getUniqueId()));
    }

    public void setTemporaryOp(Player player, boolean op) {
        acx server = ((CraftServer)Bukkit.getServer()).getServer();
        GameProfile profile = ((CraftPlayer)player).getProfile();
        ago opList = server.ac().k();
        if (op) {
            int permLevel = server.h();
            opList.a((agr)new agp(profile, permLevel, opList.a(profile)));
        } else {
            opList.c((Object)profile);
        }
        player.recalculatePermissions();
    }

    public void showEndCredits(Player player) {
        ((CraftPlayer)player).getHandle().f = true;
        ((CraftPlayer)player).getHandle().b.a((rc)new sk(sk.e, 1.0f));
    }

    public ImprovedOfflinePlayer getOfflineData(UUID uuid) {
        return new ImprovedOfflinePlayerImpl(uuid);
    }

    public void resendRecipeDetails(Player player) {
        Collection recipes = ((CraftServer)Bukkit.getServer()).getServer().aC().b();
        ve updatePacket = new ve(recipes);
        ((CraftPlayer)player).getHandle().b.a((rc)updatePacket);
    }

    public void resendDiscoveredRecipes(Player player) {
        ahp recipeBook = ((CraftPlayer)player).getHandle().E();
        recipeBook.a(((CraftPlayer)player).getHandle());
    }

    public void quietlyAddRecipe(Player player, NamespacedKey key) {
        ahp recipeBook = ((CraftPlayer)player).getHandle().E();
        bxo<?> recipe = ItemHelperImpl.getNMSRecipe(key);
        if (recipe == null) {
            Debug.echoError((String)("Cannot add recipe '" + String.valueOf(key) + "': it does not exist."));
            return;
        }
        recipeBook.a(recipe);
        recipeBook.f(recipe);
    }

    public String getClientBrand(Player player) {
        return ((DenizenNetworkManagerImpl)((CraftPlayer)player).getHandle().b.a).packetListener.brand;
    }

    public byte getSkinLayers(Player player) {
        return (Byte)((CraftPlayer)player).getHandle().ai().a(ENTITY_HUMAN_SKINLAYERS_DATAWATCHER);
    }

    public void setSkinLayers(Player player, byte flags) {
        ((CraftPlayer)player).getHandle().ai().b(ENTITY_HUMAN_SKINLAYERS_DATAWATCHER, (Object)flags);
    }

    public void setBossBarTitle(BossBar bar, String title) {
        ((CraftBossBar)bar).getHandle().a = Handler.componentToNMS(FormattedTextHelper.parse((String)title, (ChatColor)ChatColor.WHITE));
        ((CraftBossBar)bar).getHandle().a(rt::c);
    }

    public boolean getSpawnForced(Player player) {
        return ((CraftPlayer)player).getHandle().Q();
    }

    public void setSpawnForced(Player player, boolean forced) {
        adx nmsPlayer = ((CraftPlayer)player).getHandle();
        try {
            PLAYER_RESPAWNFORCED_SETTER.invoke(nmsPlayer, forced);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public Location getBedSpawnLocation(Player player) {
        adx nmsPlayer = ((CraftPlayer)player).getHandle();
        gj spawnPosition = nmsPlayer.N();
        if (spawnPosition == null) {
            return null;
        }
        adw nmsWorld = MinecraftServer.getServer().a(nmsPlayer.P());
        if (nmsWorld == null) {
            return null;
        }
        return new Location((World)nmsWorld.getWorld(), (double)spawnPosition.u(), (double)spawnPosition.v(), (double)spawnPosition.w(), nmsPlayer.O(), 0.0f);
    }

    public long getLastActionTime(Player player) {
        return ((CraftPlayer)player).getHandle().I();
    }

    public void sendPlayerInfoAddPacket(Player player, EnumSet<PlayerHelper.ProfileEditMode> editModes, String name, String display, UUID id, String texture, String signature, int latency, GameMode gameMode, boolean listed) {
        PlayerHelper.ProfileEditMode editMode = (PlayerHelper.ProfileEditMode)editModes.stream().findFirst().get();
        ti.a action = editMode == PlayerHelper.ProfileEditMode.ADD ? ti.a.a : (editMode == PlayerHelper.ProfileEditMode.UPDATE_DISPLAY ? ti.a.d : ti.a.c);
        ti packet = new ti(action, new adx[0]);
        GameProfile profile = new GameProfile(id, name);
        if (texture != null) {
            profile.getProperties().put((Object)"textures", (Object)new Property("textures", texture, signature));
        }
        packet.b().add(new ti.b(profile, latency, gameMode == null ? null : cas.a((int)gameMode.getValue()), display == null ? null : Handler.componentToNMS(FormattedTextHelper.parse((String)display, (ChatColor)ChatColor.WHITE))));
        PacketHelperImpl.send(player, (rc)packet);
    }

    public void sendPlayerInfoRemovePacket(Player player, UUID id) {
        ti packet = new ti(ti.a.e, new adx[0]);
        GameProfile profile = new GameProfile(id, "name");
        packet.b().add(new ti.b(profile, 0, null, null));
        PacketHelperImpl.send(player, (rc)packet);
    }

    public void sendClimbableMaterials(Player player, List<Material> materials) {
        Map packetInput = aii.a((hc)((CraftServer)Bukkit.getServer()).getServer().aU());
        Map tags = (Map)ReflectionHelper.getFieldValue(aii.a.class, (String)ReflectionMappingsInfo.TagNetworkSerialization_NetworkPayload_tags, packetInput.get(hb.h));
        IntList intList = (IntList)tags.get(ahy.aC.b());
        intList.clear();
        for (Material material : materials) {
            intList.add(hb.U.a((Object)CraftMagicNumbers.getBlock((Material)material)));
        }
        PacketHelperImpl.send(player, (rc)new vf(packetInput));
    }

    private /* synthetic */ void lambda$sendEntitySpawn$0(CraftWorld world, axk nmsEntity, List trackers, boolean autoTrack, final FakeEntity fake, final PlayerTag player) {
        adx nmsPlayer = ((CraftPlayer)player.getPlayerEntity()).getHandle();
        aeo conn = nmsPlayer.b;
        final adv tracker = new adv(world.getHandle(), nmsEntity, 1, true, arg_0 -> ((aeo)conn).a(arg_0), Collections.singleton(nmsPlayer.b));
        tracker.b(nmsPlayer);
        TrackerData data = new TrackerData();
        data.player = player;
        data.tracker = tracker;
        trackers.add(data);
        if (autoTrack) {
            new BukkitRunnable(){
                boolean wasOnline = true;

                public void run() {
                    if (!fake.entity.isFakeValid) {
                        this.cancel();
                        return;
                    }
                    if (player.isOnline()) {
                        if (!this.wasOnline) {
                            tracker.b(((CraftPlayer)player.getPlayerEntity()).getHandle());
                            this.wasOnline = true;
                        }
                        tracker.a();
                    } else if (this.wasOnline) {
                        this.wasOnline = false;
                    }
                }
            }.runTaskTimer((Plugin)Denizen.getInstance(), 1L, 1L);
        }
    }

    static {
        yb skinlayers = null;
        try {
            skinlayers = (yb)ReflectionHelper.getFields(boj.class).get(ReflectionMappingsInfo.Player_DATA_PLAYER_MODE_CUSTOMISATION).get(null);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        ENTITY_HUMAN_SKINLAYERS_DATAWATCHER = skinlayers;
    }

    public static class TrackerData {
        public PlayerTag player;
        public adv tracker;
    }
}

