/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_19.helpers;

import com.denizenscript.denizen.nms.interfaces.BlockHelper;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTagBuilder;
import com.denizenscript.denizen.nms.v1_19.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_19.helpers.PacketHelperImpl;
import com.denizenscript.denizen.nms.v1_19.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.VanillaTagHelper;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Skull;
import org.bukkit.craftbukkit.v1_19_R3.CraftChunk;
import org.bukkit.craftbukkit.v1_19_R3.CraftServer;
import org.bukkit.craftbukkit.v1_19_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_19_R3.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_19_R3.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_19_R3.block.CraftSkull;
import org.bukkit.craftbukkit.v1_19_R3.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_19_R3.tag.CraftBlockTag;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftNamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class BlockHelperImpl
implements BlockHelper {
    public static final Field craftBlockEntityState_tileEntity = ReflectionHelper.getFields(CraftBlockEntityState.class).get((Object)"tileEntity");
    public static final Field craftBlockEntityState_snapshot = ReflectionHelper.getFields(CraftBlockEntityState.class).get((Object)"snapshot");
    public static final Field craftSkull_profile = ReflectionHelper.getFields(CraftSkull.class).get((Object)"profile");
    public static final Field BLOCK_MATERIAL = ReflectionHelper.getFields(dbp.class).getFirstOfType(dwn.class);
    public static final MethodHandle MATERIAL_PUSH_REACTION_SETTER = ReflectionHelper.getFinalSetterForFirstOfType(dwn.class, dwp.class);
    public static final MethodHandle BLOCK_STRENGTH_SETTER = ReflectionHelper.getFinalSetterForFirstOfType(dbp.a.class, Float.TYPE);
    public static MethodHandle BLOCKSTATEBASE_GETFLUIDSTATE = ReflectionHelper.getMethodHandle(dbp.a.class, (String)ReflectionMappingsInfo.BlockBehaviourBlockStateBase_getFluidState_method, (Class[])new Class[0]);
    public static MethodHandle FLUIDSTATE_ISRANDOMLYTICKING = ReflectionHelper.getMethodHandle((Class)BLOCKSTATEBASE_GETFLUIDSTATE.type().returnType(), (String)ReflectionMappingsInfo.FluidState_isRandomlyTicking_method, (Class[])new Class[0]);
    public static MethodHandle FLUIDSTATE_ISEMPTY = ReflectionHelper.getMethodHandle((Class)BLOCKSTATEBASE_GETFLUIDSTATE.type().returnType(), (String)ReflectionMappingsInfo.FluidState_isEmpty_method, (Class[])new Class[0]);
    public static MethodHandle FLUIDSTATE_CREATELEGACYBLOCK = ReflectionHelper.getMethodHandle((Class)BLOCKSTATEBASE_GETFLUIDSTATE.type().returnType(), (String)ReflectionMappingsInfo.FluidState_createLegacyBlock_method, (Class[])new Class[0]);
    public static MethodHandle FLUIDSTATE_ANIMATETICK = ReflectionHelper.getMethodHandle((Class)BLOCKSTATEBASE_GETFLUIDSTATE.type().returnType(), (String)ReflectionMappingsInfo.FluidState_animateTick_method, (Class[])new Class[]{cmi.class, gt.class, apo.class});
    public static MethodHandle HolderSet_Named_bind = ReflectionHelper.getMethodHandle(hh.c.class, (String)ReflectionMappingsInfo.HolderSetNamed_bind_method, (Class[])new Class[]{List.class});
    public static MethodHandle Holder_Reference_bindTags = ReflectionHelper.getMethodHandle(hd.c.class, (String)ReflectionMappingsInfo.HolderReference_bindTags_method, (Class[])new Class[]{Collection.class});

    public void applyPhysics(Location location) {
        gt pos = new gt(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        ((CraftWorld)location.getWorld()).getHandle().a(pos, CraftMagicNumbers.getBlock((Material)location.getBlock().getType()));
    }

    public static <T extends cze> T getTE(CraftBlockEntityState<T> cbs) {
        try {
            return (T)((cze)craftBlockEntityState_tileEntity.get(cbs));
        }
        catch (IllegalAccessException e) {
            Debug.echoError((Throwable)e);
            return null;
        }
    }

    public PlayerProfile getPlayerProfile(Skull skull) {
        GameProfile profile = ((dal)BlockHelperImpl.getTE((CraftSkull)skull)).f;
        if (profile == null) {
            return null;
        }
        String name = profile.getName();
        UUID id = profile.getId();
        Property property = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null);
        return new PlayerProfile(name, id, property != null ? property.getValue() : null);
    }

    public void setPlayerProfile(Skull skull, PlayerProfile playerProfile) {
        GameProfile gameProfile = new GameProfile(playerProfile.getUniqueId(), playerProfile.getName());
        if (playerProfile.hasTexture()) {
            gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", playerProfile.getTexture(), playerProfile.getTextureSignature()));
        }
        try {
            craftSkull_profile.set(skull, gameProfile);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
        skull.update();
    }

    public CompoundTag getNbtData(Block block) {
        cze te = ((CraftWorld)block.getWorld()).getHandle().getBlockEntity(new gt(block.getX(), block.getY(), block.getZ()), true);
        if (te != null) {
            re compound = te.m();
            return CompoundTagImpl.fromNMSTag(compound);
        }
        return null;
    }

    public void setNbtData(Block block, CompoundTag ctag) {
        CompoundTagBuilder builder = ctag.createBuilder();
        builder.putInt("x", block.getX());
        builder.putInt("y", block.getY());
        builder.putInt("z", block.getZ());
        ctag = builder.build();
        gt blockPos = new gt(block.getX(), block.getY(), block.getZ());
        cze te = ((CraftWorld)block.getWorld()).getHandle().getBlockEntity(blockPos, true);
        te.a(((CompoundTagImpl)ctag).toNMSTag());
    }

    public boolean setBlockResistance(Material material, float resistance) {
        cpi block = this.getMaterialBlock(material);
        if (block == null) {
            return false;
        }
        ReflectionHelper.setFieldValue(dbp.class, (String)ReflectionMappingsInfo.BlockBehaviour_explosionResistance, (Object)block, (Object)Float.valueOf(resistance));
        return true;
    }

    public float getBlockResistance(Material material) {
        cpi block = this.getMaterialBlock(material);
        if (block == null) {
            return 0.0f;
        }
        return ((Float)ReflectionHelper.getFieldValue(dbp.class, (String)ReflectionMappingsInfo.BlockBehaviour_explosionResistance, (Object)block)).floatValue();
    }

    public cpi getMaterialBlock(Material bukkitMaterial) {
        if (!bukkitMaterial.isBlock()) {
            return null;
        }
        return ((CraftBlockData)bukkitMaterial.createBlockData()).getState().b();
    }

    public dwn getInternalMaterial(Material bukkitMaterial) {
        try {
            return (dwn)BLOCK_MATERIAL.get(this.getMaterialBlock(bukkitMaterial));
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
            return null;
        }
    }

    public void setPushReaction(Material mat, BlockHelper.PistonPushReaction reaction) {
        try {
            MATERIAL_PUSH_REACTION_SETTER.invoke(this.getInternalMaterial(mat), dwp.values()[reaction.ordinal()]);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public float getBlockStrength(Material mat) {
        return this.getMaterialBlock((Material)mat).o().k;
    }

    public void setBlockStrength(Material mat, float strength) {
        try {
            BLOCK_STRENGTH_SETTER.invoke(this.getMaterialBlock(mat).o(), strength);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void doRandomTick(Location location) {
        gt pos = new gt(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        ddn nmsChunk = ((CraftChunk)location.getChunk()).getHandle(dds.o);
        dbq nmsBlock = nmsChunk.a_(pos);
        aip nmsWorld = ((CraftWorld)location.getWorld()).getHandle();
        if (nmsBlock.s()) {
            nmsBlock.b(nmsWorld, pos, nmsWorld.z);
        }
        try {
            Object fluid = BLOCKSTATEBASE_GETFLUIDSTATE.invoke(nmsBlock);
            if (FLUIDSTATE_ISRANDOMLYTICKING.invoke(fluid)) {
                FLUIDSTATE_ANIMATETICK.invoke(fluid, nmsWorld, pos, nmsWorld.z);
            }
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public Instrument getInstrumentFor(Material mat) {
        cpi blockType = this.getMaterialBlock(mat);
        Optional aboveInstrument = dcs.a((dbq)blockType.o());
        dcs nmsInstrument = aboveInstrument.orElse(dcs.b((dbq)blockType.o()));
        return Instrument.values()[nmsInstrument.ordinal()];
    }

    public int getExpDrop(Block block, ItemStack item) {
        cpi blockType = this.getMaterialBlock(block.getType());
        if (blockType == null) {
            return 0;
        }
        return blockType.getExpDrop(((CraftBlock)block).getNMS(), ((CraftBlock)block).getCraftWorld().getHandle(), ((CraftBlock)block).getPosition(), item == null ? null : CraftItemStack.asNMSCopy((ItemStack)item), true);
    }

    public void setSpawnerSpawnedType(CreatureSpawner spawner, EntityTag entity) {
        spawner.setSpawnedType(entity.getBukkitEntityType());
        if (entity.getWaitingMechanisms() == null || entity.getWaitingMechanisms().size() == 0) {
            return;
        }
        try {
            bfh nmsEntity = ((CraftWorld)spawner.getWorld()).createEntity(spawner.getLocation(), entity.getBukkitEntityType().getEntityClass());
            EntityTag entityTag = new EntityTag((Entity)nmsEntity.getBukkitEntity());
            entityTag.isFake = true;
            entityTag.isFakeValid = true;
            for (Mechanism mechanism : entity.getWaitingMechanisms()) {
                entityTag.safeAdjustDuplicate(mechanism);
            }
            nmsEntity.dD();
            CraftCreatureSpawner bukkitSpawner = (CraftCreatureSpawner)spawner;
            dan nmsSnapshot = (dan)craftBlockEntityState_snapshot.get(bukkitSpawner);
            clk nmsSpawner = nmsSnapshot.d();
            cmy toSpawn = nmsSpawner.f;
            re tag = toSpawn.a();
            nmsEntity.f(tag);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void setSpawnerCustomRules(CreatureSpawner spawner, int skyMin, int skyMax, int blockMin, int blockMax) {
        try {
            CraftCreatureSpawner bukkitSpawner = (CraftCreatureSpawner)spawner;
            dan nmsSnapshot = (dan)craftBlockEntityState_snapshot.get(bukkitSpawner);
            clk nmsSpawner = nmsSnapshot.d();
            cmy toSpawn = nmsSpawner.f;
            cmy.a rules = skyMin == -1 ? null : new cmy.a(new apc((Comparable)Integer.valueOf(skyMin), (Comparable)Integer.valueOf(skyMax)), new apc((Comparable)Integer.valueOf(blockMin), (Comparable)Integer.valueOf(blockMax)));
            nmsSpawner.f = new cmy(toSpawn.c(), Optional.ofNullable(rules));
            nmsSpawner.e = bci.b();
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public Color getMapColor(Block block) {
        CraftBlock craftBlock = (CraftBlock)block;
        return Color.fromRGB((int)craftBlock.getNMS().d((clo)craftBlock.getHandle(), (gt)craftBlock.getPosition()).ak);
    }

    public void setVanillaTags(Material material, Set<NamespacedKey> tags) {
        hd.c nmsHolder = this.getMaterialBlock(material).r();
        nmsHolder.c().forEach(arg_0 -> BlockHelperImpl.lambda$setVanillaTags$0((hd)nmsHolder, arg_0));
        ArrayList<anv> newNmsTags = new ArrayList<anv>();
        for (NamespacedKey tag : tags) {
            anv newNmsTag = anv.a((adc)ja.f.c(), (add)CraftNamespacedKey.toMinecraft((NamespacedKey)tag));
            hh.c nmsHolderSet = ja.f.a(newNmsTag);
            List nmsHolders = nmsHolderSet.a().collect(Collectors.toCollection(ArrayList::new));
            nmsHolders.add(nmsHolder);
            try {
                HolderSet_Named_bind.invoke(nmsHolderSet, nmsHolders);
            }
            catch (Throwable ex) {
                Debug.echoError((Throwable)ex);
            }
            newNmsTags.add(newNmsTag);
            VanillaTagHelper.addOrUpdateMaterialTag((Tag)new CraftBlockTag((hq)ja.f, newNmsTag));
        }
        try {
            Holder_Reference_bindTags.invoke((hd)nmsHolder, newNmsTags);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
        zl tagsPacket = new zl(any.a((hk)((CraftServer)Bukkit.getServer()).getServer().aY()));
        for (Player player : Bukkit.getOnlinePlayers()) {
            PacketHelperImpl.send(player, tagsPacket);
        }
    }

    private static /* synthetic */ void lambda$setVanillaTags$0(hd nmsHolder, anv nmsTag) {
        hh.c nmsHolderSet = ja.f.b(nmsTag).orElse(null);
        if (nmsHolderSet == null) {
            return;
        }
        List nmsHolders = nmsHolderSet.a().collect(Collectors.toCollection(ArrayList::new));
        nmsHolders.remove(nmsHolder);
        try {
            HolderSet_Named_bind.invoke(nmsHolderSet, nmsHolders);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
        VanillaTagHelper.updateMaterialTag((Tag)new CraftBlockTag((hq)ja.f, nmsTag));
    }
}

