/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_20.helpers;

import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import java.util.HashMap;
import java.util.Map;

public class EntityDataNameMapper {
    public static final Map<Class<? extends bsw>, Map<String, Integer>> entityDataNames = new HashMap<Class<? extends bsw>, Map<String, Integer>>();

    public static void registerDataName(Class<? extends bsw> entityClass, int id, String name) {
        entityDataNames.computeIfAbsent(entityClass, k -> new HashMap()).put(name, id);
    }

    public static int getIdForName(Class<? extends bsw> entityClass, String name) {
        Class<? extends bsw> currentClass = entityClass;
        int id = EntityDataNameMapper.getIdFromClass(currentClass, name);
        while (id == -1 && (currentClass = currentClass.getSuperclass()) != Object.class) {
            id = EntityDataNameMapper.getIdFromClass(currentClass, name);
        }
        return id;
    }

    private static int getIdFromClass(Class<?> entityClass, String name) {
        int id;
        Map<String, Integer> nameToId = entityDataNames.get(entityClass);
        int n = id = nameToId != null ? nameToId.getOrDefault(name, -1) : -1;
        if (id == -1 && ArgumentHelper.matchesInteger((String)name)) {
            id = new ElementTag(name).asInt();
        }
        return id;
    }

    static {
        EntityDataNameMapper.registerDataName(bsw.class, 0, "entity_flags");
        EntityDataNameMapper.registerDataName(bsw.class, 1, "air_ticks");
        EntityDataNameMapper.registerDataName(bsw.class, 2, "custom_name");
        EntityDataNameMapper.registerDataName(bsw.class, 3, "custom_name_visible");
        EntityDataNameMapper.registerDataName(bsw.class, 4, "silent");
        EntityDataNameMapper.registerDataName(bsw.class, 5, "no_gravity");
        EntityDataNameMapper.registerDataName(bsw.class, 6, "pose");
        EntityDataNameMapper.registerDataName(bsw.class, 7, "frozen_ticks");
        EntityDataNameMapper.registerDataName(btm.class, 8, "width");
        EntityDataNameMapper.registerDataName(btm.class, 9, "height");
        EntityDataNameMapper.registerDataName(btm.class, 10, "responsive");
        EntityDataNameMapper.registerDataName(bsv.class, 8, "transform_interpolation_start");
        EntityDataNameMapper.registerDataName(bsv.class, 9, "transform_interpolation_duration");
        EntityDataNameMapper.registerDataName(bsv.class, 10, "movement_interpolation_duration");
        EntityDataNameMapper.registerDataName(bsv.class, 11, "translation");
        EntityDataNameMapper.registerDataName(bsv.class, 12, "scale");
        EntityDataNameMapper.registerDataName(bsv.class, 13, "left_rotation");
        EntityDataNameMapper.registerDataName(bsv.class, 14, "right_rotation");
        EntityDataNameMapper.registerDataName(bsv.class, 15, "billboard");
        EntityDataNameMapper.registerDataName(bsv.class, 16, "brightness");
        EntityDataNameMapper.registerDataName(bsv.class, 17, "view_range");
        EntityDataNameMapper.registerDataName(bsv.class, 18, "shadow_radius");
        EntityDataNameMapper.registerDataName(bsv.class, 19, "shadow_strength");
        EntityDataNameMapper.registerDataName(bsv.class, 20, "width");
        EntityDataNameMapper.registerDataName(bsv.class, 21, "height");
        EntityDataNameMapper.registerDataName(bsv.class, 22, "glow_color");
        EntityDataNameMapper.registerDataName(bsv.b.class, 23, "material");
        EntityDataNameMapper.registerDataName(bsv.g.class, 23, "item");
        EntityDataNameMapper.registerDataName(bsv.g.class, 24, "model_transform");
        EntityDataNameMapper.registerDataName(bsv.l.class, 23, "text");
        EntityDataNameMapper.registerDataName(bsv.l.class, 24, "line_width");
        EntityDataNameMapper.registerDataName(bsv.l.class, 25, "background_color");
        EntityDataNameMapper.registerDataName(bsv.l.class, 26, "text_opacity");
        EntityDataNameMapper.registerDataName(bsv.l.class, 27, "text_display_flags");
        EntityDataNameMapper.registerDataName(cnz.class, 8, "item");
        EntityDataNameMapper.registerDataName(cnk.class, 8, "item");
        EntityDataNameMapper.registerDataName(cnm.class, 8, "spawn_position");
        EntityDataNameMapper.registerDataName(bss.class, 8, "radius");
        EntityDataNameMapper.registerDataName(bss.class, 9, "color");
        EntityDataNameMapper.registerDataName(bss.class, 10, "waiting");
        EntityDataNameMapper.registerDataName(bss.class, 11, "particle");
        EntityDataNameMapper.registerDataName(cnn.class, 8, "hooked_entity_id");
        EntityDataNameMapper.registerDataName(cnn.class, 9, "catchable");
        EntityDataNameMapper.registerDataName(cnf.class, 8, "abstract_arrow_flags");
        EntityDataNameMapper.registerDataName(cnf.class, 9, "piercing_level");
        EntityDataNameMapper.registerDataName(cnh.class, 10, "color");
        EntityDataNameMapper.registerDataName(coe.class, 10, "loyalty_level");
        EntityDataNameMapper.registerDataName(coe.class, 11, "enchantment_glint");
        EntityDataNameMapper.registerDataName(cox.class, 8, "shaking_ticks");
        EntityDataNameMapper.registerDataName(cox.class, 9, "shaking_direction");
        EntityDataNameMapper.registerDataName(cox.class, 10, "damage_taken");
        EntityDataNameMapper.registerDataName(cox.class, 11, "type");
        EntityDataNameMapper.registerDataName(cox.class, 12, "left_paddle_moving");
        EntityDataNameMapper.registerDataName(cox.class, 13, "right_paddle_moving");
        EntityDataNameMapper.registerDataName(cox.class, 14, "bubble_shaking_ticks");
        EntityDataNameMapper.registerDataName(cic.class, 8, "beam_target");
        EntityDataNameMapper.registerDataName(cic.class, 9, "showing_bottom");
        EntityDataNameMapper.registerDataName(cnv.class, 8, "item");
        EntityDataNameMapper.registerDataName(cnl.class, 8, "item");
        EntityDataNameMapper.registerDataName(cof.class, 8, "invulnerable");
        EntityDataNameMapper.registerDataName(cnm.class, 8, "item");
        EntityDataNameMapper.registerDataName(cnm.class, 9, "shooter_id");
        EntityDataNameMapper.registerDataName(cnm.class, 10, "shot_at_angle");
        EntityDataNameMapper.registerDataName(cjc.class, 8, "item");
        EntityDataNameMapper.registerDataName(cjc.class, 9, "rotation");
        EntityDataNameMapper.registerDataName(cje.class, 8, "painting_variant");
        EntityDataNameMapper.registerDataName(btr.class, 8, "living_entity_flags");
        EntityDataNameMapper.registerDataName(btr.class, 9, "health");
        EntityDataNameMapper.registerDataName(btr.class, 10, "potion_effect_color");
        EntityDataNameMapper.registerDataName(btr.class, 11, "is_potion_effect_ambient");
        EntityDataNameMapper.registerDataName(btr.class, 12, "arrows_in_body");
        EntityDataNameMapper.registerDataName(btr.class, 13, "bee_stingers_in_body");
        EntityDataNameMapper.registerDataName(btr.class, 14, "bed_location");
        EntityDataNameMapper.registerDataName(cmz.class, 15, "additional_hearts");
        EntityDataNameMapper.registerDataName(cmz.class, 16, "score");
        EntityDataNameMapper.registerDataName(cmz.class, 17, "skin_parts");
        EntityDataNameMapper.registerDataName(cmz.class, 18, "main_hand");
        EntityDataNameMapper.registerDataName(cmz.class, 19, "left_shoulder_entity");
        EntityDataNameMapper.registerDataName(cmz.class, 20, "right_shoulder_entity");
        EntityDataNameMapper.registerDataName(ciz.class, 15, "armor_stand_flags");
        EntityDataNameMapper.registerDataName(ciz.class, 16, "head_rotation");
        EntityDataNameMapper.registerDataName(ciz.class, 17, "body_rotation");
        EntityDataNameMapper.registerDataName(ciz.class, 18, "left_arm_rotation");
        EntityDataNameMapper.registerDataName(ciz.class, 19, "right_arm_rotation");
        EntityDataNameMapper.registerDataName(ciz.class, 20, "left_leg_rotation");
        EntityDataNameMapper.registerDataName(ciz.class, 21, "right_leg_rotation");
        EntityDataNameMapper.registerDataName(btt.class, 15, "mob_flags");
        EntityDataNameMapper.registerDataName(cfc.class, 16, "bat_flags");
        EntityDataNameMapper.registerDataName(cfp.class, 16, "treasure_location");
        EntityDataNameMapper.registerDataName(cfp.class, 17, "has_fish");
        EntityDataNameMapper.registerDataName(cfp.class, 18, "moisture_level");
        EntityDataNameMapper.registerDataName(cfe.class, 16, "from_bucket");
        EntityDataNameMapper.registerDataName(cga.class, 17, "puff_state");
        EntityDataNameMapper.registerDataName(cgh.class, 17, "variant");
        EntityDataNameMapper.registerDataName(bsq.class, 16, "is_baby");
        EntityDataNameMapper.registerDataName(chy.class, 17, "sniffer_state");
        EntityDataNameMapper.registerDataName(chy.class, 18, "finish_dig_time");
        EntityDataNameMapper.registerDataName(chl.class, 17, "horse_flags");
        EntityDataNameMapper.registerDataName(chn.class, 18, "variant");
        EntityDataNameMapper.registerDataName(cgy.class, 18, "is_dashing");
        EntityDataNameMapper.registerDataName(cgy.class, 19, "last_pose_change");
        EntityDataNameMapper.registerDataName(chk.class, 18, "has_chest");
        EntityDataNameMapper.registerDataName(cho.class, 19, "strength");
        EntityDataNameMapper.registerDataName(cho.class, 20, "carpet_color");
        EntityDataNameMapper.registerDataName(cho.class, 21, "variant");
        EntityDataNameMapper.registerDataName(cgt.class, 17, "variant");
        EntityDataNameMapper.registerDataName(cgt.class, 18, "playing_dead");
        EntityDataNameMapper.registerDataName(cgt.class, 19, "from_bucket");
        EntityDataNameMapper.registerDataName(cfi.class, 17, "bee_flags");
        EntityDataNameMapper.registerDataName(cfi.class, 18, "anger_time");
        EntityDataNameMapper.registerDataName(cfr.class, 17, "type");
        EntityDataNameMapper.registerDataName(cfr.class, 18, "fox_flags");
        EntityDataNameMapper.registerDataName(cfr.class, 19, "first_trusted_uuid");
        EntityDataNameMapper.registerDataName(cfr.class, 20, "second_trusted_uuid");
        EntityDataNameMapper.registerDataName(chb.class, 17, "variant");
        EntityDataNameMapper.registerDataName(chb.class, 18, "target_id");
        EntityDataNameMapper.registerDataName(cfv.class, 17, "is_trusting");
        EntityDataNameMapper.registerDataName(cfw.class, 17, "ask_for_bamboo_timer");
        EntityDataNameMapper.registerDataName(cfw.class, 18, "sneeze_timer");
        EntityDataNameMapper.registerDataName(cfw.class, 19, "eat_timer");
        EntityDataNameMapper.registerDataName(cfw.class, 20, "main_gene");
        EntityDataNameMapper.registerDataName(cfw.class, 21, "hidden_gene");
        EntityDataNameMapper.registerDataName(cfw.class, 22, "panda_flags");
        EntityDataNameMapper.registerDataName(cfy.class, 17, "has_saddle");
        EntityDataNameMapper.registerDataName(cfy.class, 18, "boost_ticks");
        EntityDataNameMapper.registerDataName(cgb.class, 17, "type");
        EntityDataNameMapper.registerDataName(cgi.class, 17, "home_location");
        EntityDataNameMapper.registerDataName(cgi.class, 18, "has_egg");
        EntityDataNameMapper.registerDataName(cgi.class, 19, "laying_egg");
        EntityDataNameMapper.registerDataName(cgi.class, 20, "travel_location");
        EntityDataNameMapper.registerDataName(cgi.class, 21, "going_home");
        EntityDataNameMapper.registerDataName(cgi.class, 20, "traveling");
        EntityDataNameMapper.registerDataName(cfz.class, 17, "standing_up");
        EntityDataNameMapper.registerDataName(clj.class, 17, "immune_to_zombification");
        EntityDataNameMapper.registerDataName(cfu.class, 17, "variant");
        EntityDataNameMapper.registerDataName(cgd.class, 17, "sheep_wool_flags");
        EntityDataNameMapper.registerDataName(cks.class, 17, "boost_ticks");
        EntityDataNameMapper.registerDataName(cks.class, 18, "shaking");
        EntityDataNameMapper.registerDataName(cks.class, 19, "has_saddle");
        EntityDataNameMapper.registerDataName(buo.class, 17, "tamable_animal_flags");
        EntityDataNameMapper.registerDataName(buo.class, 18, "owner");
        EntityDataNameMapper.registerDataName(cfk.class, 19, "variant");
        EntityDataNameMapper.registerDataName(cfk.class, 20, "lying");
        EntityDataNameMapper.registerDataName(cfk.class, 20, "relaxed");
        EntityDataNameMapper.registerDataName(cfk.class, 21, "collar_color");
        EntityDataNameMapper.registerDataName(cgk.class, 19, "begging");
        EntityDataNameMapper.registerDataName(cgk.class, 20, "collar_color");
        EntityDataNameMapper.registerDataName(cgk.class, 21, "anger_time");
        EntityDataNameMapper.registerDataName(cfx.class, 19, "variant");
        EntityDataNameMapper.registerDataName(cmh.class, 17, "head_shake_ticks");
        EntityDataNameMapper.registerDataName(cmm.class, 18, "villager_data");
        EntityDataNameMapper.registerDataName(cft.class, 16, "iron_golem_flags");
        EntityDataNameMapper.registerDataName(cgf.class, 16, "snow_golem_pumpkin_flags");
        EntityDataNameMapper.registerDataName(ckl.class, 16, "attach_face");
        EntityDataNameMapper.registerDataName(ckl.class, 17, "attachment_location");
        EntityDataNameMapper.registerDataName(ckl.class, 18, "peek");
        EntityDataNameMapper.registerDataName(ckl.class, 19, "color");
        EntityDataNameMapper.registerDataName(clo.class, 16, "immune_to_zombification");
        EntityDataNameMapper.registerDataName(clp.class, 17, "is_baby");
        EntityDataNameMapper.registerDataName(clp.class, 18, "charging_crossbow");
        EntityDataNameMapper.registerDataName(clp.class, 19, "dancing");
        EntityDataNameMapper.registerDataName(cjo.class, 16, "blaze_flags");
        EntityDataNameMapper.registerDataName(cjr.class, 16, "state");
        EntityDataNameMapper.registerDataName(cjr.class, 17, "charged");
        EntityDataNameMapper.registerDataName(cjr.class, 18, "ignited");
        EntityDataNameMapper.registerDataName(chh.class, 17, "screaming");
        EntityDataNameMapper.registerDataName(chh.class, 18, "has_left_horn");
        EntityDataNameMapper.registerDataName(chh.class, 19, "has_right_horn");
        EntityDataNameMapper.registerDataName(ckb.class, 16, "spikes_retracted");
        EntityDataNameMapper.registerDataName(ckb.class, 17, "target_id");
        EntityDataNameMapper.registerDataName(col.class, 16, "celebrating");
        EntityDataNameMapper.registerDataName(cki.class, 17, "charging_crossbow");
        EntityDataNameMapper.registerDataName(ckp.class, 17, "spell");
        EntityDataNameMapper.registerDataName(ckv.class, 17, "drinking_potion");
        EntityDataNameMapper.registerDataName(ckt.class, 16, "vex_flags");
        EntityDataNameMapper.registerDataName(ckq.class, 16, "spider_flags");
        EntityDataNameMapper.registerDataName(cmd.class, 16, "anger_level");
        EntityDataNameMapper.registerDataName(cix.class, 16, "center_head_target");
        EntityDataNameMapper.registerDataName(cix.class, 17, "left_head_target");
        EntityDataNameMapper.registerDataName(cix.class, 18, "right_head_target");
        EntityDataNameMapper.registerDataName(cix.class, 19, "invulnerable_time");
        EntityDataNameMapper.registerDataName(ckx.class, 16, "is_baby");
        EntityDataNameMapper.registerDataName(cky.class, 16, "is_baby");
        EntityDataNameMapper.registerDataName(cky.class, 17, "type");
        EntityDataNameMapper.registerDataName(cky.class, 18, "converting_in_water");
        EntityDataNameMapper.registerDataName(ckz.class, 19, "is_converting");
        EntityDataNameMapper.registerDataName(ckz.class, 20, "villager_data");
        EntityDataNameMapper.registerDataName(cjv.class, 16, "carried_block");
        EntityDataNameMapper.registerDataName(cjv.class, 17, "screaming");
        EntityDataNameMapper.registerDataName(cjv.class, 18, "staring");
        EntityDataNameMapper.registerDataName(cid.class, 16, "phase");
        EntityDataNameMapper.registerDataName(cjz.class, 16, "attacking");
        EntityDataNameMapper.registerDataName(ckh.class, 16, "size");
        EntityDataNameMapper.registerDataName(cko.class, 16, "size");
        EntityDataNameMapper.registerDataName(cov.class, 8, "shaking_ticks");
        EntityDataNameMapper.registerDataName(cov.class, 9, "shaking_direction");
        EntityDataNameMapper.registerDataName(cov.class, 10, "damage_taken");
        EntityDataNameMapper.registerDataName(cov.class, 11, "display_block_id");
        EntityDataNameMapper.registerDataName(cov.class, 12, "display_block_y");
        EntityDataNameMapper.registerDataName(cov.class, 13, "show_display_block");
        EntityDataNameMapper.registerDataName(cpe.class, 14, "has_fuel");
        EntityDataNameMapper.registerDataName(cpd.class, 14, "command");
        EntityDataNameMapper.registerDataName(cpd.class, 15, "last_output");
        EntityDataNameMapper.registerDataName(cjk.class, 8, "fuse_ticks");
    }
}

