/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_20.impl;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.BiomeNMS;
import com.denizenscript.denizen.nms.v1_20.ReflectionMappingsInfo;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_20_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftEntityType;
import org.bukkit.craftbukkit.v1_20_R4.util.CraftLocation;
import org.bukkit.craftbukkit.v1_20_R4.util.CraftNamespacedKey;
import org.bukkit.entity.EntityType;

public class BiomeNMSImpl
extends BiomeNMS {
    public static final MethodHandle BIOME_CLIMATESETTINGS_CONSTRUCTOR = ReflectionHelper.getConstructor(dcz.b.class, (Class[])new Class[]{Boolean.TYPE, Float.TYPE, dcz.d.class, Float.TYPE});
    public ji<dcz> biomeHolder;
    public arf world;

    public BiomeNMSImpl(arf world, NamespacedKey key) {
        super((World)world.getWorld(), key);
        this.world = world;
        this.biomeHolder = world.H_().d(lq.az).b(ale.a((ale)lq.az, (alf)CraftNamespacedKey.toMinecraft((NamespacedKey)key))).orElse(null);
    }

    public BiomeNMS.DownfallType getDownfallTypeAt(Location location) {
        dcz.c precipitation = ((dcz)this.biomeHolder.a()).a(CraftLocation.toBlockPosition((Location)location));
        return switch (precipitation) {
            default -> throw new IncompatibleClassChangeError();
            case dcz.c.b -> BiomeNMS.DownfallType.RAIN;
            case dcz.c.c -> BiomeNMS.DownfallType.SNOW;
            case dcz.c.a -> BiomeNMS.DownfallType.NONE;
        };
    }

    public float getHumidity() {
        return ((dcz)this.biomeHolder.a()).i.d();
    }

    public float getBaseTemperature() {
        return ((dcz)this.biomeHolder.a()).g();
    }

    public float getTemperatureAt(Location location) {
        return ((dcz)this.biomeHolder.a()).f(CraftLocation.toBlockPosition((Location)location));
    }

    public boolean hasDownfall() {
        return ((dcz)this.biomeHolder.a()).c();
    }

    public List<EntityType> getAmbientEntities() {
        return this.getSpawnableEntities(btu.c);
    }

    public List<EntityType> getCreatureEntities() {
        return this.getSpawnableEntities(btu.b);
    }

    public List<EntityType> getMonsterEntities() {
        return this.getSpawnableEntities(btu.a);
    }

    public List<EntityType> getWaterEntities() {
        return this.getSpawnableEntities(btu.f);
    }

    public int getFoliageColor() {
        if (((dcz)this.biomeHolder.a()).f() != 0) {
            return ((dcz)this.biomeHolder.a()).f();
        }
        float temperature = this.clampColor(this.getBaseTemperature());
        float humidity = this.clampColor(this.getHumidity());
        int temperatureValue = (int)((1.0f - temperature) * 255.0f);
        int humidityValue = (int)((1.0f - (humidity *= temperature)) * 255.0f);
        int index = temperatureValue << 8 | humidityValue;
        return index >= 65536 ? 4764952 : this.getColor(index / 256, index % 256).asRGB();
    }

    public void setClimate(boolean hasPrecipitation, float temperature, dcz.d temperatureModifier, float downfall) {
        try {
            Object newClimate = BIOME_CLIMATESETTINGS_CONSTRUCTOR.invoke(hasPrecipitation, temperature, temperatureModifier, downfall);
            ReflectionHelper.setFieldValue(dcz.class, (String)ReflectionMappingsInfo.Biome_climateSettings, (Object)this.biomeHolder.a(), (Object)newClimate);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void setHumidity(float humidity) {
        this.setClimate(this.hasDownfall(), this.getBaseTemperature(), this.getTemperatureModifier(), humidity);
    }

    public void setBaseTemperature(float baseTemperature) {
        this.setClimate(this.hasDownfall(), baseTemperature, this.getTemperatureModifier(), this.getHumidity());
    }

    public void setHasDownfall(boolean hasDownfall) {
        this.setClimate(hasDownfall, this.getBaseTemperature(), this.getTemperatureModifier(), this.getHumidity());
    }

    public void setFoliageColor(int color) {
        ReflectionHelper.setFieldValue(ddf.class, (String)ReflectionMappingsInfo.BiomeSpecialEffects_foliageColorOverride, (Object)((dcz)this.biomeHolder.a()).h(), Optional.of(color));
    }

    public int getFogColor() {
        return ((dcz)this.biomeHolder.a()).e();
    }

    public void setFogColor(int color) {
        ReflectionHelper.setFieldValue(ddf.class, (String)ReflectionMappingsInfo.BiomeSpecialEffects_fogColor, (Object)((dcz)this.biomeHolder.a()).h(), (Object)color);
    }

    public int getWaterFogColor() {
        return ((dcz)this.biomeHolder.a()).j();
    }

    public void setWaterFogColor(int color) {
        ReflectionHelper.setFieldValue(ddf.class, (String)ReflectionMappingsInfo.BiomeSpecialEffects_waterFogColor, (Object)((dcz)this.biomeHolder.a()).h(), (Object)color);
    }

    private List<EntityType> getSpawnableEntities(btu creatureType) {
        ddl mobs = ((dcz)this.biomeHolder.a()).b();
        bpk typeSettingList = mobs.a(creatureType);
        ArrayList<EntityType> entityTypes = new ArrayList<EntityType>();
        if (typeSettingList == null) {
            return entityTypes;
        }
        for (ddl.c meta : typeSettingList.e()) {
            entityTypes.add(CraftEntityType.minecraftToBukkit((btc)meta.b));
        }
        return entityTypes;
    }

    public void setTo(Block block) {
        duk chunk;
        if (((CraftWorld)block.getWorld()).getHandle() != this.world) {
            NMSHandler.instance.getBiomeNMS(block.getWorld(), this.getKey()).setTo(block);
            return;
        }
        iz pos = new iz(block.getX(), 0, block.getZ());
        if (this.world.B(pos) && (chunk = this.world.m(pos)) != null) {
            chunk.setBiome(block.getX() >> 2, block.getY() >> 2, block.getZ() >> 2, this.biomeHolder);
            chunk.a(true);
        }
    }

    public dcz.d getTemperatureModifier() {
        return ((dcz)this.biomeHolder.a()).i.c();
    }
}

