/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_20.helpers;

import com.denizenscript.denizen.nms.interfaces.BlockHelper;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.v1_20.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_20.helpers.NBTAdapter;
import com.denizenscript.denizen.nms.v1_20.helpers.PacketHelperImpl;
import com.denizenscript.denizen.nms.v1_20.impl.ProfileEditorImpl;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.VanillaTagHelper;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.common.ClientboundUpdateTagsPacket;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagNetworkSerialization;
import net.minecraft.util.InclusiveRange;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.MobSpawnerAbstract;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityMobSpawner;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.Fluid;
import org.bukkit.Bukkit;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Skull;
import org.bukkit.craftbukkit.v1_20_R4.CraftChunk;
import org.bukkit.craftbukkit.v1_20_R4.CraftRegistry;
import org.bukkit.craftbukkit.v1_20_R4.CraftServer;
import org.bukkit.craftbukkit.v1_20_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R4.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R4.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_20_R4.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_20_R4.block.CraftSkull;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R4.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R4.tag.CraftBlockTag;
import org.bukkit.craftbukkit.v1_20_R4.util.CraftLocation;
import org.bukkit.craftbukkit.v1_20_R4.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_20_R4.util.CraftNamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;

public class BlockHelperImpl
implements BlockHelper {
    public static final Field craftBlockEntityState_tileEntity = ReflectionHelper.getFields(CraftBlockEntityState.class).get("tileEntity");
    public static final Field craftBlockEntityState_snapshot = ReflectionHelper.getFields(CraftBlockEntityState.class).get("snapshot");
    public static final Field craftSkull_profile = ReflectionHelper.getFields(CraftSkull.class).get("profile");
    public static final MethodHandle MATERIAL_PUSH_REACTION_SETTER = ReflectionHelper.getFinalSetterForFirstOfType(BlockBase.BlockData.class, EnumPistonReaction.class);
    public static final MethodHandle BLOCK_STRENGTH_SETTER = ReflectionHelper.getFinalSetterForFirstOfType(BlockBase.BlockData.class, Float.TYPE);
    public static final MethodHandle HOLDERSET_NAMED_BIND = ReflectionHelper.getMethodHandle(HolderSet.Named.class, (String)ReflectionMappingsInfo.HolderSetNamed_bind_method, (Class[])new Class[]{List.class});
    public static final MethodHandle HOLDER_REFERENCE_BINDTAGS = ReflectionHelper.getMethodHandle(Holder.c.class, (String)ReflectionMappingsInfo.HolderReference_bindTags_method, (Class[])new Class[]{Collection.class});

    public void applyPhysics(Location location) {
        ((CraftWorld)location.getWorld()).getHandle().a(CraftLocation.toBlockPosition((Location)location), CraftMagicNumbers.getBlock((Material)location.getBlock().getType()));
    }

    public static <T extends TileEntity> T getTE(CraftBlockEntityState<T> cbs) {
        try {
            return (T)((TileEntity)craftBlockEntityState_tileEntity.get(cbs));
        }
        catch (IllegalAccessException e) {
            Debug.echoError((Throwable)e);
            return null;
        }
    }

    public PlayerProfile getPlayerProfile(Skull skull) {
        ResolvableProfile profile = ((TileEntitySkull)BlockHelperImpl.getTE((CraftSkull)skull)).i;
        if (profile == null) {
            return null;
        }
        Property property = (Property)Iterables.getFirst((Iterable)profile.e().get((Object)"textures"), null);
        return new PlayerProfile((String)profile.c().orElse(null), (UUID)profile.d().orElse(null), property != null ? property.value() : null);
    }

    public void setPlayerProfile(Skull skull, PlayerProfile playerProfile) {
        GameProfile gameProfile = ProfileEditorImpl.getGameProfile(playerProfile);
        try {
            craftSkull_profile.set(skull, gameProfile);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
        skull.update();
    }

    public CompoundBinaryTag getNbtData(org.bukkit.block.Block block) {
        TileEntity te = ((CraftWorld)block.getWorld()).getHandle().getBlockEntity(new BlockPosition(block.getX(), block.getY(), block.getZ()), true);
        if (te != null) {
            NBTTagCompound nmsData = te.b((HolderLookup.a)CraftRegistry.getMinecraftRegistry());
            return NBTAdapter.toAPI(nmsData);
        }
        return null;
    }

    public void setNbtData(org.bukkit.block.Block block, CompoundBinaryTag ctag) {
        NBTTagCompound nmsData = NBTAdapter.toNMS(ctag);
        nmsData.a("x", block.getX());
        nmsData.a("y", block.getY());
        nmsData.a("z", block.getZ());
        BlockPosition blockPos = new BlockPosition(block.getX(), block.getY(), block.getZ());
        TileEntity te = ((CraftWorld)block.getWorld()).getHandle().getBlockEntity(blockPos, true);
        te.c(nmsData, (HolderLookup.a)CraftRegistry.getMinecraftRegistry());
    }

    public boolean setBlockResistance(Material material, float resistance) {
        Block block = CraftMagicNumbers.getBlock((Material)material);
        if (block == null) {
            return false;
        }
        ReflectionHelper.setFieldValue(BlockBase.class, (String)ReflectionMappingsInfo.BlockBehaviour_explosionResistance, (Object)block, (Object)Float.valueOf(resistance));
        return true;
    }

    public float getBlockResistance(Material material) {
        Block block = CraftMagicNumbers.getBlock((Material)material);
        if (block == null) {
            return 0.0f;
        }
        return ((Float)ReflectionHelper.getFieldValue(BlockBase.class, (String)ReflectionMappingsInfo.BlockBehaviour_explosionResistance, (Object)block)).floatValue();
    }

    public IBlockData getMaterialBlockState(Material bukkitMaterial) {
        Block nmsBlock = CraftMagicNumbers.getBlock((Material)bukkitMaterial);
        return nmsBlock != null ? nmsBlock.o() : null;
    }

    public void setPushReaction(Material mat, BlockHelper.PistonPushReaction reaction) {
        try {
            MATERIAL_PUSH_REACTION_SETTER.invoke(this.getMaterialBlockState(mat), EnumPistonReaction.values()[reaction.ordinal()]);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public float getBlockStrength(Material mat) {
        return this.getMaterialBlockState((Material)mat).n;
    }

    public void setBlockStrength(Material mat, float strength) {
        try {
            BLOCK_STRENGTH_SETTER.invoke(this.getMaterialBlockState(mat), strength);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void doRandomTick(Location location) {
        Fluid fluid;
        BlockPosition pos = CraftLocation.toBlockPosition((Location)location);
        IChunkAccess nmsChunk = ((CraftChunk)location.getChunk()).getHandle(ChunkStatus.n);
        IBlockData nmsBlock = nmsChunk.a_(pos);
        WorldServer nmsWorld = ((CraftWorld)location.getWorld()).getHandle();
        if (nmsBlock.v()) {
            nmsBlock.b(nmsWorld, pos, nmsWorld.z);
        }
        if ((fluid = nmsBlock.u()).f()) {
            fluid.a((World)nmsWorld, pos, nmsWorld.z);
        }
    }

    public Instrument getInstrumentFor(Material mat) {
        return Instrument.values()[this.getMaterialBlockState(mat).A().ordinal()];
    }

    public int getExpDrop(org.bukkit.block.Block block, ItemStack item) {
        Block blockType = CraftMagicNumbers.getBlock((Material)block.getType());
        if (blockType == null) {
            return 0;
        }
        return blockType.getExpDrop(((CraftBlock)block).getNMS(), ((CraftBlock)block).getCraftWorld().getHandle(), ((CraftBlock)block).getPosition(), item == null ? null : CraftItemStack.asNMSCopy((ItemStack)item), true);
    }

    public void setSpawnerSpawnedType(CreatureSpawner spawner, EntityTag entity) {
        spawner.setSpawnedType(entity.getBukkitEntityType());
        if (entity.getWaitingMechanisms() == null || entity.getWaitingMechanisms().size() == 0) {
            return;
        }
        try {
            Entity bukkitEntity = ((CraftWorld)spawner.getWorld()).createEntity(spawner.getLocation(), entity.getBukkitEntityType().getEntityClass());
            net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)bukkitEntity).getHandle();
            EntityTag entityTag = new EntityTag(bukkitEntity);
            entityTag.isFake = true;
            entityTag.isFakeValid = true;
            for (Mechanism mechanism : entity.getWaitingMechanisms()) {
                entityTag.safeAdjustDuplicate(mechanism);
            }
            nmsEntity.dM();
            CraftCreatureSpawner bukkitSpawner = (CraftCreatureSpawner)spawner;
            TileEntityMobSpawner nmsSnapshot = (TileEntityMobSpawner)craftBlockEntityState_snapshot.get(bukkitSpawner);
            MobSpawnerAbstract nmsSpawner = nmsSnapshot.c();
            MobSpawnerData toSpawn = nmsSpawner.f;
            NBTTagCompound tag = toSpawn.a();
            nmsEntity.f(tag);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void setSpawnerCustomRules(CreatureSpawner spawner, int skyMin, int skyMax, int blockMin, int blockMax) {
        try {
            CraftCreatureSpawner bukkitSpawner = (CraftCreatureSpawner)spawner;
            TileEntityMobSpawner nmsSnapshot = (TileEntityMobSpawner)craftBlockEntityState_snapshot.get(bukkitSpawner);
            MobSpawnerAbstract nmsSpawner = nmsSnapshot.c();
            MobSpawnerData toSpawn = nmsSpawner.f;
            MobSpawnerData.a rules = skyMin == -1 ? null : new MobSpawnerData.a(new InclusiveRange((Comparable)Integer.valueOf(skyMin), (Comparable)Integer.valueOf(skyMax)), new InclusiveRange((Comparable)Integer.valueOf(blockMin), (Comparable)Integer.valueOf(blockMax)));
            nmsSpawner.f = new MobSpawnerData(toSpawn.d(), Optional.ofNullable(rules), toSpawn.f());
            nmsSpawner.e = SimpleWeightedRandomList.b();
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void setVanillaTags(Material material, Set<NamespacedKey> tags) {
        Holder.c nmsHolder = CraftMagicNumbers.getBlock((Material)material).s();
        nmsHolder.c().forEach(arg_0 -> BlockHelperImpl.lambda$setVanillaTags$0((Holder)nmsHolder, arg_0));
        ArrayList<TagKey> newNmsTags = new ArrayList<TagKey>();
        for (NamespacedKey tag : tags) {
            TagKey newNmsTag = TagKey.a((ResourceKey)BuiltInRegistries.e.c(), (MinecraftKey)CraftNamespacedKey.toMinecraft((NamespacedKey)tag));
            HolderSet.Named nmsHolderSet = BuiltInRegistries.e.a(newNmsTag);
            List nmsHolders = nmsHolderSet.a().collect(Collectors.toCollection(ArrayList::new));
            nmsHolders.add(nmsHolder);
            try {
                HOLDERSET_NAMED_BIND.invoke(nmsHolderSet, nmsHolders);
            }
            catch (Throwable ex) {
                Debug.echoError((Throwable)ex);
            }
            newNmsTags.add(newNmsTag);
            VanillaTagHelper.addOrUpdateMaterialTag((Tag)new CraftBlockTag((IRegistry)BuiltInRegistries.e, newNmsTag));
        }
        try {
            HOLDER_REFERENCE_BINDTAGS.invoke((Holder)nmsHolder, newNmsTags);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
        PacketHelperImpl.broadcast(new ClientboundUpdateTagsPacket(TagNetworkSerialization.a((LayeredRegistryAccess)((CraftServer)Bukkit.getServer()).getServer().bd())));
    }

    private static /* synthetic */ void lambda$setVanillaTags$0(Holder nmsHolder, TagKey nmsTag) {
        HolderSet.Named nmsHolderSet = BuiltInRegistries.e.b(nmsTag).orElse(null);
        if (nmsHolderSet == null) {
            return;
        }
        List nmsHolders = nmsHolderSet.a().collect(Collectors.toCollection(ArrayList::new));
        nmsHolders.remove(nmsHolder);
        try {
            HOLDERSET_NAMED_BIND.invoke(nmsHolderSet, nmsHolders);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
        VanillaTagHelper.updateMaterialTag((Tag)new CraftBlockTag((IRegistry)BuiltInRegistries.e, nmsTag));
    }
}

