/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.helpers;

import com.denizenscript.denizen.nms.interfaces.BlockHelper;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTagBuilder;
import com.denizenscript.denizen.nms.v1_21.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_21.impl.ProfileEditorImpl;
import com.denizenscript.denizen.nms.v1_21.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Skull;
import org.bukkit.craftbukkit.v1_21_R4.CraftChunk;
import org.bukkit.craftbukkit.v1_21_R4.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftSkull;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftMagicNumbers;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;

public class BlockHelperImpl
implements BlockHelper {
    public static final Field craftBlockEntityState_tileEntity;
    public static final Field craftBlockEntityState_snapshot;
    public static final Field craftSkull_profile;
    public static final MethodHandle MATERIAL_PUSH_REACTION_SETTER;
    public static final MethodHandle BLOCK_STRENGTH_SETTER;

    public void applyPhysics(Location location) {
        ((CraftWorld)location.getWorld()).getHandle().a(CraftLocation.toBlockPosition((Location)location), CraftMagicNumbers.getBlock((Material)location.getBlock().getType()));
    }

    public static <T extends dyo> T getTE(CraftBlockEntityState<T> cbs) {
        try {
            return (T)((dyo)craftBlockEntityState_tileEntity.get(cbs));
        }
        catch (IllegalAccessException e) {
            Debug.echoError((Throwable)e);
            return null;
        }
    }

    public PlayerProfile getPlayerProfile(Skull skull) {
        ddk profile = ((eae)BlockHelperImpl.getTE((CraftSkull)skull)).h;
        if (profile == null) {
            return null;
        }
        Property property = (Property)Iterables.getFirst((Iterable)profile.e().get((Object)"textures"), null);
        return new PlayerProfile((String)profile.c().orElse(null), (UUID)profile.d().orElse(null), property != null ? property.value() : null);
    }

    public void setPlayerProfile(Skull skull, PlayerProfile playerProfile) {
        GameProfile gameProfile = ProfileEditorImpl.getGameProfile(playerProfile);
        try {
            craftSkull_profile.set(skull, new ddk(gameProfile));
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
        skull.update();
    }

    public CompoundTag getNbtData(Block block) {
        dyo te = ((CraftWorld)block.getWorld()).getHandle().getBlockEntity(new iw(block.getX(), block.getY(), block.getZ()), true);
        if (te != null) {
            ua compound = te.b((ji.a)CraftRegistry.getMinecraftRegistry());
            return CompoundTagImpl.fromNMSTag(compound);
        }
        return null;
    }

    public void setNbtData(Block block, CompoundTag ctag) {
        CompoundTagBuilder builder = ctag.createBuilder();
        builder.putInt("x", block.getX());
        builder.putInt("y", block.getY());
        builder.putInt("z", block.getZ());
        ctag = builder.build();
        iw blockPos = new iw(block.getX(), block.getY(), block.getZ());
        dyo te = ((CraftWorld)block.getWorld()).getHandle().getBlockEntity(blockPos, true);
        te.c(((CompoundTagImpl)ctag).toNMSTag(), (ji.a)CraftRegistry.getMinecraftRegistry());
    }

    public boolean setBlockResistance(Material material, float resistance) {
        dno block = CraftMagicNumbers.getBlock((Material)material);
        if (block == null) {
            return false;
        }
        ReflectionHelper.setFieldValue(ebp.class, (String)ReflectionMappingsInfo.BlockBehaviour_explosionResistance, (Object)block, (Object)Float.valueOf(resistance));
        return true;
    }

    public float getBlockResistance(Material material) {
        dno block = CraftMagicNumbers.getBlock((Material)material);
        if (block == null) {
            return 0.0f;
        }
        return ((Float)ReflectionHelper.getFieldValue(ebp.class, (String)ReflectionMappingsInfo.BlockBehaviour_explosionResistance, (Object)block)).floatValue();
    }

    public ebq getMaterialBlockState(Material bukkitMaterial) {
        dno nmsBlock = CraftMagicNumbers.getBlock((Material)bukkitMaterial);
        return nmsBlock != null ? nmsBlock.m() : null;
    }

    public void setPushReaction(Material mat, BlockHelper.PistonPushReaction reaction) {
        try {
            MATERIAL_PUSH_REACTION_SETTER.invoke(this.getMaterialBlockState(mat), eyf.values()[reaction.ordinal()]);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public float getBlockStrength(Material mat) {
        return this.getMaterialBlockState((Material)mat).p;
    }

    public void setBlockStrength(Material mat, float strength) {
        try {
            BLOCK_STRENGTH_SETTER.invoke(this.getMaterialBlockState(mat), strength);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void doRandomTick(Location location) {
        eya fluid;
        iw pos = CraftLocation.toBlockPosition((Location)location);
        edn nmsChunk = ((CraftChunk)location.getChunk()).getHandle(eeo.n);
        ebq nmsBlock = nmsChunk.a_(pos);
        asb nmsWorld = ((CraftWorld)location.getWorld()).getHandle();
        if (nmsBlock.z()) {
            nmsBlock.b(nmsWorld, pos, nmsWorld.A);
        }
        if ((fluid = nmsBlock.y()).f()) {
            fluid.a((dkj)nmsWorld, pos, nmsWorld.A);
        }
    }

    public Instrument getInstrumentFor(Material mat) {
        return Instrument.values()[this.getMaterialBlockState(mat).E().ordinal()];
    }

    public int getExpDrop(Block block, ItemStack item) {
        dno blockType = CraftMagicNumbers.getBlock((Material)block.getType());
        if (blockType == null) {
            return 0;
        }
        return blockType.getExpDrop(((CraftBlock)block).getNMS(), ((CraftBlock)block).getCraftWorld().getHandle(), ((CraftBlock)block).getPosition(), item == null ? null : CraftItemStack.asNMSCopy((ItemStack)item), true);
    }

    public void setSpawnerSpawnedType(CreatureSpawner spawner, EntityTag entity) {
        spawner.setSpawnedType(entity.getBukkitEntityType());
        if (entity.getWaitingMechanisms() == null || entity.getWaitingMechanisms().size() == 0) {
            return;
        }
        try {
            Entity bukkitEntity = ((CraftWorld)spawner.getWorld()).createEntity(spawner.getLocation(), entity.getBukkitEntityType().getEntityClass());
            bxe nmsEntity = ((CraftEntity)bukkitEntity).getHandle();
            EntityTag entityTag = new EntityTag(bukkitEntity);
            entityTag.isFake = true;
            entityTag.isFakeValid = true;
            for (Mechanism mechanism : entity.getWaitingMechanisms()) {
                entityTag.safeAdjustDuplicate(mechanism);
            }
            nmsEntity.dS();
            CraftCreatureSpawner bukkitSpawner = (CraftCreatureSpawner)spawner;
            eag nmsSnapshot = (eag)craftBlockEntityState_snapshot.get(bukkitSpawner);
            djj nmsSpawner = nmsSnapshot.c();
            dld toSpawn = nmsSpawner.l;
            ua tag = toSpawn.a();
            nmsEntity.h(tag);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void setSpawnerCustomRules(CreatureSpawner spawner, int skyMin, int skyMax, int blockMin, int blockMax) {
        try {
            CraftCreatureSpawner bukkitSpawner = (CraftCreatureSpawner)spawner;
            eag nmsSnapshot = (eag)craftBlockEntityState_snapshot.get(bukkitSpawner);
            djj nmsSpawner = nmsSnapshot.c();
            dld toSpawn = nmsSpawner.l;
            dld.a rules = skyMin == -1 ? null : new dld.a(new azr((Comparable)Integer.valueOf(skyMin), (Comparable)Integer.valueOf(skyMax)), new azr((Comparable)Integer.valueOf(blockMin), (Comparable)Integer.valueOf(blockMax)));
            nmsSpawner.l = new dld(toSpawn.d(), Optional.ofNullable(rules), toSpawn.f());
            nmsSpawner.k = btm.a();
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    static {
        craftBlockEntityState_snapshot = ReflectionHelper.getFields(CraftBlockEntityState.class).get((Object)"snapshot");
        craftSkull_profile = ReflectionHelper.getFields(CraftSkull.class).get((Object)"profile");
        Field blockEntityField = ReflectionHelper.getFields(CraftBlockEntityState.class).getNoCheck("blockEntity");
        if (blockEntityField == null) {
            blockEntityField = ReflectionHelper.getFields(CraftBlockEntityState.class).get((Object)"tileEntity");
        }
        craftBlockEntityState_tileEntity = blockEntityField;
        MATERIAL_PUSH_REACTION_SETTER = ReflectionHelper.getFinalSetterForFirstOfType(ebp.a.class, eyf.class);
        BLOCK_STRENGTH_SETTER = ReflectionHelper.getFinalSetterForFirstOfType(ebp.a.class, Float.TYPE);
    }
}

