/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.helpers;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.ImprovedOfflinePlayer;
import com.denizenscript.denizen.nms.enums.CustomEntityType;
import com.denizenscript.denizen.nms.interfaces.PlayerHelper;
import com.denizenscript.denizen.nms.v1_21.Handler;
import com.denizenscript.denizen.nms.v1_21.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_21.helpers.ItemHelperImpl;
import com.denizenscript.denizen.nms.v1_21.helpers.PacketHelperImpl;
import com.denizenscript.denizen.nms.v1_21.impl.ImprovedOfflinePlayerImpl;
import com.denizenscript.denizen.nms.v1_21.impl.ProfileEditorImpl;
import com.denizenscript.denizen.nms.v1_21.impl.entities.CraftFakePlayerImpl;
import com.denizenscript.denizen.nms.v1_21.impl.entities.EntityItemProjectileImpl;
import com.denizenscript.denizen.nms.v1_21.impl.network.handlers.AbstractListenerPlayInImpl;
import com.denizenscript.denizen.nms.v1_21.impl.network.handlers.DenizenNetworkManagerImpl;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizen.utilities.entity.DenizenEntityType;
import com.denizenscript.denizen.utilities.entity.FakeEntity;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.mojang.authlib.GameProfile;
import it.unimi.dsi.fastutil.ints.IntList;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import net.md_5.bungee.api.ChatColor;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundUpdateTagsPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.protocol.game.PacketPlayOutBoss;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutExperience;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutRecipeUpdate;
import net.minecraft.network.protocol.game.PacketPlayOutRespawn;
import net.minecraft.network.protocol.game.PacketPlayOutSetCooldown;
import net.minecraft.network.protocol.game.PacketPlayOutStopSound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.OpList;
import net.minecraft.server.players.OpListEntry;
import net.minecraft.server.players.PlayerList;
import net.minecraft.stats.RecipeBookServer;
import net.minecraft.tags.TagNetworkSerialization;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.item.ItemCooldown;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.boss.BossBar;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R7.boss.CraftBossBar;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftNamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerHelperImpl
extends PlayerHelper {
    public static final Field ATTACK_COOLDOWN_TICKS = ReflectionHelper.getFields(EntityLiving.class).get(ReflectionMappingsInfo.LivingEntity_attackStrengthTicker, Integer.TYPE);
    public static final Field FLY_TICKS = ReflectionHelper.getFields(PlayerConnection.class).get(ReflectionMappingsInfo.ServerGamePacketListenerImpl_aboveGroundTickCount, Integer.TYPE);
    public static final Field VEHICLE_FLY_TICKS = ReflectionHelper.getFields(PlayerConnection.class).get(ReflectionMappingsInfo.ServerGamePacketListenerImpl_aboveGroundVehicleTickCount, Integer.TYPE);
    public static final Field PASSENGERS_PACKET_PASSENGERS = ReflectionHelper.getFields(PacketPlayOutMount.class).get(ReflectionMappingsInfo.ClientboundSetPassengersPacket_passengers, int[].class);
    public static final MethodHandle PLAYER_RESPAWNCONFIG_SETTER = ReflectionHelper.getFinalSetter(EntityPlayer.class, (String)ReflectionMappingsInfo.ServerPlayer_respawnConfig, EntityPlayer.RespawnConfig.class);
    public static final MethodHandle SERVER_RECIPE_BOOK_ADD_HIGHLIGHT = ReflectionHelper.getMethodHandle(RecipeBookServer.class, (String)ReflectionMappingsInfo.ServerRecipeBook_addHighlight_method, (Class[])new Class[]{ResourceKey.class});

    public void stopSound(Player player, NamespacedKey sound, SoundCategory category) {
        ((CraftPlayer)player).getHandle().g.b((Packet)new PacketPlayOutStopSound(sound == null ? null : CraftNamespacedKey.toMinecraft((NamespacedKey)sound), null));
    }

    public void deTrackEntity(Player player, Entity entity) {
        EntityPlayer nmsPlayer = ((CraftPlayer)player).getHandle();
        PlayerChunkMap.EntityTracker tracker = (PlayerChunkMap.EntityTracker)nmsPlayer.A().p().a.G.get(entity.getEntityId());
        if (tracker == null) {
            if (NMSHandler.debugPackets) {
                DenizenNetworkManagerImpl.doPacketOutput("Failed to de-track entity " + entity.getEntityId() + " for " + player.getName() + ": tracker null");
            }
            return;
        }
        this.sendEntityDestroy(player, entity);
        tracker.a(nmsPlayer);
    }

    public void addFakePassenger(List<PlayerTag> players, Entity vehicle, FakeEntity fakePassenger) {
        PacketPlayOutMount packet = new PacketPlayOutMount(((CraftEntity)vehicle).getHandle());
        int[] newPassengers = Arrays.copyOf(packet.b(), packet.b().length + 1);
        newPassengers[packet.b().length] = fakePassenger.id;
        try {
            PASSENGERS_PACKET_PASSENGERS.set(packet, newPassengers);
        }
        catch (IllegalAccessException e) {
            Debug.echoError((Throwable)e);
        }
        for (PlayerTag player : players) {
            PacketHelperImpl.send(player.getPlayerEntity(), packet);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FakeEntity sendEntitySpawn(List<PlayerTag> players, DenizenEntityType entityType, LocationTag location, ArrayList<Mechanism> mechanisms, int customId, UUID customUUID, boolean autoTrack) {
        void var9_15;
        Entity entity;
        CraftWorld world = (CraftWorld)location.getWorld();
        if (entityType.isCustom()) {
            if (entityType.customEntityType == CustomEntityType.ITEM_PROJECTILE) {
                ItemStack itemStack = new ItemStack(Material.STONE);
                for (Mechanism mechanism : mechanisms) {
                    if (!mechanism.matches("item") || !mechanism.requireObject(ItemTag.class)) continue;
                    itemStack = ((ItemTag)mechanism.valueAsType(ItemTag.class)).getItemStack();
                }
                EntityItemProjectileImpl entityItemProjectileImpl = new EntityItemProjectileImpl((net.minecraft.world.level.World)world.getHandle(), (Location)location, CraftItemStack.asNMSCopy((ItemStack)itemStack));
            } else {
                if (entityType.customEntityType != CustomEntityType.FAKE_PLAYER) throw new IllegalArgumentException("entityType");
                String name = null;
                Object skin = null;
                String blob = null;
                for (Mechanism mechanism : new ArrayList<Mechanism>(mechanisms)) {
                    if (mechanism.matches("name")) {
                        name = mechanism.getValue().asString();
                        mechanisms.remove(mechanism);
                    } else if (mechanism.matches("skin")) {
                        skin = mechanism.getValue().asString();
                        mechanisms.remove(mechanism);
                    } else if (mechanism.matches("skin_blob")) {
                        blob = mechanism.getValue().asString();
                        mechanisms.remove(mechanism);
                    }
                    if (name == null || skin == null && blob == null) continue;
                    break;
                }
                EntityPlayer entityPlayer = ((CraftFakePlayerImpl)NMSHandler.customEntityHelper.spawnFakePlayer((Location)location, name, skin, blob, false)).getHandle();
            }
        } else {
            entity = world.createEntity((Location)location, entityType.getBukkitEntityType().getEntityClass());
            net.minecraft.world.entity.Entity entity2 = ((CraftEntity)entity).getHandle();
        }
        if (customUUID != null) {
            var9_15.e(customId);
            var9_15.a(customUUID);
        }
        entity = new EntityTag((Entity)var9_15.getBukkitEntity());
        entity.isFake = true;
        entity.isFakeValid = true;
        for (Mechanism mechanism : mechanisms) {
            entity.safeAdjustDuplicate(mechanism);
        }
        var9_15.ej();
        FakeEntity fake = new FakeEntity(players, location, entity.getBukkitEntity().getEntityId());
        fake.entity = new EntityTag(entity.getBukkitEntity());
        fake.entity.isFake = true;
        fake.entity.isFakeValid = true;
        ArrayList trackers = new ArrayList();
        fake.triggerSpawnPacket = arg_0 -> this.lambda$sendEntitySpawn$0(world, (net.minecraft.world.entity.Entity)var9_15, trackers, autoTrack, fake, arg_0);
        for (PlayerTag player : players) {
            fake.triggerSpawnPacket.accept(player);
        }
        fake.triggerUpdatePacket = () -> {
            for (TrackerData tracker : trackers) {
                if (!tracker.player.isOnline()) continue;
                tracker.tracker.a();
            }
        };
        fake.triggerDestroyPacket = () -> {
            for (TrackerData tracker : trackers) {
                if (!tracker.player.isOnline()) continue;
                tracker.tracker.a(((CraftPlayer)tracker.player.getPlayerEntity()).getHandle());
            }
            trackers.clear();
        };
        return fake;
    }

    public void sendEntityDestroy(Player player, Entity entity) {
        ((CraftPlayer)player).getHandle().g.b((Packet)new PacketPlayOutEntityDestroy(new int[]{entity.getEntityId()}));
    }

    public int getFlyKickCooldown(Player player) {
        PlayerConnection conn = ((CraftPlayer)player).getHandle().g;
        if (conn instanceof AbstractListenerPlayInImpl) {
            AbstractListenerPlayInImpl denizenListener = (AbstractListenerPlayInImpl)conn;
            conn = denizenListener.oldListener;
        }
        try {
            return Math.max(80 - Math.max(FLY_TICKS.getInt(conn), VEHICLE_FLY_TICKS.getInt(conn)), 0);
        }
        catch (IllegalAccessException e) {
            Debug.echoError((Throwable)e);
            return 80;
        }
    }

    public void setFlyKickCooldown(Player player, int ticks) {
        ticks = 80 - ticks;
        PlayerConnection conn = ((CraftPlayer)player).getHandle().g;
        if (conn instanceof AbstractListenerPlayInImpl) {
            AbstractListenerPlayInImpl denizenListener = (AbstractListenerPlayInImpl)conn;
            conn = denizenListener.oldListener;
        }
        try {
            FLY_TICKS.setInt(conn, ticks);
            VEHICLE_FLY_TICKS.setInt(conn, ticks);
        }
        catch (IllegalAccessException e) {
            Debug.echoError((Throwable)e);
        }
    }

    public int ticksPassedDuringCooldown(Player player) {
        try {
            return ATTACK_COOLDOWN_TICKS.getInt(((CraftPlayer)player).getHandle());
        }
        catch (IllegalAccessException e) {
            Debug.echoError((Throwable)e);
            return -1;
        }
    }

    public float getMaxAttackCooldownTicks(Player player) {
        return ((CraftPlayer)player).getHandle().he() + 3.0f;
    }

    public void setAttackCooldown(Player player, int ticks) {
        try {
            ATTACK_COOLDOWN_TICKS.setInt(((CraftPlayer)player).getHandle(), ticks);
        }
        catch (IllegalAccessException e) {
            Debug.echoError((Throwable)e);
        }
    }

    public boolean hasChunkLoaded(Player player, Chunk chunk) {
        return ((CraftWorld)chunk.getWorld()).getHandle().p().a.a(new ChunkCoordIntPair(chunk.getX(), chunk.getZ()), false).stream().anyMatch(entityPlayer -> entityPlayer.cY().equals(player.getUniqueId()));
    }

    public void setTemporaryOp(Player player, boolean op) {
        DedicatedServer server = ((CraftServer)Bukkit.getServer()).getServer();
        NameAndId nameAndId = new NameAndId(((CraftPlayer)player).getProfile());
        OpList opList = server.aj().k();
        if (op) {
            opList.a(new OpListEntry(nameAndId, server.k(), opList.b(nameAndId)));
        } else {
            opList.a(nameAndId);
        }
        player.recalculatePermissions();
    }

    public void showEndCredits(Player player) {
        ((CraftPlayer)player).getHandle().k = true;
        ((CraftPlayer)player).getHandle().g.b((Packet)new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.f, 1.0f));
    }

    public ImprovedOfflinePlayer getOfflineData(UUID uuid) {
        return new ImprovedOfflinePlayerImpl(uuid);
    }

    public void resendRecipeDetails(Player player) {
        CraftingManager recipeManager = ((CraftServer)Bukkit.getServer()).getServer().aJ();
        PacketPlayOutRecipeUpdate updatePacket = new PacketPlayOutRecipeUpdate(recipeManager.b(), recipeManager.c());
        ((CraftPlayer)player).getHandle().g.b((Packet)updatePacket);
    }

    public void resendDiscoveredRecipes(Player player) {
        RecipeBookServer recipeBook = ((CraftPlayer)player).getHandle().L();
        recipeBook.a(((CraftPlayer)player).getHandle());
    }

    public void quietlyAddRecipe(Player player, NamespacedKey key) {
        RecipeBookServer recipeBook = ((CraftPlayer)player).getHandle().L();
        RecipeHolder<?> recipe = ItemHelperImpl.getNMSRecipe(key);
        if (recipe == null) {
            Debug.echoError((String)("Cannot add recipe '" + String.valueOf(key) + "': it does not exist."));
            return;
        }
        recipeBook.a(recipe.a());
        try {
            SERVER_RECIPE_BOOK_ADD_HIGHLIGHT.invoke(recipeBook, recipe.a());
        }
        catch (Throwable e) {
            Debug.echoError((Throwable)e);
        }
    }

    public byte getSkinLayers(Player player) {
        return (Byte)((CraftPlayer)player).getHandle().aD().a(Avatar.t);
    }

    public void setSkinLayers(Player player, byte flags) {
        ((CraftPlayer)player).getHandle().aD().a(Avatar.t, (Object)flags);
    }

    public void setBossBarTitle(BossBar bar, String title) {
        ((CraftBossBar)bar).getHandle().a = Handler.componentToNMS(FormattedTextHelper.parse((String)title, (ChatColor)ChatColor.WHITE));
        ((CraftBossBar)bar).getHandle().a(PacketPlayOutBoss::c);
    }

    public boolean getSpawnForced(Player player) {
        return ((CraftPlayer)player).getHandle().V().b();
    }

    public void setSpawnForced(Player player, boolean forced) {
        EntityPlayer nmsPlayer = ((CraftPlayer)player).getHandle();
        try {
            EntityPlayer.RespawnConfig config = nmsPlayer.V();
            config = new EntityPlayer.RespawnConfig(config.a(), forced);
            PLAYER_RESPAWNCONFIG_SETTER.invoke(nmsPlayer, config);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public Location getBedSpawnLocation(Player player) {
        EntityPlayer nmsPlayer = ((CraftPlayer)player).getHandle();
        EntityPlayer.RespawnConfig nmsRespawnConfig = nmsPlayer.V();
        if (nmsRespawnConfig == null) {
            return null;
        }
        WorldData.a nmsRespawnData = nmsRespawnConfig.a();
        WorldServer nmsWorld = MinecraftServer.getServer().a(nmsRespawnData.a());
        return nmsWorld != null ? new Location((World)nmsWorld.getWorld(), (double)nmsRespawnData.b().u(), (double)nmsRespawnData.b().v(), (double)nmsRespawnData.b().w(), nmsRespawnData.d(), nmsRespawnData.e()) : null;
    }

    public long getLastActionTime(Player player) {
        return ((CraftPlayer)player).getHandle().P();
    }

    public void sendPlayerInfoAddPacket(Player player, EnumSet<PlayerHelper.ProfileEditMode> editModes, String name, String display, UUID id, String texture, String signature, int latency, GameMode gameMode, boolean listed) {
        EnumSet<ClientboundPlayerInfoUpdatePacket.a> actions = EnumSet.noneOf(ClientboundPlayerInfoUpdatePacket.a.class);
        for (PlayerHelper.ProfileEditMode editMode : editModes) {
            actions.add(switch (editMode) {
                default -> throw new IncompatibleClassChangeError();
                case PlayerHelper.ProfileEditMode.ADD -> ClientboundPlayerInfoUpdatePacket.a.a;
                case PlayerHelper.ProfileEditMode.UPDATE_DISPLAY -> ClientboundPlayerInfoUpdatePacket.a.f;
                case PlayerHelper.ProfileEditMode.UPDATE_LATENCY -> ClientboundPlayerInfoUpdatePacket.a.e;
                case PlayerHelper.ProfileEditMode.UPDATE_GAME_MODE -> ClientboundPlayerInfoUpdatePacket.a.c;
                case PlayerHelper.ProfileEditMode.UPDATE_LISTED -> ClientboundPlayerInfoUpdatePacket.a.d;
            });
        }
        GameProfile profile = ProfileEditorImpl.createGameProfile(id, name, texture, signature);
        ClientboundPlayerInfoUpdatePacket.b entry = new ClientboundPlayerInfoUpdatePacket.b(id, profile, listed, latency, gameMode == null ? null : EnumGamemode.a((int)gameMode.getValue()), display == null ? null : Handler.componentToNMS(FormattedTextHelper.parse((String)display, (ChatColor)ChatColor.WHITE)), true, player.getPlayerListOrder(), null);
        PacketHelperImpl.send(player, ProfileEditorImpl.createInfoPacket(actions, List.of(entry)));
    }

    public void sendPlayerInfoRemovePacket(Player player, UUID id) {
        PacketHelperImpl.send(player, new ClientboundPlayerInfoRemovePacket(List.of(id)));
    }

    public void sendClimbableMaterials(Player player, List<Material> materials) {
        Map packetInput = TagNetworkSerialization.a((LayeredRegistryAccess)((CraftServer)Bukkit.getServer()).getServer().bd());
        Map tags = (Map)ReflectionHelper.getFieldValue(TagNetworkSerialization.a.class, (String)ReflectionMappingsInfo.TagNetworkSerializationNetworkPayload_tags, packetInput.get(BuiltInRegistries.e.g()));
        IntList climbableBlocks = (IntList)tags.get(TagsBlock.bd.b());
        climbableBlocks.clear();
        for (Material material : materials) {
            climbableBlocks.add(BuiltInRegistries.e.a((Object)CraftMagicNumbers.getBlock((Material)material)));
        }
        PacketHelperImpl.send(player, new ClientboundUpdateTagsPacket(packetInput));
    }

    public void refreshPlayer(Player player) {
        EntityPlayer nmsPlayer = ((CraftPlayer)player).getHandle();
        WorldServer nmsWorld = nmsPlayer.A();
        nmsPlayer.g.b((Packet)new PacketPlayOutRespawn(nmsPlayer.b(nmsWorld), 3));
        nmsPlayer.g.internalTeleport(PositionMoveRotation.a((net.minecraft.world.entity.Entity)nmsPlayer), Set.of());
        if (nmsPlayer.cq()) {
            nmsPlayer.g.b((Packet)new PacketPlayOutMount(nmsPlayer.dz()));
        }
        if (nmsPlayer.cr()) {
            nmsPlayer.g.b((Packet)new PacketPlayOutMount((net.minecraft.world.entity.Entity)nmsPlayer));
        }
        AxisAlignedBB boundingBox = AxisAlignedBB.a((Vec3D)nmsPlayer.dj().f(), (double)32.0, (double)32.0, (double)32.0);
        for (Object nmsEntity2 : nmsWorld.a(net.minecraft.world.entity.Entity.class, boundingBox, nmsEntity -> {
            Leashable nmsLeashable;
            return nmsEntity instanceof Leashable && nmsPlayer.equals((Object)(nmsLeashable = (Leashable)nmsEntity).C());
        })) {
            nmsPlayer.g.b((Packet)new PacketPlayOutAttachEntity((net.minecraft.world.entity.Entity)nmsEntity2, (net.minecraft.world.entity.Entity)nmsPlayer));
        }
        if (!nmsPlayer.hh().a.isEmpty()) {
            int tickCount = nmsPlayer.hh().b;
            for (Map.Entry entry : nmsPlayer.hh().a.entrySet()) {
                nmsPlayer.g.b((Packet)new PacketPlayOutSetCooldown((MinecraftKey)entry.getKey(), ((ItemCooldown.Info)entry.getValue()).b - tickCount));
            }
        }
        nmsPlayer.g.b((Packet)new PacketPlayOutExperience(nmsPlayer.cu, nmsPlayer.ct, nmsPlayer.cs));
        for (MobEffect nmsEffect : nmsPlayer.eW()) {
            nmsPlayer.g.b((Packet)new PacketPlayOutEntityEffect(nmsPlayer.aA(), nmsEffect, false));
        }
        nmsPlayer.z();
        PlayerList nmsPlayerList = MinecraftServer.getServer().aj();
        nmsPlayerList.d(nmsPlayer);
        nmsPlayerList.a(nmsPlayer, nmsWorld);
        nmsPlayerList.e(nmsPlayer);
    }

    private /* synthetic */ void lambda$sendEntitySpawn$0(CraftWorld world, net.minecraft.world.entity.Entity nmsEntity, List trackers, boolean autoTrack, final FakeEntity fake, final PlayerTag player) {
        EntityPlayer nmsPlayer = ((CraftPlayer)player.getPlayerEntity()).getHandle();
        PlayerConnection conn = nmsPlayer.g;
        final EntityTrackerEntry tracker = new EntityTrackerEntry(world.getHandle(), nmsEntity, 1, true, (EntityTrackerEntry.a)new FakeEntitySynchronizer(conn), Set.of(conn));
        tracker.b(nmsPlayer);
        TrackerData data = new TrackerData(player, tracker);
        trackers.add(data);
        if (autoTrack) {
            new BukkitRunnable(){
                boolean wasOnline = true;

                public void run() {
                    if (!fake.entity.isFakeValid) {
                        this.cancel();
                        return;
                    }
                    if (player.isOnline()) {
                        if (!this.wasOnline) {
                            tracker.b(((CraftPlayer)player.getPlayerEntity()).getHandle());
                            this.wasOnline = true;
                        }
                        tracker.a();
                    } else if (this.wasOnline) {
                        this.wasOnline = false;
                    }
                }
            }.runTaskTimer((Plugin)Denizen.getInstance(), 1L, 1L);
        }
    }

    public record TrackerData(PlayerTag player, EntityTrackerEntry tracker) {
    }

    public record FakeEntitySynchronizer(PlayerConnection target) implements EntityTrackerEntry.a
    {
        public void a(Packet<? super PacketListenerPlayOut> packet) {
            this.target.b(packet);
        }

        public void b(Packet<? super PacketListenerPlayOut> packet) {
            this.a(packet);
        }

        public void a(Packet<? super PacketListenerPlayOut> packet, Predicate<EntityPlayer> predicate) {
            if (predicate.test(this.target.p())) {
                this.a(packet);
            }
        }

        public void sendToTrackingPlayersFilteredAndSelf(Packet<? super PacketListenerPlayOut> packet, Predicate<EntityPlayer> predicate) {
            this.a(packet, predicate);
        }
    }
}

