/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.impl;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.BiomeNMS;
import com.denizenscript.denizen.nms.v1_21.ReflectionMappingsInfo;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntityType;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftNamespacedKey;
import org.bukkit.entity.EntityType;

public class BiomeNMSImpl
extends BiomeNMS {
    public static final MethodHandle BIOME_CLIMATESETTINGS_CONSTRUCTOR = ReflectionHelper.getConstructor(dxo.b.class, (Class[])new Class[]{Boolean.TYPE, Float.TYPE, dxo.d.class, Float.TYPE});
    public static final MethodHandle MAPPED_REGISTRY_REGISTRATION_INFOS = ReflectionHelper.getFields(jl.class).getGetter(ReflectionMappingsInfo.MappedRegistry_registrationInfos);
    public static final MethodHandle BIOME_ATTRIBUTES_SETTER = ReflectionHelper.getFields(dxo.class).getSetter(ReflectionMappingsInfo.Biome_attributes);
    public jd.c<dxo> biomeHolder;
    public axf world;

    public BiomeNMSImpl(axf world, NamespacedKey key) {
        super((World)world.getWorld(), key);
        this.world = world;
        this.biomeHolder = this.getBiomeRegistry().a(amt.a((amt)mj.aS, (amo)CraftNamespacedKey.toMinecraft((NamespacedKey)key))).orElse(null);
    }

    private jl<dxo> getBiomeRegistry() {
        return (jl)this.world.J_().f(mj.aS);
    }

    public BiomeNMS.DownfallType getDownfallTypeAt(Location location) {
        dxo.c precipitation = ((dxo)this.biomeHolder.a()).a(CraftLocation.toBlockPosition((Location)location), this.world.V());
        return switch (precipitation) {
            default -> throw new IncompatibleClassChangeError();
            case dxo.c.b -> BiomeNMS.DownfallType.RAIN;
            case dxo.c.c -> BiomeNMS.DownfallType.SNOW;
            case dxo.c.a -> BiomeNMS.DownfallType.NONE;
        };
    }

    public float getHumidity() {
        return ((dxo)this.biomeHolder.a()).i.d();
    }

    public float getBaseTemperature() {
        return ((dxo)this.biomeHolder.a()).f();
    }

    public float getTemperatureAt(Location location) {
        return ((dxo)this.biomeHolder.a()).f(CraftLocation.toBlockPosition((Location)location), this.world.V());
    }

    public boolean hasDownfall() {
        return ((dxo)this.biomeHolder.a()).b();
    }

    public List<EntityType> getAmbientEntities() {
        return this.getSpawnableEntities(cho.c);
    }

    public List<EntityType> getCreatureEntities() {
        return this.getSpawnableEntities(cho.b);
    }

    public List<EntityType> getMonsterEntities() {
        return this.getSpawnableEntities(cho.a);
    }

    public List<EntityType> getWaterEntities() {
        return this.getSpawnableEntities(cho.f);
    }

    public int getFoliageColor() {
        if (((dxo)this.biomeHolder.a()).d() != 0) {
            return ((dxo)this.biomeHolder.a()).d();
        }
        float temperature = this.clampColor(this.getBaseTemperature());
        float humidity = this.clampColor(this.getHumidity());
        int temperatureValue = (int)((1.0f - temperature) * 255.0f);
        int humidityValue = (int)((1.0f - (humidity *= temperature)) * 255.0f);
        int index = temperatureValue << 8 | humidityValue;
        return index >= 65536 ? 4764952 : this.getColor(index / 256, index % 256).asRGB();
    }

    public void setClimate(boolean hasPrecipitation, float temperature, dxo.d temperatureModifier, float downfall) {
        try {
            Object newClimate = BIOME_CLIMATESETTINGS_CONSTRUCTOR.invoke(hasPrecipitation, temperature, temperatureModifier, downfall);
            ReflectionHelper.setFieldValue(dxo.class, (String)ReflectionMappingsInfo.Biome_climateSettings, (Object)this.biomeHolder.a(), (Object)newClimate);
            this.setNetworkedRegistrationInfo();
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void setHumidity(float humidity) {
        this.setClimate(this.hasDownfall(), this.getBaseTemperature(), this.getTemperatureModifier(), humidity);
    }

    public void setBaseTemperature(float baseTemperature) {
        this.setClimate(this.hasDownfall(), baseTemperature, this.getTemperatureModifier(), this.getHumidity());
    }

    public void setHasDownfall(boolean hasDownfall) {
        this.setClimate(hasDownfall, this.getBaseTemperature(), this.getTemperatureModifier(), this.getHumidity());
    }

    public void setFoliageColor(int color) {
        dxu nmsCurrEffects = ((dxo)this.biomeHolder.a()).h();
        dxu nmsNewEffects = new dxu(nmsCurrEffects.a(), Optional.of(color), nmsCurrEffects.c(), nmsCurrEffects.d(), nmsCurrEffects.e());
        ReflectionHelper.setFieldValue(dxo.class, (String)ReflectionMappingsInfo.Biome_specialEffects, (Object)this.biomeHolder.a(), (Object)nmsNewEffects);
        this.setNetworkedRegistrationInfo();
    }

    public int getFogColor() {
        return (Integer)this.getEnvironmentAttribute(ceg.a);
    }

    public void setFogColor(int color) {
        this.setEnvironmentAttribute(ceg.a, color);
    }

    public int getWaterFogColor() {
        return (Integer)this.getEnvironmentAttribute(ceg.f);
    }

    public void setWaterFogColor(int color) {
        this.setEnvironmentAttribute(ceg.f, color);
    }

    public <T> T getEnvironmentAttribute(cea<T> attribute) {
        return (T)((dxo)this.biomeHolder.a()).g().a(attribute, attribute.b());
    }

    public <T> void setEnvironmentAttribute(cea<T> attribute, T value) {
        dxo nmsBiome = (dxo)this.biomeHolder.a();
        cec newAttributeMap = cec.a().a(nmsBiome.g()).a(attribute, value).a();
        try {
            BIOME_ATTRIBUTES_SETTER.invokeExact(nmsBiome, newAttributeMap);
        }
        catch (Throwable e2) {
            Debug.echoError((Throwable)e2);
        }
        this.setNetworkedRegistrationInfo();
    }

    private List<EntityType> getSpawnableEntities(cho creatureType) {
        dya mobs = ((dxo)this.biomeHolder.a()).a();
        cbn typeSettingList = mobs.a(creatureType);
        ArrayList<EntityType> entityTypes = new ArrayList<EntityType>();
        if (typeSettingList == null) {
            return entityTypes;
        }
        for (cbm meta : typeSettingList.d()) {
            entityTypes.add(CraftEntityType.minecraftToBukkit((cgu)((dya.c)meta.a()).a()));
        }
        return entityTypes;
    }

    public void setTo(Block block) {
        eqq chunk;
        if (((CraftWorld)block.getWorld()).getHandle() != this.world) {
            NMSHandler.instance.getBiomeNMS(block.getWorld(), this.getKey()).setTo(block);
            return;
        }
        is pos = new is(block.getX(), 0, block.getZ());
        if (this.world.H(pos) && (chunk = this.world.q(pos)) != null) {
            chunk.setBiome(block.getX() >> 2, block.getY() >> 2, block.getZ() >> 2, this.biomeHolder);
            chunk.i();
        }
    }

    public dxo.d getTemperatureModifier() {
        return ((dxo)this.biomeHolder.a()).i.c();
    }

    private void setNetworkedRegistrationInfo() {
        try {
            Map registrationInfos = MAPPED_REGISTRY_REGISTRATION_INFOS.invokeExact(this.getBiomeRegistry());
            registrationInfos.put(this.biomeHolder.h(), jp.a);
        }
        catch (Throwable e2) {
            Debug.echoError((String)"Failed to set biome registration info, changes may not be synced correctly.");
            Debug.echoError((Throwable)e2);
        }
    }
}

