/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.helpers;

import com.denizenscript.denizen.nms.interfaces.ItemHelper;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.v1_21.Handler;
import com.denizenscript.denizen.nms.v1_21.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_21.helpers.NBTAdapter;
import com.denizenscript.denizen.nms.v1_21.impl.ProfileEditorImpl;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.properties.item.ItemComponentsPatch;
import com.denizenscript.denizen.objects.properties.item.ItemRawNBT;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizen.utilities.PaperAPITools;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R7.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R7.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntityType;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftBlastingRecipe;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftCampfireRecipe;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftFurnaceRecipe;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftInventoryPlayer;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftShapedRecipe;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftShapelessRecipe;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftSmithingTransformRecipe;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftSmithingTrimRecipe;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftSmokingRecipe;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftStonecuttingRecipe;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftTransmuteRecipe;
import org.bukkit.craftbukkit.v1_21_R7.map.CraftMapView;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftNamespacedKey;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.BlastingRecipe;
import org.bukkit.inventory.CampfireRecipe;
import org.bukkit.inventory.ComplexRecipe;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.SmithingTransformRecipe;
import org.bukkit.inventory.SmithingTrimRecipe;
import org.bukkit.inventory.SmokingRecipe;
import org.bukkit.inventory.StonecuttingRecipe;
import org.bukkit.inventory.TransmuteRecipe;
import org.bukkit.map.MapView;

public class ItemHelperImpl
extends ItemHelper {
    public static final Field Item_components = ReflectionHelper.getFields(dlp.class).get(ReflectionMappingsInfo.Item_components, kf.class);
    public static final Field RecipeManager_featureFlagSet = ReflectionHelper.getFields(dqz.class).getFirstOfType(dgz.class);
    public Object recipeManagerFeatureFlagSetCache = null;
    public static final int DATA_VERSION_1_20_4 = 3700;
    public static final Field AdventureModePredicate_predicates = ReflectionHelper.getFields(dju.class).get(ReflectionMappingsInfo.AdventureModePredicate_predicates);
    public static Class<?> PaperPotionMix_CLASS = null;
    public static Map<NamespacedKey, ItemHelper.BrewingRecipe> customBrewingRecipes = null;

    public static dqx<?> getNMSRecipe(NamespacedKey key) {
        amt nmsKey = amt.a((amt)mj.bK, (amo)CraftNamespacedKey.toMinecraft((NamespacedKey)key));
        return ((CraftServer)Bukkit.getServer()).getServer().aJ().b(nmsKey).orElse(null);
    }

    public void setMaxStackSize(Material material, int size) {
        try {
            ReflectionHelper.getFinalSetter(Material.class, (String)"maxStack").invoke(material, size);
            dlp nmsItem = (dlp)mi.h.a(CraftNamespacedKey.toMinecraft((NamespacedKey)material.getKey()));
            kf currentComponents = nmsItem.f();
            Item_components.set(nmsItem, kf.a((kf)currentComponents, (kf)kf.a().a(ki.c, (Object)size).a()));
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public static dqz getRecipeManager() {
        return ((CraftServer)Bukkit.getServer()).getServer().aJ();
    }

    public static uz serializeNmsItem(dlt nmsItem) {
        return (uz)dlt.b.encodeStart((DynamicOps)CraftRegistry.getMinecraftRegistry().a((DynamicOps)vn.a), (Object)nmsItem).getOrThrow();
    }

    public static dlt parseNmsItem(uz nmsTag) {
        return (dlt)dlt.b.parse((DynamicOps)CraftRegistry.getMinecraftRegistry().a((DynamicOps)vn.a), (Object)nmsTag).getOrThrow();
    }

    public void blockRecipeFinalization() {
        try {
            dqz manager = ItemHelperImpl.getRecipeManager();
            Object flags = RecipeManager_featureFlagSet.get(manager);
            if (flags != null) {
                this.recipeManagerFeatureFlagSetCache = flags;
                RecipeManager_featureFlagSet.set(manager, null);
            }
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void restoreRecipeFinalization() {
        try {
            dqz manager = ItemHelperImpl.getRecipeManager();
            if (this.recipeManagerFeatureFlagSetCache != null) {
                RecipeManager_featureFlagSet.set(manager, this.recipeManagerFeatureFlagSetCache);
                manager.finalizeRecipeLoading();
            }
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void removeRecipes(List<NamespacedKey> keys) {
        this.blockRecipeFinalization();
        dqz manager = ItemHelperImpl.getRecipeManager();
        for (NamespacedKey key : keys) {
            amt nmsKey = amt.a((amt)mj.bK, (amo)CraftNamespacedKey.toMinecraft((NamespacedKey)key));
            manager.removeRecipe(nmsKey);
        }
        this.restoreRecipeFinalization();
    }

    public Integer burnTime(Material material) {
        return MinecraftServer.getServer().bs().b(new dlt((dwn)CraftMagicNumbers.getItem((Material)material)));
    }

    public void setShapedRecipeIngredient(ShapedRecipe recipe, char c2, ItemStack[] item, boolean exact) {
        if (item.length == 1 && item[0].getType() == Material.AIR) {
            recipe.setIngredient(c2, (RecipeChoice)new RecipeChoice.MaterialChoice(Material.AIR));
        } else if (exact) {
            recipe.setIngredient(c2, (RecipeChoice)new RecipeChoice.ExactChoice(item));
        } else {
            Material[] mats = new Material[item.length];
            for (int i = 0; i < item.length; ++i) {
                mats[i] = item[i].getType();
            }
            recipe.setIngredient(c2, (RecipeChoice)new RecipeChoice.MaterialChoice(mats));
        }
    }

    public static dqo itemArrayToRecipe(ItemStack[] items, boolean exact) {
        if (!exact) {
            return dqo.a(Arrays.stream(items).map(item -> CraftMagicNumbers.getItem((Material)item.getType())));
        }
        return dqo.ofStacks(Arrays.stream(items).map(CraftItemStack::asNMSCopy).toList());
    }

    public static amt<dqs<?>> createRecipeKey(String name) {
        return amt.a((amt)mj.bK, (amo)amo.a((String)"denizen", (String)name));
    }

    public void registerFurnaceRecipe(String keyName, String group, ItemStack result, ItemStack[] ingredient, float exp, int time, String type, boolean exact, String category) {
        dqe categoryValue;
        amt<dqs<?>> key = ItemHelperImpl.createRecipeKey(keyName);
        dqo itemRecipe = ItemHelperImpl.itemArrayToRecipe(ingredient, exact);
        dqe dqe2 = categoryValue = category == null ? dqe.c : dqe.valueOf((String)CoreUtilities.toUpperCase((String)category));
        Object recipe = type.equalsIgnoreCase("smoker") ? new drr(group, categoryValue, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time) : (type.equalsIgnoreCase("blast") ? new dqb(group, categoryValue, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time) : (type.equalsIgnoreCase("campfire") ? new dqd(group, categoryValue, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time) : new drm(group, categoryValue, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time)));
        dqx holder = new dqx(key, (dqs)recipe);
        ItemHelperImpl.getRecipeManager().addRecipe(holder);
    }

    public void registerStonecuttingRecipe(String keyName, String group, ItemStack result, ItemStack[] ingredient, boolean exact) {
        amt<dqs<?>> key = ItemHelperImpl.createRecipeKey(keyName);
        dqo itemRecipe = ItemHelperImpl.itemArrayToRecipe(ingredient, exact);
        drs recipe = new drs(group, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result));
        dqx holder = new dqx(key, (dqs)recipe);
        ItemHelperImpl.getRecipeManager().addRecipe(holder);
    }

    public void registerSmithingRecipe(String keyName, ItemStack result, ItemStack[] baseItem, boolean baseExact, ItemStack[] upgradeItem, boolean upgradeExact, ItemStack[] templateItem, boolean templateExact) {
        amt<dqs<?>> key = ItemHelperImpl.createRecipeKey(keyName);
        dqo templateItemRecipe = ItemHelperImpl.itemArrayToRecipe(templateItem, templateExact);
        dqo baseItemRecipe = ItemHelperImpl.itemArrayToRecipe(baseItem, baseExact);
        dqo upgradeItemRecipe = ItemHelperImpl.itemArrayToRecipe(upgradeItem, upgradeExact);
    }

    public void registerShapelessRecipe(String keyName, String group, ItemStack result, List<ItemStack[]> ingredients, boolean[] exact, String category) {
        amt<dqs<?>> key = ItemHelperImpl.createRecipeKey(keyName);
        ArrayList<dqo> ingredientList = new ArrayList<dqo>();
        dqf categoryValue = category == null ? dqf.d : dqf.valueOf((String)CoreUtilities.toUpperCase((String)category));
        for (int i = 0; i < ingredients.size(); ++i) {
            ingredientList.add(ItemHelperImpl.itemArrayToRecipe(ingredients.get(i), exact[i]));
        }
        dri recipe = new dri(group, categoryValue, CraftItemStack.asNMSCopy((ItemStack)result), (List)jm.a(null, (Object[])ingredientList.toArray(new dqo[0])));
        dqx holder = new dqx(key, (dqs)recipe);
        ItemHelperImpl.getRecipeManager().addRecipe(holder);
    }

    public void registerOtherRecipe(Recipe recipe) {
        CraftRecipe toAdd;
        if (recipe instanceof CraftRecipe) {
            CraftRecipe craft;
            toAdd = craft = (CraftRecipe)recipe;
        } else if (recipe instanceof ShapedRecipe) {
            toAdd = CraftShapedRecipe.fromBukkitRecipe((ShapedRecipe)((ShapedRecipe)recipe));
        } else if (recipe instanceof ShapelessRecipe) {
            toAdd = CraftShapelessRecipe.fromBukkitRecipe((ShapelessRecipe)((ShapelessRecipe)recipe));
        } else if (recipe instanceof FurnaceRecipe) {
            toAdd = CraftFurnaceRecipe.fromBukkitRecipe((FurnaceRecipe)((FurnaceRecipe)recipe));
        } else if (recipe instanceof BlastingRecipe) {
            toAdd = CraftBlastingRecipe.fromBukkitRecipe((BlastingRecipe)((BlastingRecipe)recipe));
        } else if (recipe instanceof CampfireRecipe) {
            toAdd = CraftCampfireRecipe.fromBukkitRecipe((CampfireRecipe)((CampfireRecipe)recipe));
        } else if (recipe instanceof SmokingRecipe) {
            toAdd = CraftSmokingRecipe.fromBukkitRecipe((SmokingRecipe)((SmokingRecipe)recipe));
        } else if (recipe instanceof StonecuttingRecipe) {
            toAdd = CraftStonecuttingRecipe.fromBukkitRecipe((StonecuttingRecipe)((StonecuttingRecipe)recipe));
        } else if (recipe instanceof SmithingTransformRecipe) {
            toAdd = CraftSmithingTransformRecipe.fromBukkitRecipe((SmithingTransformRecipe)((SmithingTransformRecipe)recipe));
        } else if (recipe instanceof SmithingTrimRecipe) {
            toAdd = CraftSmithingTrimRecipe.fromBukkitRecipe((SmithingTrimRecipe)((SmithingTrimRecipe)recipe));
        } else {
            if (!(recipe instanceof TransmuteRecipe)) {
                if (recipe instanceof ComplexRecipe) {
                    throw new UnsupportedOperationException("Cannot add custom complex recipe");
                }
                return;
            }
            toAdd = CraftTransmuteRecipe.fromBukkitRecipe((TransmuteRecipe)((TransmuteRecipe)recipe));
        }
        toAdd.addToCraftingManager();
    }

    public String getJsonString(ItemStack itemStack) {
        String json = CraftItemStack.asNMSCopy((ItemStack)itemStack).K().a().toString().replace("\\", "\\\\").replace("\"", "\\\"");
        return json.substring(176, json.length() - 185);
    }

    public JsonObject getRawHoverComponentsJson(ItemStack item) {
        kg nmsComponents = CraftItemStack.asNMSCopy((ItemStack)item).d();
        if (nmsComponents.d()) {
            return null;
        }
        return ((JsonElement)kg.b.encodeStart((DynamicOps)CraftRegistry.getMinecraftRegistry().a((DynamicOps)JsonOps.INSTANCE), (Object)nmsComponents).getOrThrow()).getAsJsonObject();
    }

    public ItemStack applyRawHoverComponentsJson(ItemStack item, JsonObject components) {
        return (ItemStack)kg.b.parse((DynamicOps)CraftRegistry.getMinecraftRegistry().a((DynamicOps)JsonOps.INSTANCE), (Object)components).mapOrElse(nmsComponents -> {
            dlt nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
            nmsItem.b(nmsComponents);
            return CraftItemStack.asCraftMirror((dlt)nmsItem);
        }, error -> {
            Debug.echoError((String)("Invalid hover item data '" + String.valueOf(components) + "': " + error.message()));
            return item;
        });
    }

    public PlayerProfile getSkullSkin(ItemStack is2) {
        dlt itemStack = CraftItemStack.asNMSCopy((ItemStack)is2);
        doy profile = (doy)itemStack.a(ki.ar);
        if (profile != null) {
            Property property = (Property)Iterables.getFirst((Iterable)profile.b().properties().get((Object)"textures"), null);
            return new PlayerProfile((String)profile.d().orElse(null), ProfileEditorImpl.getUUID(profile), property != null ? property.value() : null, property != null ? property.signature() : null);
        }
        return null;
    }

    public ItemStack setSkullSkin(ItemStack itemStack, PlayerProfile playerProfile) {
        GameProfile gameProfile = ProfileEditorImpl.getGameProfile(playerProfile);
        dlt nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        nmsItemStack.b(ki.ar, (Object)doy.a((GameProfile)gameProfile));
        return CraftItemStack.asBukkitCopy((dlt)nmsItemStack);
    }

    public ItemStack addNbtData(ItemStack itemStack, String key, BinaryTag value) {
        dlt nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        nmsItemStack.a(ki.b, (Object)doe.a, customData -> customData.a(nmsCompoundTag -> nmsCompoundTag.a(key, NBTAdapter.toNMS(value))));
        return CraftItemStack.asBukkitCopy((dlt)nmsItemStack);
    }

    public CompoundBinaryTag getNbtData(ItemStack itemStack) {
        dlt nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        if (nmsItemStack != null && !nmsItemStack.f()) {
            return NBTAdapter.toAPI(ItemHelperImpl.serializeNmsItem(nmsItemStack));
        }
        return CompoundBinaryTag.empty();
    }

    public ItemStack setNbtData(ItemStack itemStack, CompoundBinaryTag compoundTag) {
        return CraftItemStack.asBukkitCopy((dlt)ItemHelperImpl.parseNmsItem(NBTAdapter.toNMS(compoundTag)));
    }

    public CompoundBinaryTag getCustomData(ItemStack item) {
        doe customData = (doe)CraftItemStack.asNMSCopy((ItemStack)item).a(ki.b);
        return customData != null ? NBTAdapter.toAPI(customData.b()) : null;
    }

    public ItemStack setCustomData(ItemStack item, CompoundBinaryTag data) {
        dlt nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        if (data == null) {
            nmsItemStack.e(ki.b);
        } else {
            nmsItemStack.b(ki.b, (Object)doe.a((uz)NBTAdapter.toNMS(data)));
        }
        return CraftItemStack.asBukkitCopy((dlt)nmsItemStack);
    }

    public ItemStack setPartialOldNbt(ItemStack item, CompoundBinaryTag oldTag) {
        int currentDataVersion = CraftMagicNumbers.INSTANCE.getDataVersion();
        uz nmsOldTag = new uz();
        nmsOldTag.a("id", item.getType().getKey().toString());
        nmsOldTag.a("Count", (byte)item.getAmount());
        nmsOldTag.a("tag", (vz)NBTAdapter.toNMS(oldTag));
        uz nmsUpdatedTag = (uz)MinecraftServer.getServer().M.update(bqh.x, new Dynamic((DynamicOps)vn.a, (Object)nmsOldTag), 3700, currentDataVersion).getValue();
        uz nmsCurrentTag = ItemHelperImpl.serializeNmsItem(CraftItemStack.asNMSCopy((ItemStack)item));
        uz nmsMergedTag = nmsCurrentTag.a(nmsUpdatedTag);
        return CraftItemStack.asBukkitCopy((dlt)ItemHelperImpl.parseNmsItem(nmsMergedTag));
    }

    public CompoundBinaryTag getEntityData(ItemStack item) {
        dpf entityData = (dpf)CraftItemStack.asNMSCopy((ItemStack)item).a(ki.af);
        return entityData != null ? NBTAdapter.toAPI(entityData.b()) : null;
    }

    public ItemStack setEntityData(ItemStack item, CompoundBinaryTag entityNbt, EntityType entityType) {
        dlt nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        if (entityNbt == null || entityNbt.isEmpty() || entityNbt.size() == 1 && entityNbt.contains("id")) {
            nmsItemStack.e(ki.af);
        } else {
            uz nmsEntityNbt = NBTAdapter.toNMS(entityNbt);
            nmsEntityNbt.r("id");
            nmsItemStack.b(ki.af, (Object)dpf.a((Object)CraftEntityType.bukkitToMinecraft((EntityType)entityType), (uz)nmsEntityNbt));
        }
        return CraftItemStack.asBukkitCopy((dlt)nmsItemStack);
    }

    public MapTag getRawComponentsPatch(ItemStack item, boolean excludeHandled) {
        dlt nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        kg patch = nmsItemStack.d();
        if (excludeHandled) {
            patch = patch.a(componentType -> {
                amo componentId = mi.am.b(componentType);
                return ItemComponentsPatch.propertyHandledComponents.contains(componentId.toString());
            });
        }
        if (patch.d()) {
            return new MapTag();
        }
        ams registryOps = CraftRegistry.getMinecraftRegistry().a((DynamicOps)vn.a);
        uz nmsPatch = (uz)kg.b.encodeStart((DynamicOps)registryOps, (Object)patch).getOrThrow();
        MapTag rawComponents = (MapTag)ItemRawNBT.nbtTagToObject((BinaryTag)NBTAdapter.toAPI(nmsPatch));
        rawComponents.putObject("denizen:__data_version", (ObjectTag)new ElementTag(CraftMagicNumbers.INSTANCE.getDataVersion()));
        return rawComponents;
    }

    public ItemStack setRawComponentsPatch(ItemStack item, MapTag rawComponentsMap, int dataVersion, Consumer<String> errorHandler) {
        int currentDataVersion = CraftMagicNumbers.INSTANCE.getDataVersion();
        CompoundBinaryTag rawComponents = (CompoundBinaryTag)ItemRawNBT.convertObjectToNbt((ObjectTag)rawComponentsMap, (TagContext)CoreUtilities.errorButNoDebugContext, (String)"");
        uz nmsRawComponents = NBTAdapter.toNMS(rawComponents);
        ams registryOps = CraftRegistry.getMinecraftRegistry().a((DynamicOps)vn.a);
        if (dataVersion < currentDataVersion) {
            uz legacyItemData = new uz();
            legacyItemData.a("id", item.getType().getKey().toString());
            legacyItemData.a("count", item.getAmount());
            legacyItemData.a("components", (vz)nmsRawComponents);
            uz nmsUpdatedTag = (uz)MinecraftServer.getServer().M.update(bqh.x, new Dynamic((DynamicOps)registryOps, (Object)legacyItemData), dataVersion, currentDataVersion).getValue();
            nmsRawComponents = nmsUpdatedTag.m("components").orElseGet(uz::new);
        }
        dlt nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        kg.b.parse((DynamicOps)registryOps, (Object)nmsRawComponents).ifError(error -> errorHandler.accept(error.message())).ifSuccess(arg_0 -> ((dlt)nmsItemStack).b(arg_0));
        return CraftItemStack.asBukkitCopy((dlt)nmsItemStack);
    }

    public List<Material> getCanPlaceOn(ItemStack item) {
        return this.getAdventureModePredicateMaterials(item, (kh<dju>)ki.p);
    }

    public ItemStack setCanPlaceOn(ItemStack item, List<Material> canPlaceOn) {
        return this.setAdventureModePredicateMaterials(item, (kh<dju>)ki.p, canPlaceOn);
    }

    public List<Material> getCanBreak(ItemStack item) {
        return this.getAdventureModePredicateMaterials(item, (kh<dju>)ki.q);
    }

    public ItemStack setCanBreak(ItemStack item, List<Material> canBreak) {
        return this.setAdventureModePredicateMaterials(item, (kh<dju>)ki.q, canBreak);
    }

    private List<Material> getAdventureModePredicateMaterials(ItemStack item, kh<dju> nmsComponent) {
        List nmsPredicates;
        dju nmsAdventurePredicate = (dju)CraftItemStack.asNMSCopy((ItemStack)item).a(nmsComponent);
        if (nmsAdventurePredicate == null) {
            return null;
        }
        try {
            nmsPredicates = (List)AdventureModePredicate_predicates.get(nmsAdventurePredicate);
        }
        catch (Throwable e2) {
            Debug.echoError((Throwable)e2);
            return null;
        }
        ArrayList<Material> materials = new ArrayList<Material>();
        for (as nmsPredicate : nmsPredicates) {
            nmsPredicate.b().ifPresent(nmsHolderSet -> {
                for (jd nmsHolder : nmsHolderSet) {
                    materials.add(CraftMagicNumbers.getMaterial((dzq)((dzq)nmsHolder.a())));
                }
            });
        }
        return materials;
    }

    private ItemStack setAdventureModePredicateMaterials(ItemStack item, kh<dju> nmsComponent, List<Material> materials) {
        dlt nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        dju nmsAdventurePredicate = (dju)nmsItemStack.a(nmsComponent);
        if (materials == null) {
            if (nmsAdventurePredicate == null) {
                return item;
            }
            nmsItemStack.e(nmsComponent);
            return CraftItemStack.asBukkitCopy((dlt)nmsItemStack);
        }
        as nmsPredicate = new as(Optional.of(jh.a(material -> (jd)mi.e.c(CraftNamespacedKey.toMinecraft((NamespacedKey)material.getKey())).orElseThrow(), materials)), Optional.empty(), Optional.empty(), bh.a);
        nmsItemStack.b(nmsComponent, (Object)new dju(List.of(nmsPredicate)));
        return CraftItemStack.asBukkitCopy((dlt)nmsItemStack);
    }

    public void setInventoryItem(Inventory inventory, ItemStack item, int slot) {
        if (inventory instanceof CraftInventoryPlayer && ((CraftInventoryPlayer)inventory).getInventory().j == null) {
            ((CraftInventoryPlayer)inventory).getInventory().a(slot, CraftItemStack.asNMSCopy((ItemStack)item));
        } else {
            inventory.setItem(slot, item);
        }
    }

    public String getDisplayName(ItemTag item) {
        if (!item.getItemMeta().hasDisplayName()) {
            return null;
        }
        dlt nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        yh nmsDisplayName = (yh)nmsItemStack.a(ki.h);
        return FormattedTextHelper.stringify((BaseComponent[])Handler.componentToSpigot(nmsDisplayName));
    }

    public List<String> getLore(ItemTag item) {
        if (!item.getItemMeta().hasLore()) {
            return null;
        }
        dlt nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        dop nmsLore = (dop)nmsItemStack.a(ki.m);
        ArrayList<String> outList = new ArrayList<String>(nmsLore.a().size());
        for (yh nmsLoreLine : nmsLore.a()) {
            outList.add(FormattedTextHelper.stringify((BaseComponent[])Handler.componentToSpigot(nmsLoreLine)));
        }
        return outList;
    }

    public void setDisplayName(ItemTag item, String name) {
        dlt nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        if (name == null || name.isEmpty()) {
            nmsItemStack.e(ki.h);
        } else {
            nmsItemStack.b(ki.h, (Object)Handler.componentToNMS(FormattedTextHelper.parse((String)name, (ChatColor)ChatColor.WHITE)));
        }
        item.setItemStack(CraftItemStack.asBukkitCopy((dlt)nmsItemStack));
    }

    public void setLore(ItemTag item, List<String> lore) {
        dlt nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        if (lore == null || lore.isEmpty()) {
            nmsItemStack.e(ki.m);
        } else {
            ArrayList<yh> nmsLore = new ArrayList<yh>(lore.size());
            for (String loreLine : lore) {
                nmsLore.add(Handler.componentToNMS(FormattedTextHelper.parse((String)loreLine, (ChatColor)ChatColor.WHITE)));
            }
            nmsItemStack.b(ki.m, (Object)new dop(nmsLore));
        }
        item.setItemStack(CraftItemStack.asBukkitCopy((dlt)nmsItemStack));
    }

    public static eoh getCorrectStateForFluidBlock(dwo world, eoh blockState, is blockPos) {
        flb fluid = blockState.y();
        return !fluid.c() && !blockState.c((dvt)world, blockPos, iz.b) ? fluid.g() : blockState;
    }

    public static void renderFullMap(fmw worldmap, int xMin, int zMin, int xMax, int zMax) {
        axf world = ((CraftWorld)worldmap.mapView.getWorld()).getHandle();
        int scale = 1 << worldmap.g;
        int mapX = worldmap.d;
        int mapZ = worldmap.e;
        for (int x = xMin; x < xMax; ++x) {
            double d0 = 0.0;
            for (int z = zMin; z < zMax; ++z) {
                flf materialmapcolor;
                int k2 = (mapX / scale + x - 64) * scale;
                int l2 = (mapZ / scale + z - 64) * scale;
                LinkedHashMultiset multiset = LinkedHashMultiset.create();
                eqq chunk = world.q(new is(k2, 0, l2));
                if (chunk.F()) continue;
                dvu chunkcoordintpair = chunk.f();
                int i3 = k2 & 0xF;
                int j3 = l2 & 0xF;
                int k3 = 0;
                double d1 = 0.0;
                if (world.F_().f()) {
                    int l3 = k2 + l2 * 231871;
                    if (((l3 = l3 * l3 * 31287121 + l3 * 11) >> 20 & 1) == 0) {
                        multiset.add((Object)dzs.j.m().a((dvt)world, is.c), 10);
                    } else {
                        multiset.add((Object)dzs.b.m().a((dvt)world, is.c), 100);
                    }
                    d1 = 100.0;
                } else {
                    is.a blockposition_mutableblockposition = new is.a();
                    is.a blockposition_mutableblockposition1 = new is.a();
                    for (int i4 = 0; i4 < scale; ++i4) {
                        for (int j4 = 0; j4 < scale; ++j4) {
                            eoh iblockdata;
                            int k4 = chunk.a(euq.a.b, i4 + i3, j4 + j3) + 1;
                            if (k4 <= world.K_() + 1) {
                                iblockdata = dzs.I.m();
                            } else {
                                do {
                                    blockposition_mutableblockposition.d(chunkcoordintpair.e() + i4 + i3, --k4, chunkcoordintpair.f() + j4 + j3);
                                } while ((iblockdata = chunk.a_((is)blockposition_mutableblockposition)).a((dvt)world, (is)blockposition_mutableblockposition) == flf.a && k4 > world.K_());
                                if (k4 > world.K_() && !iblockdata.y().c()) {
                                    eoh iblockdata1;
                                    int l4 = k4 - 1;
                                    blockposition_mutableblockposition1.g((jy)blockposition_mutableblockposition);
                                    do {
                                        blockposition_mutableblockposition1.q(l4--);
                                        iblockdata1 = chunk.a_((is)blockposition_mutableblockposition1);
                                        ++k3;
                                    } while (l4 > world.K_() && !iblockdata1.y().c());
                                    iblockdata = ItemHelperImpl.getCorrectStateForFluidBlock((dwo)world, iblockdata, (is)blockposition_mutableblockposition);
                                }
                            }
                            worldmap.a((dvt)world, chunkcoordintpair.e() + i4 + i3, chunkcoordintpair.f() + j4 + j3);
                            d1 += (double)k4 / (double)(scale * scale);
                            multiset.add((Object)iblockdata.a((dvt)world, (is)blockposition_mutableblockposition));
                        }
                    }
                }
                k3 /= scale * scale;
                double d2 = (d1 - d0) * 4.0 / (double)(scale + 4) + ((double)(x + z & 1) - 0.5) * 0.4;
                int b0 = 1;
                if (d2 > 0.6) {
                    b0 = 2;
                }
                if (d2 < -0.6) {
                    b0 = 0;
                }
                if ((materialmapcolor = (flf)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)multiset), (Object)flf.a)) == flf.m) {
                    d2 = (double)k3 * 0.1 + (double)(x + z & 1) * 0.2;
                    b0 = 1;
                    if (d2 < 0.5) {
                        b0 = 2;
                    }
                    if (d2 > 0.9) {
                        b0 = 0;
                    }
                }
                d0 = d1;
                worldmap.a(x, z, (byte)(materialmapcolor.al * 4 + b0));
            }
        }
    }

    public boolean renderEntireMap(int mapId, int xMin, int zMin, int xMax, int zMax) {
        fmw worldmap = ((CraftServer)Bukkit.getServer()).getServer().a(dwo.h).a(new fmu(mapId));
        if (worldmap == null) {
            return false;
        }
        ItemHelperImpl.renderFullMap(worldmap, xMin, zMin, xMax, zMax);
        return true;
    }

    public BlockData getPlacedBlock(Material material) {
        dlp nmsItem = mi.h.b(CraftNamespacedKey.toMinecraft((NamespacedKey)material.getKey())).orElse(null);
        if (nmsItem instanceof dkb) {
            dzq block = ((dkb)nmsItem).c();
            return CraftBlockData.fromData((eoh)block.m());
        }
        return null;
    }

    public boolean isValidMix(ItemStack input, ItemStack ingredient) {
        dlt nmsInput = CraftItemStack.asNMSCopy((ItemStack)input);
        dlt nmsIngredient = CraftItemStack.asNMSCopy((ItemStack)ingredient);
        return MinecraftServer.getServer().br().a(nmsInput, nmsIngredient);
    }

    public Map<NamespacedKey, ItemHelper.BrewingRecipe> getCustomBrewingRecipes() {
        if (customBrewingRecipes == null) {
            customBrewingRecipes = Maps.transformValues((Map)((Map)ReflectionHelper.getFieldValue(dnq.class, (String)"customMixes", (Object)MinecraftServer.getServer().br())), paperMix -> {
                if (PaperPotionMix_CLASS == null) {
                    PaperPotionMix_CLASS = paperMix.getClass();
                }
                RecipeChoice ingredient = this.convertChoice((Predicate)ReflectionHelper.getFieldValue(PaperPotionMix_CLASS, (String)"ingredient", (Object)paperMix));
                RecipeChoice input = this.convertChoice((Predicate)ReflectionHelper.getFieldValue(PaperPotionMix_CLASS, (String)"input", (Object)paperMix));
                ItemStack result = CraftItemStack.asBukkitCopy((dlt)((dlt)ReflectionHelper.getFieldValue(PaperPotionMix_CLASS, (String)"result", (Object)paperMix)));
                return new ItemHelper.BrewingRecipe(input, ingredient, result);
            });
        }
        return customBrewingRecipes;
    }

    private RecipeChoice convertChoice(Predicate<dlt> nmsPredicate) {
        if (nmsPredicate instanceof dqo) {
            dqo ingredient = (dqo)nmsPredicate;
            return CraftRecipe.toBukkit((dqo)ingredient);
        }
        return PaperAPITools.instance.createPredicateRecipeChoice(item -> nmsPredicate.test(CraftItemStack.asNMSCopy((ItemStack)item)));
    }

    public byte[] renderMap(MapView mapView, Player player) {
        return ((CraftMapView)mapView).render((CraftPlayer)((CraftPlayer)player)).buffer;
    }

    public int getFoodPoints(Material itemType) {
        return ((dhf)CraftMagicNumbers.getItem((Material)itemType).f().a(ki.y)).a();
    }
}

