/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.helpers;

import com.denizenscript.denizen.nms.interfaces.BlockHelper;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.v1_21.Handler;
import com.denizenscript.denizen.nms.v1_21.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_21.helpers.NBTAdapter;
import com.denizenscript.denizen.nms.v1_21.impl.ProfileEditorImpl;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.Optional;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Skull;
import org.bukkit.craftbukkit.v1_21_R7.CraftChunk;
import org.bukkit.craftbukkit.v1_21_R7.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftSkull;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftMagicNumbers;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;

public class BlockHelperImpl
implements BlockHelper {
    public static final Field craftBlockEntityState_tileEntity;
    public static final Field craftBlockEntityState_snapshot;
    public static final Field craftSkull_profile;
    public static final MethodHandle MATERIAL_PUSH_REACTION_SETTER;
    public static final MethodHandle BLOCK_STRENGTH_SETTER;

    public void applyPhysics(Location location) {
        ((CraftWorld)location.getWorld()).getHandle().a(CraftLocation.toBlockPosition((Location)location), CraftMagicNumbers.getBlock((Material)location.getBlock().getType()));
    }

    public static <T extends elb> T getTE(CraftBlockEntityState<T> cbs) {
        try {
            return (T)((elb)craftBlockEntityState_tileEntity.get(cbs));
        }
        catch (IllegalAccessException e2) {
            Debug.echoError((Throwable)e2);
            return null;
        }
    }

    public PlayerProfile getPlayerProfile(Skull skull) {
        doy profile = ((emu)BlockHelperImpl.getTE((CraftSkull)skull)).d;
        if (profile == null) {
            return null;
        }
        Property property = (Property)Iterables.getFirst((Iterable)profile.b().properties().get((Object)"textures"), null);
        return new PlayerProfile((String)profile.d().orElse(null), ProfileEditorImpl.getUUID(profile), property != null ? property.value() : null);
    }

    public void setPlayerProfile(Skull skull, PlayerProfile playerProfile) {
        GameProfile gameProfile = ProfileEditorImpl.getGameProfile(playerProfile);
        try {
            craftSkull_profile.set(skull, doy.a((GameProfile)gameProfile));
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
        skull.update();
    }

    public elb getBlockEntity(Block block) {
        CraftBlock craftBlock = (CraftBlock)block;
        return craftBlock.getHandle().c_(craftBlock.getPosition());
    }

    public CompoundBinaryTag getNbtData(Block block) {
        elb nmsBlockEntity = this.getBlockEntity(block);
        if (nmsBlockEntity != null) {
            uz compound = nmsBlockEntity.b((jf.a)CraftRegistry.getMinecraftRegistry());
            return NBTAdapter.toAPI(compound);
        }
        return null;
    }

    public void setNbtData(Block block, CompoundBinaryTag ctag) {
        uz nmsData = NBTAdapter.toNMS(ctag);
        nmsData.a("x", block.getX());
        nmsData.a("y", block.getY());
        nmsData.a("z", block.getZ());
        Handler.useValueInput(nmsData, arg_0 -> ((elb)this.getBlockEntity(block)).b(arg_0));
    }

    public boolean setBlockResistance(Material material, float resistance) {
        dzq block = CraftMagicNumbers.getBlock((Material)material);
        if (block == null) {
            return false;
        }
        ReflectionHelper.setFieldValue(eog.class, (String)ReflectionMappingsInfo.BlockBehaviour_explosionResistance, (Object)block, (Object)Float.valueOf(resistance));
        return true;
    }

    public float getBlockResistance(Material material) {
        dzq block = CraftMagicNumbers.getBlock((Material)material);
        if (block == null) {
            return 0.0f;
        }
        return ((Float)ReflectionHelper.getFieldValue(eog.class, (String)ReflectionMappingsInfo.BlockBehaviour_explosionResistance, (Object)block)).floatValue();
    }

    public eoh getMaterialBlockState(Material bukkitMaterial) {
        dzq nmsBlock = CraftMagicNumbers.getBlock((Material)bukkitMaterial);
        return nmsBlock != null ? nmsBlock.m() : null;
    }

    public void setPushReaction(Material mat, BlockHelper.PistonPushReaction reaction) {
        try {
            MATERIAL_PUSH_REACTION_SETTER.invoke(this.getMaterialBlockState(mat), flg.values()[reaction.ordinal()]);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public float getBlockStrength(Material mat) {
        return this.getMaterialBlockState((Material)mat).p;
    }

    public void setBlockStrength(Material mat, float strength) {
        try {
            BLOCK_STRENGTH_SETTER.invoke(this.getMaterialBlockState(mat), strength);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void doRandomTick(Location location) {
        flb fluid;
        is pos = CraftLocation.toBlockPosition((Location)location);
        eqf nmsChunk = ((CraftChunk)location.getChunk()).getHandle(erj.n);
        eoh nmsBlock = nmsChunk.a_(pos);
        axf nmsWorld = ((CraftWorld)location.getWorld()).getHandle();
        if (nmsBlock.z()) {
            nmsBlock.b(nmsWorld, pos, nmsWorld.y);
        }
        if ((fluid = nmsBlock.y()).f()) {
            fluid.a((dwo)nmsWorld, pos, nmsWorld.y);
        }
    }

    public Instrument getInstrumentFor(Material mat) {
        return Instrument.values()[this.getMaterialBlockState(mat).E().ordinal()];
    }

    public int getExpDrop(Block block, ItemStack item) {
        dzq blockType = CraftMagicNumbers.getBlock((Material)block.getType());
        if (blockType == null) {
            return 0;
        }
        return blockType.getExpDrop(((CraftBlock)block).getNMS(), ((CraftBlock)block).getCraftWorld().getHandle(), ((CraftBlock)block).getPosition(), item == null ? null : CraftItemStack.asNMSCopy((ItemStack)item), true);
    }

    public void setSpawnerSpawnedType(CreatureSpawner spawner, EntityTag entity) {
        spawner.setSpawnedType(entity.getBukkitEntityType());
        if (entity.getWaitingMechanisms() == null || entity.getWaitingMechanisms().size() == 0) {
            return;
        }
        try {
            Entity bukkitEntity = ((CraftWorld)spawner.getWorld()).createEntity(spawner.getLocation(), entity.getBukkitEntityType().getEntityClass());
            cgk nmsEntity = ((CraftEntity)bukkitEntity).getHandle();
            EntityTag entityTag = new EntityTag(bukkitEntity);
            entityTag.isFake = true;
            entityTag.isFakeValid = true;
            for (Mechanism mechanism : entity.getWaitingMechanisms()) {
                entityTag.safeAdjustDuplicate(mechanism);
            }
            nmsEntity.ej();
            emw nmsSnapshot = (emw)craftBlockEntityState_snapshot.get(spawner);
            Handler.useValueOutput(nmsSnapshot.c().m.a(), arg_0 -> ((cgk)nmsEntity).d(arg_0));
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void setSpawnerCustomRules(CreatureSpawner spawner, int skyMin, int skyMax, int blockMin, int blockMax) {
        try {
            CraftCreatureSpawner bukkitSpawner = (CraftCreatureSpawner)spawner;
            emw nmsSnapshot = (emw)craftBlockEntityState_snapshot.get(bukkitSpawner);
            dvp nmsSpawner = nmsSnapshot.c();
            dxi toSpawn = nmsSpawner.m;
            dxi.a rules = skyMin == -1 ? null : new dxi.a(new bfz((Comparable)Integer.valueOf(skyMin), (Comparable)Integer.valueOf(skyMax)), new bfz((Comparable)Integer.valueOf(blockMin), (Comparable)Integer.valueOf(blockMax)));
            nmsSpawner.m = new dxi(toSpawn.d(), Optional.ofNullable(rules), toSpawn.f());
            nmsSpawner.l = cbn.a();
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    static {
        craftBlockEntityState_snapshot = ReflectionHelper.getFields(CraftBlockEntityState.class).get("snapshot");
        craftSkull_profile = ReflectionHelper.getFields(CraftSkull.class).get("profile");
        Field blockEntityField = ReflectionHelper.getFields(CraftBlockEntityState.class).getNoCheck("blockEntity");
        if (blockEntityField == null) {
            blockEntityField = ReflectionHelper.getFields(CraftBlockEntityState.class).get("tileEntity");
        }
        craftBlockEntityState_tileEntity = blockEntityField;
        MATERIAL_PUSH_REACTION_SETTER = ReflectionHelper.getFinalSetterForFirstOfType(eog.a.class, flg.class);
        BLOCK_STRENGTH_SETTER = ReflectionHelper.getFinalSetterForFirstOfType(eog.a.class, Float.TYPE);
    }
}

