/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.properties.entity.EntityAge;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultText;
import com.denizenscript.denizencore.scripts.commands.generator.ArgLinear;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.List;
import org.bukkit.entity.Breedable;
import org.bukkit.entity.Entity;

public class AgeCommand
extends AbstractCommand {
    public AgeCommand() {
        this.setName("age");
        this.setSyntax("age [<entity>|...] (adult/baby/<age>) (lock)");
        this.setRequiredArguments(1, 3);
        this.isProcedural = false;
        this.autoCompile();
    }

    public static void autoExecute(ScriptEntry scriptEntry, @ArgName(value="entities") @ArgLinear ObjectTag entities, @ArgName(value="age") @ArgLinear @ArgDefaultText(value="1") ObjectTag age, @ArgName(value="lock") boolean shouldLock) {
        if (!age.asElement().isInt() && !age.asElement().matchesEnum(AgeType.class)) {
            Deprecations.outOfOrderArgs.warn(scriptEntry);
            ObjectTag swap = entities;
            entities = age;
            age = swap;
        }
        int ageInt = 1;
        ElementTag ageElement = age.asElement();
        if (ageElement.matchesEnum(AgeType.class)) {
            switch (ageElement.asEnum(AgeType.class).ordinal()) {
                case 1: {
                    ageInt = -24000;
                    break;
                }
                case 0: {
                    ageInt = 0;
                }
            }
        } else if (ageElement.isInt()) {
            ageInt = ageElement.asInt();
        }
        List<EntityTag> entitiesList = entities.asType(ListTag.class, scriptEntry.context).filter(EntityTag.class, scriptEntry);
        for (EntityTag entity : entitiesList) {
            if (!entity.isSpawned()) continue;
            if (EntityAge.describes(entity)) {
                EntityAge property = new EntityAge(entity);
                property.setAge(ageInt);
                Entity entity2 = entity.getBukkitEntity();
                if (!(entity2 instanceof Breedable)) continue;
                Breedable breedable = (Breedable)entity2;
                breedable.setAgeLock(shouldLock);
                continue;
            }
            Debug.echoError(scriptEntry, entity.identify() + " is not ageable!");
        }
    }

    private static enum AgeType {
        ADULT,
        BABY;

    }
}

