/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.item;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.command.TabCompleteHelper;
import com.denizenscript.denizen.utilities.inventory.InventoryViewUtil;
import com.denizenscript.denizen.utilities.inventory.SlotHelper;
import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.denizencore.utilities.scheduling.OneTimeSchedulable;
import java.util.Collections;
import java.util.List;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;

public class FakeItemCommand
extends AbstractCommand {
    public FakeItemCommand() {
        this.setName("fakeitem");
        this.setSyntax("fakeitem [<item>|...] [slot:<slot>] (duration:<duration>) (players:<player>|...) (raw)");
        this.setRequiredArguments(2, 5);
        this.isProcedural = false;
        this.setBooleansHandled("raw");
    }

    @Override
    public void addCustomTabCompletions(AbstractCommand.TabCompletionsBuilder tab) {
        TabCompleteHelper.tabCompleteItems(tab);
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("slot") && arg.matchesPrefix("slot")) {
                scriptEntry.addObject("slot", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("duration") && arg.matchesPrefix("duration") && arg.matchesArgumentType(DurationTag.class)) {
                scriptEntry.addObject("duration", arg.asType(DurationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("item") && arg.matchesArgumentList(ItemTag.class)) {
                scriptEntry.addObject("item", arg.asType(ListTag.class).filter(ItemTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("players") && arg.matchesArgumentList(PlayerTag.class) && arg.matchesPrefix("players")) {
                scriptEntry.addObject("players", arg.asType(ListTag.class).filter(PlayerTag.class, scriptEntry));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("item")) {
            throw new InvalidArgumentsException("Must specify a valid item to fake!");
        }
        if (!scriptEntry.hasObject("slot")) {
            throw new InvalidArgumentsException("Must specify a valid slot!");
        }
        scriptEntry.defaultObject("duration", new DurationTag(0)).defaultObject("players", Collections.singletonList(Utilities.getEntryPlayer(scriptEntry)));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        boolean raw = scriptEntry.argAsBoolean("raw");
        List items = (List)scriptEntry.getObject("item");
        ElementTag elSlot = scriptEntry.getElement("slot");
        DurationTag duration = (DurationTag)scriptEntry.getObjectTag("duration");
        List players = (List)scriptEntry.getObject("players");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), FakeItemCommand.db("items", items), elSlot, duration, FakeItemCommand.db("players", players), FakeItemCommand.db("raw", raw));
        }
        if (players.size() == 0) {
            return;
        }
        int slot = SlotHelper.nameToIndex(elSlot.asString(), (Entity)((PlayerTag)players.get(0)).getPlayerEntity());
        if (slot == -1) {
            Debug.echoError(scriptEntry, "The input '" + elSlot.asString() + "' is not a valid slot!");
            return;
        }
        for (ItemTag item : items) {
            if (item == null) {
                ++slot;
                continue;
            }
            int slotSnapshot = slot;
            for (PlayerTag player : players) {
                Player ent = player.getPlayerEntity();
                int translated = raw ? slot : FakeItemCommand.translateSlot(ent, slot);
                InventoryView view = ent.getOpenInventory();
                Inventory top = InventoryViewUtil.getTopInventory(view);
                NMSHandler.packetHelper.setSlot(ent, translated, item.getItemStack(), false);
                if (!(duration.getSeconds() > 0.0)) continue;
                DenizenCore.schedule(new OneTimeSchedulable(() -> {
                    if (!ent.isOnline()) {
                        return;
                    }
                    if (top == InventoryViewUtil.getTopInventory(view)) {
                        ItemStack original = InventoryViewUtil.getItem(view, translated);
                        NMSHandler.packetHelper.setSlot(ent, translated, original, false);
                    } else if (slotSnapshot < 36) {
                        NMSHandler.packetHelper.setSlot(ent, FakeItemCommand.translateSlot(ent, slotSnapshot), ent.getInventory().getItem(slotSnapshot), false);
                    }
                }, (float)duration.getSeconds()));
            }
            ++slot;
        }
    }

    static int translateSlot(Player player, int slot) {
        int result;
        int topSize = InventoryViewUtil.getTopInventory(player.getOpenInventory()).getSize();
        if (InventoryViewUtil.getTopInventory(player.getOpenInventory()) instanceof CraftingInventory) {
            topSize = 9;
            if (slot > 35) {
                if (slot < 40) {
                    return 8 - (slot - 36);
                }
                if (slot == 40) {
                    return 45;
                }
                if (slot < 46) {
                    return slot - 41;
                }
            }
        }
        int total = 36 + topSize;
        int rowCount = (int)Math.ceil((double)total / 9.0);
        if (slot < 9) {
            int row = (int)Math.floor((double)slot / 9.0);
            int flippedRow = rowCount - row - 1;
            result = flippedRow * 9 + slot;
        } else {
            result = slot < 36 ? slot + (rowCount - 5) * 9 : slot - 36;
        }
        if (result < 0) {
            return 0;
        }
        if (result > total) {
            return total - 1;
        }
        return result;
    }
}

