/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.player;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.command.TabCompleteHelper;
import com.denizenscript.denizen.utilities.entity.FakeEntity;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsRuntimeException;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultNull;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultText;
import com.denizenscript.denizencore.scripts.commands.generator.ArgLinear;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import com.denizenscript.denizencore.scripts.commands.generator.ArgSubType;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.List;

public class FakeSpawnCommand
extends AbstractCommand {
    public FakeSpawnCommand() {
        this.setName("fakespawn");
        this.setSyntax("fakespawn [<entity>] [<location>/cancel] (players:<player>|...) (duration:<duration>{10s}) (mount_to:<entity>)");
        this.setRequiredArguments(2, 5);
        this.isProcedural = false;
        this.addRemappedPrefixes("duration", "d");
        this.addRemappedPrefixes("players", "to");
        this.autoCompile();
    }

    @Override
    public void addCustomTabCompletions(AbstractCommand.TabCompletionsBuilder tab) {
        TabCompleteHelper.tabCompleteEntityTypes(tab);
    }

    public static void autoExecute(ScriptEntry scriptEntry, @ArgName(value="entity") @ArgLinear ObjectTag entityObj, @ArgName(value="location") @ArgLinear @ArgDefaultNull ObjectTag locationObj, @ArgName(value="cancel") boolean cancel, @ArgName(value="players") @ArgPrefixed @ArgDefaultNull @ArgSubType(value=PlayerTag.class) List<PlayerTag> players, @ArgName(value="duration") @ArgPrefixed @ArgDefaultText(value="10s") DurationTag duration, @ArgName(value="mount_to") @ArgPrefixed @ArgDefaultNull EntityTag vehicle) {
        if (locationObj != null && entityObj.identify().startsWith("l@")) {
            ObjectTag swap = locationObj;
            locationObj = entityObj;
            entityObj = swap;
            Deprecations.outOfOrderArgs.warn(scriptEntry);
        }
        if (players == null) {
            if (!Utilities.entryHasPlayer(scriptEntry)) {
                throw new InvalidArgumentsRuntimeException("Must specify an online player!");
            }
            players = List.of(Utilities.getEntryPlayer(scriptEntry));
        }
        LocationTag location = locationObj == null ? null : locationObj.asType(LocationTag.class, scriptEntry.context);
        EntityTag entity = entityObj.asType(EntityTag.class, scriptEntry.context);
        if (entity == null) {
            throw new InvalidArgumentsRuntimeException("Must specify a valid entity!");
        }
        if (location == null && !cancel) {
            throw new InvalidArgumentsRuntimeException("Must specify a valid location!");
        }
        if (vehicle != null && !vehicle.isValid()) {
            throw new InvalidArgumentsRuntimeException("Must specify a valid entity to mount to!");
        }
        if (!cancel) {
            FakeEntity created = FakeEntity.showFakeEntityTo(players, entity, location, duration, vehicle);
            scriptEntry.saveObject("faked_entity", created.entity);
            return;
        }
        if (entity.isFake) {
            FakeEntity fakeEnt = FakeEntity.idsToEntities.get(entity.getUUID());
            if (fakeEnt != null) {
                fakeEnt.cancelEntity();
            } else {
                Debug.echoDebug((Debuggable)scriptEntry, "Entity '" + String.valueOf(entity) + "' cannot be cancelled: not listed in fake-entity map.");
            }
        }
    }
}

