/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.containers.core;

import com.denizenscript.denizen.npc.traits.AssignmentTrait;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.commands.core.CooldownCommand;
import com.denizenscript.denizen.scripts.containers.core.AssignmentScriptContainer;
import com.denizenscript.denizen.scripts.containers.core.InteractScriptContainer;
import com.denizenscript.denizen.scripts.triggers.AbstractTrigger;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.TimeTag;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;

public class InteractScriptHelper {
    public static List<InteractScriptContainer> getInteractScripts(NPCTag npc) {
        if (npc == null) {
            return null;
        }
        AssignmentTrait trait = (AssignmentTrait)npc.getCitizen().getTraitNullable(AssignmentTrait.class);
        if (trait == null) {
            return null;
        }
        ArrayList<InteractScriptContainer> result = new ArrayList<InteractScriptContainer>();
        for (AssignmentScriptContainer container : trait.containerCache) {
            InteractScriptContainer interact;
            if (container == null || (interact = container.getInteract()) == null || !interact.shouldEnable()) continue;
            result.add(interact);
        }
        return result.isEmpty() ? null : result;
    }

    public static List<InteractScriptContainer> getInteractScripts(NPCTag npc, PlayerTag player, boolean showDebug, Class<? extends AbstractTrigger> trigger) {
        if (player == null || trigger == null) {
            return null;
        }
        List<InteractScriptContainer> interactScripts = InteractScriptHelper.getInteractScripts(npc);
        if (interactScripts == null) {
            return null;
        }
        for (int i = 0; i < interactScripts.size(); ++i) {
            InteractScriptContainer interactScript = interactScripts.get(i);
            if (Debug.shouldDebug(interactScript) && showDebug) {
                Debug.log(Debug.DebugElement.Header, "Getting interact script: n@" + npc.getName() + "/p@" + player.getName());
            }
            if (!CooldownCommand.checkCooldown(player, interactScript.getName()) && Debug.shouldDebug(interactScript) && showDebug) {
                Debug.log(String.valueOf(ChatColor.GOLD) + interactScript.getName() + " isn't cooled down yet! Skipping.");
                interactScripts.remove(i--);
                continue;
            }
            if (!Debug.shouldDebug(interactScript) || !showDebug) continue;
            Debug.log("Interact script is " + interactScript.getName() + ". Current step for this script is: " + InteractScriptHelper.getCurrentStep(player, interactScript.getName()));
            Debug.log(Debug.DebugElement.Footer, "");
        }
        return interactScripts.isEmpty() ? null : interactScripts;
    }

    public static String getCurrentStep(PlayerTag player, String scriptName) {
        if (scriptName == null) {
            return null;
        }
        ObjectTag step = player.getFlagTracker().getFlagValue("__interact_step." + scriptName);
        if (step != null) {
            return step.toString().toUpperCase();
        }
        return ScriptRegistry.getScriptContainerAs(scriptName, InteractScriptContainer.class).getDefaultStepName().toUpperCase();
    }

    public static TimeTag getStepExpiration(PlayerTag player, String scriptName) {
        if (scriptName == null) {
            return null;
        }
        return player.getFlagTracker().getFlagExpirationTime("__interact_step." + scriptName);
    }
}

