/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.command.manager.messaging;

import com.denizenscript.denizen.utilities.command.manager.messaging.Colorizer;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Messaging {
    private static String HIGHLIGHT_COLOUR = ChatColor.YELLOW.toString();
    private static String MESSAGE_COLOUR = ChatColor.GREEN.toString();

    public static void configure(String messageColour, String highlightColour) {
        MESSAGE_COLOUR = messageColour;
        HIGHLIGHT_COLOUR = highlightColour;
    }

    private static String prettify(String message) {
        String trimmed = ((String)message).trim();
        String messageColor = Colorizer.parseColors(MESSAGE_COLOUR);
        if (!trimmed.isEmpty()) {
            if (trimmed.charAt(0) == '\u00a7') {
                ChatColor test = ChatColor.getByChar((String)trimmed.substring(1, 2));
                if (test == null) {
                    message = messageColor + (String)message;
                }
            } else {
                message = messageColor + (String)message;
            }
        }
        return message;
    }

    public static void send(CommandSender sender, String msg) {
        Messaging.sendMessageTo(sender, msg);
    }

    public static void sendInfo(CommandSender sender, String msg) {
        Messaging.send(sender, String.valueOf(ChatColor.YELLOW) + msg);
    }

    public static void sendError(CommandSender sender, String msg) {
        Messaging.send(sender, String.valueOf(ChatColor.RED) + msg);
    }

    private static void sendMessageTo(CommandSender sender, String rawMessage) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            rawMessage = rawMessage.replace("<player>", player.getName());
            rawMessage = rawMessage.replace("<world>", player.getWorld().getName());
        }
        rawMessage = Colorizer.parseColors(rawMessage);
        for (String message : rawMessage.split("<br>|<n>|\\n")) {
            sender.sendMessage(Messaging.prettify(message));
        }
    }
}

