/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.properties.bukkit.BukkitColorExtensions;
import com.denizenscript.denizen.objects.properties.item.ItemProperty;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizen.utilities.PaperAPITools;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ColorTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.Registry;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SuspiciousStewMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class ItemPotion
extends ItemProperty<ObjectTag> {
    public static boolean describes(ItemTag item) {
        return item.getItemMeta() instanceof PotionMeta || item.getItemMeta() instanceof SuspiciousStewMeta;
    }

    public static MapTag effectToMap(PotionEffect effect, boolean includeDeprecated) {
        MapTag map = new MapTag();
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_20)) {
            map.putObject("effect", (ObjectTag)new ElementTag(Utilities.namespacedKeyToString(effect.getType().getKey()), true));
        } else {
            includeDeprecated = true;
        }
        map.putObject("amplifier", (ObjectTag)new ElementTag(effect.getAmplifier()));
        map.putObject("duration", (ObjectTag)new DurationTag((long)effect.getDuration()));
        map.putObject("ambient", (ObjectTag)new ElementTag(effect.isAmbient()));
        map.putObject("particles", (ObjectTag)new ElementTag(effect.hasParticles()));
        map.putObject("icon", (ObjectTag)new ElementTag(effect.hasIcon()));
        if (includeDeprecated) {
            map.putObject("type", (ObjectTag)new ElementTag(effect.getType().getName(), true));
        }
        return map;
    }

    public ListTag getMapTagData(boolean includeExtras) {
        List<PotionEffect> potionEffects = this.getCustomEffects();
        ListTag result = new ListTag(potionEffects.size() + 1);
        ItemMeta itemMeta = this.getItemMeta();
        if (itemMeta instanceof PotionMeta) {
            PotionMeta potionMeta = (PotionMeta)itemMeta;
            MapTag base = new MapTag();
            if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_20)) {
                if (potionMeta.hasBasePotionType()) {
                    base.putObject("base_type", (ObjectTag)new ElementTag(Utilities.namespacedKeyToString(potionMeta.getBasePotionType().getKey()), true));
                }
                if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_21) && PaperAPITools.instance.hasCustomName(potionMeta)) {
                    base.putObject("translation_id", (ObjectTag)new ElementTag(potionMeta.getCustomName(), true));
                }
            } else {
                includeExtras = true;
            }
            if (includeExtras) {
                LegacyPotionData data = this.getLegacyBasePotionData();
                base.putObject("type", (ObjectTag)new ElementTag(data.type(), true));
                base.putObject("upgraded", (ObjectTag)new ElementTag(data.upgraded()));
                base.putObject("extended", (ObjectTag)new ElementTag(data.extended()));
                if (potionMeta.hasColor()) {
                    base.putObject("color", (ObjectTag)BukkitColorExtensions.fromColor(potionMeta.getColor()));
                }
            }
            result.addObject(base);
        }
        for (PotionEffect potionEffect : potionEffects) {
            result.addObject(ItemPotion.effectToMap(potionEffect, includeExtras));
        }
        return result;
    }

    public static PotionEffect parseEffect(MapTag effectMap, TagContext context) {
        PotionEffectType type;
        DurationTag duration = new DurationTag(0);
        int amplifier = 0;
        boolean ambient = true;
        boolean particles = true;
        boolean icon = false;
        ElementTag effectInput = effectMap.getElement("effect");
        ElementTag typeInput = null;
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_20) && effectInput != null) {
            type = (PotionEffectType)Registry.EFFECT.get(Utilities.parseNamespacedKey(effectInput.asString()));
        } else {
            typeInput = effectMap.getElement("type");
            if (typeInput != null) {
                type = PotionEffectType.getByName((String)typeInput.asString());
                if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_20)) {
                    BukkitImplDeprecations.oldPotionEffectType.warn(context);
                }
            } else {
                if (context.showErrors()) {
                    Debug.echoError("Invalid potion effect: effect type is required.");
                }
                return null;
            }
        }
        if (type == null) {
            if (context.showErrors()) {
                Debug.echoError("Invalid potion effect type '" + String.valueOf(effectInput != null ? effectInput : typeInput) + "' specified: effect type is required.");
            }
            return null;
        }
        if (effectMap.containsKey("amplifier")) {
            ElementTag amplifierElement = effectMap.getElement("amplifier");
            if (amplifierElement.isInt()) {
                amplifier = amplifierElement.asInt();
            } else if (context.showErrors()) {
                Debug.echoError("Invalid amplifier '" + String.valueOf(amplifierElement) + "': must be an integer.");
            }
        }
        if (effectMap.containsKey("duration")) {
            ObjectTag durationObj = effectMap.getObject("duration");
            if (durationObj.canBeType(DurationTag.class)) {
                duration = durationObj.asType(DurationTag.class, context);
            } else if (context.showErrors()) {
                Debug.echoError("Invalid duration '" + String.valueOf(durationObj) + "': must be a valid DurationTag");
            }
        }
        if (effectMap.containsKey("ambient")) {
            ElementTag ambientElement = effectMap.getElement("ambient");
            if (ambientElement.isBoolean()) {
                ambient = ambientElement.asBoolean();
            } else if (context.showErrors()) {
                Debug.echoError("Invalid ambient state '" + String.valueOf(ambientElement) + "': must be a boolean.");
            }
        }
        if (effectMap.containsKey("particles")) {
            ElementTag particlesElement = effectMap.getElement("particles");
            if (particlesElement.isBoolean()) {
                particles = particlesElement.asBoolean();
            } else if (context.showErrors()) {
                Debug.echoError("Invalid particles state '" + String.valueOf(particlesElement) + "': must be a boolean.");
            }
        }
        if (effectMap.containsKey("icon")) {
            ElementTag iconElement = effectMap.getElement("icon");
            if (iconElement.isBoolean()) {
                icon = iconElement.asBoolean();
            } else if (context.showErrors()) {
                Debug.echoError("Invalid icon state '" + String.valueOf(iconElement) + "': must be a boolean.");
            }
        }
        return new PotionEffect(type, duration.getTicksAsInt(), amplifier, ambient, particles, icon);
    }

    public List<PotionEffect> getCustomEffects() {
        ItemMeta itemMeta = this.getItemMeta();
        if (itemMeta instanceof SuspiciousStewMeta) {
            SuspiciousStewMeta suspiciousStewMeta = (SuspiciousStewMeta)itemMeta;
            return suspiciousStewMeta.getCustomEffects();
        }
        return this.as(PotionMeta.class).getCustomEffects();
    }

    @Override
    public ListTag getPropertyValue() {
        return this.getMapTagData(false);
    }

    private boolean applyBasePotionData(PotionMeta potionMeta, ObjectTag baseData, Mechanism mechanism) {
        ElementTag baseTypeElement;
        if (!baseData.canBeType(MapTag.class)) {
            return ItemPotion.applyLegacyStringBasePotionData(baseData.toString(), potionMeta, mechanism);
        }
        MapTag baseDataMap = baseData.asType(MapTag.class, mechanism.context);
        if (NMSHandler.getVersion().isAtMost(NMSVersion.v1_19) || baseDataMap.containsKey("type")) {
            return ItemPotion.applyLegacyMapBasePotionData(baseDataMap, potionMeta, mechanism);
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_21)) {
            ElementTag translationId = baseDataMap.getElement("translation_id");
            potionMeta.setCustomName(translationId != null ? translationId.asString() : null);
        }
        if ((baseTypeElement = baseDataMap.getElement("base_type")) == null) {
            potionMeta.setBasePotionType(null);
            return false;
        }
        PotionType baseType = Utilities.elementToEnumlike(baseTypeElement, PotionType.class);
        if (baseType == null) {
            mechanism.echoError("Invalid base potion type '" + String.valueOf(baseTypeElement) + "' specified.");
            return true;
        }
        potionMeta.setBasePotionType(baseType);
        return false;
    }

    @Override
    public void setPropertyValue(ObjectTag value, Mechanism mechanism) {
        ArrayList<ObjectTag> data = new ArrayList<ObjectTag>(CoreUtilities.objectToList(value, mechanism.context));
        ItemMeta meta = this.getItemMeta();
        if (meta instanceof PotionMeta) {
            PotionMeta potionMeta = (PotionMeta)meta;
            if (this.applyBasePotionData(potionMeta, (ObjectTag)data.remove(0), mechanism)) {
                return;
            }
            potionMeta.clearCustomEffects();
        } else {
            ((SuspiciousStewMeta)meta).clearCustomEffects();
        }
        for (ObjectTag effectObj : data) {
            PotionEffect effect = effectObj.canBeType(MapTag.class) ? ItemPotion.parseEffect(effectObj.asType(MapTag.class, mechanism.context), mechanism.context) : ItemPotion.parseLegacyEffectString(effectObj.toString(), mechanism.context);
            if (effect == null) {
                mechanism.echoError("Invalid potion effect '" + String.valueOf(effectObj) + "'");
                continue;
            }
            if (meta instanceof PotionMeta) {
                PotionMeta potionMeta = (PotionMeta)meta;
                potionMeta.addCustomEffect(effect, false);
                continue;
            }
            ((SuspiciousStewMeta)meta).addCustomEffect(effect, false);
        }
        this.setItemMeta(meta);
    }

    @Override
    public String getPropertyId() {
        return "potion_effects";
    }

    public static void register() {
        PropertyParser.registerTag(ItemPotion.class, ListTag.class, "effects_data", (attribute, prop) -> prop.getMapTagData(true), new String[0]);
        PropertyParser.registerMechanism(ItemPotion.class, ObjectTag.class, "potion_effects", (prop, mechanism, input) -> prop.setPropertyValue(input, mechanism), new String[0]);
        PropertyParser.registerTag(ItemPotion.class, ElementTag.class, "has_potion_effect", (attribute, object) -> {
            boolean bl;
            ItemMeta patt0$temp = object.getItemMeta();
            if (patt0$temp instanceof SuspiciousStewMeta) {
                SuspiciousStewMeta suspiciousStewMeta = (SuspiciousStewMeta)patt0$temp;
                bl = suspiciousStewMeta.hasCustomEffects();
            } else {
                bl = object.as(PotionMeta.class).hasCustomEffects();
            }
            return new ElementTag(bl);
        }, new String[0]);
        PropertyParser.registerTag(ItemPotion.class, ElementTag.class, "potion_base_type", (attribute, object) -> {
            if (!(object.getItemMeta() instanceof PotionMeta)) {
                attribute.echoError("This item does not have a base potion type.");
                return null;
            }
            BukkitImplDeprecations.oldPotionEffects.warn(attribute.context);
            return new ElementTag(object.getLegacyBasePotionData().type(), true);
        }, new String[0]);
        PropertyParser.registerTag(ItemPotion.class, ElementTag.class, "potion_base", (attribute, object) -> {
            ItemMeta patt0$temp = object.getItemMeta();
            if (!(patt0$temp instanceof PotionMeta)) {
                attribute.echoError("This item does not have a base potion type.");
                return null;
            }
            PotionMeta potionMeta = (PotionMeta)patt0$temp;
            BukkitImplDeprecations.oldPotionEffects.warn(attribute.context);
            LegacyPotionData data = object.getLegacyBasePotionData();
            return new ElementTag(data.type() + "," + (data.upgraded() ? 2 : 1) + "," + data.extended() + "," + (object.getMaterial() == Material.SPLASH_POTION) + (String)(potionMeta.hasColor() ? "," + BukkitColorExtensions.fromColor(potionMeta.getColor()).identify() : ""));
        }, new String[0]);
        PropertyParser.registerTag(ItemPotion.class, ListTag.class, "potion_effects", (attribute, object) -> {
            ListTag result = new ListTag();
            for (PotionEffect pot : object.getCustomEffects()) {
                result.add(ItemPotion.effectToLegacyString(pot, attribute.context));
            }
            return result;
        }, new String[0]);
        PropertyParser.registerTag(ItemPotion.class, ElementTag.class, "potion_effect", (attribute, object) -> {
            int potN;
            BukkitImplDeprecations.oldPotionEffects.warn(attribute.context);
            int n = potN = attribute.hasParam() ? attribute.getIntParam() - 1 : 0;
            if (potN < 0 || potN > object.getCustomEffects().size()) {
                return null;
            }
            if (attribute.startsWith("is_splash", 2)) {
                attribute.fulfill(1);
                return new ElementTag(object.getMaterial() == Material.SPLASH_POTION);
            }
            if (attribute.startsWith("is_extended", 2)) {
                attribute.fulfill(1);
                if (!(object.getItemMeta() instanceof PotionMeta)) {
                    return null;
                }
                return new ElementTag(object.getLegacyBasePotionData().extended());
            }
            if (attribute.startsWith("level", 2)) {
                attribute.fulfill(1);
                if (!(object.getItemMeta() instanceof PotionMeta)) {
                    return null;
                }
                return new ElementTag(object.getLegacyBasePotionData().upgraded() ? 2 : 1);
            }
            if (attribute.startsWith("is_ambient", 2)) {
                attribute.fulfill(1);
                return new ElementTag(object.getCustomEffects().get(potN).isAmbient());
            }
            if (attribute.startsWith("icon", 2)) {
                attribute.fulfill(1);
                return new ElementTag(object.getCustomEffects().get(potN).hasIcon());
            }
            if (attribute.startsWith("has_particles", 2)) {
                attribute.fulfill(1);
                return new ElementTag(object.getCustomEffects().get(potN).hasParticles());
            }
            if (attribute.startsWith("duration", 2)) {
                attribute.fulfill(1);
                return new ElementTag(object.getCustomEffects().get(potN).getDuration());
            }
            if (attribute.startsWith("amplifier", 2)) {
                attribute.fulfill(1);
                return new ElementTag(object.getCustomEffects().get(potN).getAmplifier());
            }
            if (attribute.startsWith("type", 2)) {
                attribute.fulfill(1);
                return new ElementTag(object.getCustomEffects().get(potN).getType().getName());
            }
            if (attribute.startsWith("data", 2)) {
                attribute.fulfill(1);
                return new ElementTag(0);
            }
            if (!(object.getItemMeta() instanceof PotionMeta)) {
                return null;
            }
            LegacyPotionData data = object.getLegacyBasePotionData();
            return new ElementTag(data.type() + "," + (data.upgraded() ? 2 : 1) + "," + data.extended() + "," + (object.getMaterial() == Material.SPLASH_POTION));
        }, new String[0]);
    }

    private static boolean applyLegacyMapBasePotionData(MapTag input, PotionMeta potionMeta, Mechanism mechanism) {
        if (!input.containsKey("type")) {
            mechanism.echoError("Must specify a base potion type.");
            return true;
        }
        ElementTag typeElement = input.getElement("type");
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_20) && typeElement.asLowerString().equals("uncraftable")) {
            potionMeta.setBasePotionType(null);
            return false;
        }
        PotionType type = Utilities.elementToEnumlike(typeElement, PotionType.class);
        if (type == null) {
            mechanism.echoError("Invalid base potion type '" + String.valueOf(typeElement) + "': type is required");
            return true;
        }
        boolean upgraded = false;
        boolean extended = false;
        if (input.containsKey("upgraded")) {
            ElementTag upgradedElement = input.getElement("upgraded");
            if (upgradedElement.isBoolean()) {
                upgraded = upgradedElement.asBoolean();
            } else {
                mechanism.echoError("Invalid upgraded state '" + String.valueOf(upgradedElement) + "': must be a boolean");
            }
        }
        if (input.containsKey("extended")) {
            ElementTag extendedElement = input.getElement("extended");
            if (extendedElement.isBoolean()) {
                extended = extendedElement.asBoolean();
            } else {
                mechanism.echoError("Invalid extended state '" + String.valueOf(extendedElement) + "': must be a boolean");
            }
        }
        ColorTag color = null;
        if (input.containsKey("color")) {
            ObjectTag colorObj = input.getObject("color");
            if (colorObj.canBeType(ColorTag.class)) {
                color = colorObj.asType(ColorTag.class, mechanism.context);
            } else {
                mechanism.echoError("Invalid color '" + String.valueOf(colorObj) + "': must be a valid ColorTag");
            }
        }
        ItemPotion.applyLegacyBasePotionData(potionMeta, type, upgraded, extended, color, mechanism);
        return false;
    }

    private static boolean applyLegacyStringBasePotionData(String input, PotionMeta potionMeta, Mechanism mechanism) {
        PotionType type;
        String[] d1 = input.split(",");
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_20) && CoreUtilities.equalsIgnoreCase(d1[0], "uncraftable")) {
            potionMeta.setBasePotionType(null);
            return false;
        }
        try {
            type = PotionType.valueOf((String)d1[0].toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            mechanism.echoError("Invalid base potion type '" + d1[0] + "': type is required");
            return true;
        }
        boolean upgraded = CoreUtilities.equalsIgnoreCase(d1[1], "true");
        boolean extended = CoreUtilities.equalsIgnoreCase(d1[2], "true");
        ColorTag color = null;
        if (d1.length > 3) {
            ColorTag temp = ColorTag.valueOf(d1[3].replace("&comma", ","), mechanism.context);
            if (temp == null) {
                mechanism.echoError("Invalid color '" + d1[3] + "': must be a valid ColorTag");
            } else {
                color = temp;
            }
        }
        ItemPotion.applyLegacyBasePotionData(potionMeta, type, upgraded, extended, color, mechanism);
        return false;
    }

    private static void applyLegacyBasePotionData(PotionMeta potionMeta, PotionType type, boolean upgraded, boolean extended, ColorTag color, Mechanism mechanism) {
        if (upgraded && !type.isUpgradeable()) {
            mechanism.echoError("Cannot upgrade potion of type '" + type.name() + "'");
            upgraded = false;
        }
        if (extended && !type.isExtendable()) {
            mechanism.echoError("Cannot extend potion of type '" + type.name() + "'");
            extended = false;
        }
        if (upgraded && extended) {
            mechanism.echoError("Cannot both upgrade and extend a potion");
            extended = false;
        }
        potionMeta.setBasePotionData(new PotionData(type, extended, upgraded));
        if (color != null) {
            potionMeta.setColor(BukkitColorExtensions.getColor(color));
        }
    }

    public static String effectToLegacyString(PotionEffect effect, TagContext context) {
        BukkitImplDeprecations.oldPotionEffects.warn(context);
        return effect.getType().getName() + "," + effect.getAmplifier() + "," + effect.getDuration() + "," + effect.isAmbient() + "," + effect.hasParticles() + "," + effect.hasIcon();
    }

    public static PotionEffect parseLegacyEffectString(String str, TagContext context) {
        ElementTag check;
        PotionEffectType type;
        String[] d2 = str.split(",");
        try {
            type = PotionEffectType.getByName((String)d2[0].toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            if (context.showErrors()) {
                Debug.echoError("Invalid potion effect type '" + d2[0] + "'");
            }
            return null;
        }
        if (d2.length < 3) {
            return null;
        }
        int duration = new ElementTag(d2[2]).asInt();
        int amplifier = new ElementTag(d2[1]).asInt();
        boolean ambient = true;
        boolean particles = true;
        if (d2.length > 3) {
            ambient = new ElementTag(d2[3]).asBoolean();
            particles = new ElementTag(d2[4]).asBoolean();
        }
        boolean icon = false;
        if (d2.length > 5 && (check = new ElementTag(d2[5])).isBoolean()) {
            icon = check.asBoolean();
        }
        return new PotionEffect(type, duration, amplifier, ambient, particles, icon);
    }

    @Deprecated(forRemoval=true)
    public LegacyPotionData getLegacyBasePotionData() {
        PotionData data = this.as(PotionMeta.class).getBasePotionData();
        return data != null ? new LegacyPotionData(data) : LegacyPotionData.DEFAULT_DATA;
    }

    @Deprecated(forRemoval=true)
    public record LegacyPotionData(String type, boolean extended, boolean upgraded) {
        public static final LegacyPotionData DEFAULT_DATA = new LegacyPotionData("UNCRAFTABLE", false, false);

        public LegacyPotionData(PotionData data) {
            this(data.getType().name(), data.isExtended(), data.isUpgraded());
        }
    }
}

