/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.flags;

import com.denizenscript.denizencore.flags.AbstractFlagTracker;
import com.denizenscript.denizencore.flags.MapTagBasedFlagTracker;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.core.TimeTag;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RedirectionFlagTracker
extends AbstractFlagTracker {
    public AbstractFlagTracker original;
    public String prefix;

    public RedirectionFlagTracker(AbstractFlagTracker original, String prefix) {
        this.original = original;
        this.prefix = prefix;
    }

    @Override
    public MapTag getRootMap(String key) {
        List<String> parts = CoreUtilities.split(this.prefix, '.');
        parts.add(key);
        MapTag target = this.original.getRootMap(parts.get(0));
        if (target == null) {
            return null;
        }
        for (int i = 1; i < parts.size(); ++i) {
            if ((target = (MapTag)target.getObject(MapTagBasedFlagTracker.valueString)) == null) {
                return null;
            }
            if ((target = (MapTag)target.getObject(parts.get(i))) != null) continue;
            return null;
        }
        return target;
    }

    @Override
    public void setRootMap(String key, MapTag map) {
        this.original.setFlag(this.prefix + "." + key, map, null, false);
    }

    @Override
    public ObjectTag getFlagValue(String key) {
        return this.original.getFlagValue(this.prefix + "." + key);
    }

    @Override
    public TimeTag getFlagExpirationTime(String key) {
        return this.original.getFlagExpirationTime(this.prefix + "." + key);
    }

    @Override
    public Collection<String> listAllFlags() {
        MapTag map = this.getFlagMap();
        if (map == null) {
            return new ArrayList<String>();
        }
        return map.keys();
    }

    @Override
    public void setFlag(String key, ObjectTag value, TimeTag expiration, boolean doFlaggify) {
        this.original.setFlag(this.prefix + "." + key, value, expiration, doFlaggify);
    }

    @Override
    public MapTag getFlagMap() {
        ObjectTag obj = this.original.getFlagValue(this.prefix);
        if (!(obj instanceof MapTag)) {
            return null;
        }
        return (MapTag)obj;
    }
}

