/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.inventory;

import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class SlotHelper {
    public static final int BOOTS = 36;
    public static final int LEGGINGS = 37;
    public static final int CHESTPLATE = 38;
    public static final int HELMET = 39;
    public static final int OFFHAND = 40;
    public static final HashMap<String, Integer> nameIndexMap = new HashMap();
    public static final List<String>[] indexNameMap = new List[50];

    public static int slotForItem(PlayerInventory inventory, ItemStack item) {
        if (item.equals((Object)inventory.getChestplate())) {
            return 38;
        }
        if (item.equals((Object)inventory.getLeggings())) {
            return 37;
        }
        if (item.equals((Object)inventory.getBoots())) {
            return 36;
        }
        if (item.equals((Object)inventory.getHelmet())) {
            return 39;
        }
        if (item.equals((Object)inventory.getItemInMainHand())) {
            return inventory.getHeldItemSlot();
        }
        if (item.equals((Object)inventory.getItemInOffHand())) {
            return 40;
        }
        ItemStack[] contents = inventory.getContents();
        for (int i = 0; i < contents.length; ++i) {
            if (!item.equals((Object)contents[i])) continue;
            return i;
        }
        return -1;
    }

    public static EquipmentSlot indexToEquipSlot(int index) {
        switch (index) {
            case 36: {
                return EquipmentSlot.FEET;
            }
            case 37: {
                return EquipmentSlot.LEGS;
            }
            case 38: {
                return EquipmentSlot.CHEST;
            }
            case 39: {
                return EquipmentSlot.HEAD;
            }
            case 40: {
                return EquipmentSlot.OFF_HAND;
            }
        }
        return null;
    }

    public static int equipSlotToIndex(EquipmentSlot slot) {
        switch (slot) {
            case FEET: {
                return 36;
            }
            case LEGS: {
                return 37;
            }
            case CHEST: {
                return 38;
            }
            case HEAD: {
                return 39;
            }
            case OFF_HAND: {
                return 40;
            }
        }
        return -1;
    }

    public static void registerSlotName(String name, int index) {
        nameIndexMap.put(name, index);
        nameIndexMap.put(name + "s", index);
        List<String> list = indexNameMap[index];
        if (list == null) {
            SlotHelper.indexNameMap[index] = list = new ArrayList<String>();
        }
        list.add(name);
        list.add(name + "s");
    }

    public static int nameToIndexFor(String name, InventoryHolder holder) {
        return SlotHelper.nameToIndex(name, holder instanceof Entity ? (Entity)holder : null);
    }

    public static int nameToIndex(String name, Entity entity) {
        if ((name = name.toLowerCase().replace("_", "")).equals("hand")) {
            return entity instanceof Player ? ((Player)entity).getInventory().getHeldItemSlot() : 0;
        }
        Integer matched = nameIndexMap.get(name);
        if (matched != null) {
            return matched;
        }
        if (ArgumentHelper.matchesInteger(name)) {
            return Integer.parseInt(name) - 1;
        }
        return -1;
    }

    public static boolean doesMatch(String text, Entity entity, int slot) {
        List<String> names;
        ScriptEvent.MatchHelper matcher = ScriptEvent.createMatcher(text);
        if (slot >= 0 && slot < indexNameMap.length && (names = indexNameMap[slot]) != null) {
            for (String name : names) {
                if (!matcher.doesMatch(name)) continue;
                return true;
            }
        }
        if (entity instanceof Player && slot == ((Player)entity).getInventory().getHeldItemSlot() && matcher.doesMatch("hand")) {
            return true;
        }
        return matcher.doesMatch(String.valueOf(slot + 1));
    }

    static {
        SlotHelper.registerSlotName("boot", 36);
        SlotHelper.registerSlotName("feet", 36);
        SlotHelper.registerSlotName("foot", 36);
        SlotHelper.registerSlotName("shoe", 36);
        SlotHelper.registerSlotName("leg", 37);
        SlotHelper.registerSlotName("legging", 37);
        SlotHelper.registerSlotName("chest", 38);
        SlotHelper.registerSlotName("chestplate", 38);
        SlotHelper.registerSlotName("helmet", 39);
        SlotHelper.registerSlotName("head", 39);
        SlotHelper.registerSlotName("offhand", 40);
    }
}

