/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.block;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.BrewingStandFuelEvent;

public class BrewingStandFueledScriptEvent
extends BukkitScriptEvent
implements Listener {
    public LocationTag location;
    public ItemTag item;
    public BrewingStandFuelEvent event;

    public BrewingStandFueledScriptEvent() {
        this.registerCouldMatcher("brewing stand fueled (with <item>)");
        this.registerOptionalDetermination("fuel_power", ElementTag.class, (evt, context, power) -> {
            if (power.isInt()) {
                evt.event.setFuelPower(power.asInt());
                return true;
            }
            return false;
        });
        this.registerOptionalDetermination("consuming", ElementTag.class, (evt, context, value) -> {
            if (value.isBoolean()) {
                evt.event.setConsuming(value.asBoolean());
                return true;
            }
            return false;
        });
        this.registerTextDetermination("not_consuming", evt -> {
            BukkitImplDeprecations.brewingStandConsumeDetermination.warn();
            evt.event.setConsuming(false);
        });
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        if (path.eventArgLowerAt(3).equals("with") && !path.tryArgObject(4, this.item)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "location" -> this.location;
            case "item" -> this.item;
            case "fuel_power" -> new ElementTag(this.event.getFuelPower());
            case "consuming" -> new ElementTag(this.event.isConsuming());
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onBrewingStandFueled(BrewingStandFuelEvent event) {
        this.location = new LocationTag(event.getBlock().getLocation());
        this.item = new ItemTag(event.getFuel());
        this.event = event;
        this.fire((Event)event);
    }
}

