/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;

public class PlayerArmorStandManipulateScriptEvent
extends BukkitScriptEvent
implements Listener {
    public PlayerArmorStandManipulateEvent event;
    public EntityTag entity;
    public ItemTag armorStandItem;
    public ItemTag playerItem;

    public PlayerArmorStandManipulateScriptEvent() {
        this.registerCouldMatcher("player changes armor stand item");
        this.registerSwitches("from", "to", "hand", "slot", "armor_stand");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.event.getRightClicked().getLocation())) {
            return false;
        }
        if (!path.tryObjectSwitch("from", this.armorStandItem)) {
            return false;
        }
        if (!path.tryObjectSwitch("armor_stand", this.entity)) {
            return false;
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19) && !PlayerArmorStandManipulateScriptEvent.runGenericSwitchCheck(path, "hand", this.event.getHand().name())) {
            return false;
        }
        if (!path.tryObjectSwitch("to", this.playerItem)) {
            return false;
        }
        if (!PlayerArmorStandManipulateScriptEvent.runGenericSwitchCheck(path, "slot", this.event.getSlot().name())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((Entity)this.event.getPlayer());
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "armor_stand_item" -> this.armorStandItem;
            case "entity" -> this.entity;
            case "hand" -> {
                if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19)) {
                    yield new ElementTag((Enum<?>)this.event.getHand());
                }
                yield null;
            }
            case "player_item" -> this.playerItem;
            case "slot" -> new ElementTag((Enum<?>)this.event.getSlot());
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onPlayerManipulatesArmorStand(PlayerArmorStandManipulateEvent event) {
        this.event = event;
        this.entity = new EntityTag((Entity)event.getRightClicked());
        this.playerItem = new ItemTag(event.getPlayerItem());
        this.armorStandItem = new ItemTag(event.getArmorStandItem());
        this.fire((Event)event);
    }
}

