/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPortalEnterEvent;

public class EntityEntersPortalScriptEvent
extends BukkitScriptEvent
implements Listener {
    public EntityTag entity;
    public LocationTag location;
    public EntityPortalEnterEvent event;

    public EntityEntersPortalScriptEvent() {
        this.registerCouldMatcher("<entity> enters portal");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String target = path.eventArgLowerAt(0);
        if (!this.entity.tryAdvancedMatcher(target, path.context)) {
            return false;
        }
        if (!this.runInCheck(path, this.entity.getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity);
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "entity" -> this.entity.getDenizenObject();
            case "location" -> this.location;
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onEntityEntersPortal(EntityPortalEnterEvent event) {
        this.entity = new EntityTag(event.getEntity());
        this.location = new LocationTag(event.getLocation());
        this.event = event;
        this.fire((Event)event);
    }
}

