/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.objects.core;

import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ImageTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.core.SecretTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.AsciiMatcher;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.imageio.ImageIO;

public class BinaryTag
implements ObjectTag {
    public static byte[] EMPTY = new byte[0];
    public static AsciiMatcher VALID_HEX = new AsciiMatcher("0123456789abcdefABCDEF");
    public byte[] data;
    private String prefix = "Binary";
    public static ObjectTagProcessor<BinaryTag> tagProcessor = new ObjectTagProcessor();

    @Fetchable(value="binary")
    public static BinaryTag valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        if ((string = CoreUtilities.toLowerCase(string)).startsWith("binary@")) {
            string = string.substring("binary@".length());
        }
        if (string.isEmpty()) {
            return new BinaryTag(EMPTY);
        }
        if (!BinaryTag.isValidHex(string)) {
            return null;
        }
        return new BinaryTag(CoreUtilities.hexDecode(string));
    }

    public static boolean matches(String string) {
        try {
            if (string.startsWith("binary@")) {
                return true;
            }
            return BinaryTag.isValidHex(string);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isValidHex(String string) {
        return string.length() % 2 != 1 && VALID_HEX.isOnlyMatches(string);
    }

    public BinaryTag(byte[] data) {
        this.data = data;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public ObjectTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public static String hexEncode(byte[] data, boolean spaced) {
        if (!spaced) {
            return CoreUtilities.hexEncode(data);
        }
        char[] output = new char[data.length * 3];
        for (int i = 0; i < data.length; ++i) {
            byte valA = (byte)((data[i] & 0xF0) >> 4);
            byte valB = (byte)(data[i] & 0xF);
            output[i * 3] = CoreUtilities.charForByte[valA];
            output[i * 3 + 1] = CoreUtilities.charForByte[valB];
            output[i * 3 + 2] = 32;
        }
        return new String(output);
    }

    @Override
    public String debuggable() {
        return "binary@<GR>" + BinaryTag.hexEncode(this.data, true);
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public String identify() {
        return "binary@" + BinaryTag.hexEncode(this.data, false);
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public Object getJavaObject() {
        return this.data;
    }

    public static void register() {
        tagProcessor.registerStaticTag(ElementTag.class, "length", (attribute, object) -> new ElementTag(object.data.length), new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "to_hex", (attribute, object) -> new ElementTag(BinaryTag.hexEncode(object.data, false)), new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "to_base64", (attribute, object) -> new ElementTag(Base64.getEncoder().encodeToString(object.data)), new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "utf8_decode", (attribute, object) -> new ElementTag(new String(object.data, StandardCharsets.UTF_8)), new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, ElementTag.class, "text_decode", (attribute, object, encoding) -> {
            try {
                return new ElementTag(new String(object.data, encoding.asString()));
            }
            catch (UnsupportedEncodingException ex) {
                attribute.echoError("Invalid encoding '" + String.valueOf(encoding) + "'");
                return null;
            }
        }, new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "decode_integer", (attribute, object) -> {
            if (object.data.length == 1) {
                return new ElementTag(object.data[0]);
            }
            if (object.data.length > 8) {
                return null;
            }
            ByteBuffer buffer = ByteBuffer.wrap(object.data);
            if (object.data.length == 2) {
                return new ElementTag(buffer.getShort());
            }
            if (object.data.length == 4) {
                return new ElementTag(buffer.getInt());
            }
            if (object.data.length == 8) {
                return new ElementTag(buffer.getLong());
            }
            return null;
        }, new String[0]);
        tagProcessor.registerStaticTag(BinaryTag.class, "gzip_compress", (attribute, object) -> new BinaryTag(BinaryTag.compressGzip(object.data)), new String[0]);
        tagProcessor.registerStaticTag(BinaryTag.class, "gzip_decompress", (attribute, object) -> new BinaryTag(BinaryTag.decompressGzip(object.data)), new String[0]);
        tagProcessor.registerStaticTag(BinaryTag.class, "zlib_compress", (attribute, object) -> new BinaryTag(BinaryTag.compressZlib(object.data)), new String[0]);
        tagProcessor.registerStaticTag(BinaryTag.class, "zlib_decompress", (attribute, object) -> new BinaryTag(BinaryTag.decompressZlib(object.data)), new String[0]);
        tagProcessor.registerStaticTag(BinaryTag.class, ElementTag.class, "hash", (attribute, object, format) -> {
            try {
                MessageDigest md = MessageDigest.getInstance(format.asString());
                md.update(object.data, 0, object.data.length);
                return new BinaryTag(md.digest());
            }
            catch (Throwable ex) {
                attribute.echoError(ex);
                return null;
            }
        }, new String[0]);
        tagProcessor.registerStaticTag(BinaryTag.class, MapTag.class, "hmac", (attribute, object, data) -> {
            try {
                ElementTag macType = data.getRequiredObjectAs("type", ElementTag.class, attribute);
                ObjectTag keyObj = data.getRequiredObjectAs("key", ObjectTag.class, attribute);
                if (macType == null || keyObj == null) {
                    return null;
                }
                byte[] key = keyObj.shouldBeType(SecretTag.class) ? ((SecretTag)keyObj).key.getBytes(StandardCharsets.UTF_8) : (keyObj.shouldBeType(BinaryTag.class) ? ((BinaryTag)keyObj).data : keyObj.toString().getBytes(StandardCharsets.UTF_8));
                Mac hmac = Mac.getInstance(macType.asString());
                SecretKeySpec secret_key = new SecretKeySpec(key, macType.asString());
                hmac.init(secret_key);
                return new BinaryTag(hmac.doFinal(object.data));
            }
            catch (Throwable ex) {
                attribute.echoError(ex);
                return null;
            }
        }, new String[0]);
        tagProcessor.registerStaticTag(ImageTag.class, "to_image", (attribute, object) -> {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(object.data);
            try {
                BufferedImage image = ImageIO.read(inputStream);
                if (image == null) {
                    attribute.echoError("Couldn't recognize image format from BinaryTag.");
                    return null;
                }
                return new ImageTag(image);
            }
            catch (IOException e) {
                attribute.echoError("BinaryTag couldn't be converted to image, see stacktrace below:");
                attribute.echoError(e);
                return null;
            }
        }, new String[0]);
    }

    private static byte[] decompressZlib(byte[] data) {
        try {
            int len;
            ByteArrayInputStream bytesIn = new ByteArrayInputStream(data);
            InflaterInputStream zlibIn = new InflaterInputStream(bytesIn);
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream(data.length);
            byte[] buffer = new byte[1024];
            while ((len = zlibIn.read(buffer, 0, 1024)) != -1) {
                bytesOut.write(buffer, 0, len);
            }
            byte[] result = bytesOut.toByteArray();
            zlibIn.close();
            bytesIn.close();
            bytesOut.close();
            return result;
        }
        catch (IOException ex) {
            Debug.echoError(ex);
            return null;
        }
    }

    private static byte[] compressZlib(byte[] data) {
        try {
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream(data.length);
            DeflaterOutputStream zlibOut = new DeflaterOutputStream(bytesOut);
            zlibOut.write(data);
            zlibOut.flush();
            zlibOut.close();
            byte[] result = bytesOut.toByteArray();
            bytesOut.close();
            return result;
        }
        catch (IOException ex) {
            Debug.echoError(ex);
            return null;
        }
    }

    private static byte[] decompressGzip(byte[] data) {
        try {
            int len;
            ByteArrayInputStream bytesIn = new ByteArrayInputStream(data);
            GZIPInputStream gzipIn = new GZIPInputStream(bytesIn);
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream(data.length);
            byte[] buffer = new byte[1024];
            while ((len = gzipIn.read(buffer, 0, 1024)) != -1) {
                bytesOut.write(buffer, 0, len);
            }
            byte[] result = bytesOut.toByteArray();
            gzipIn.close();
            bytesIn.close();
            bytesOut.close();
            return result;
        }
        catch (IOException ex) {
            Debug.echoError(ex);
            return null;
        }
    }

    private static byte[] compressGzip(byte[] data) {
        try {
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream(data.length);
            GZIPOutputStream gzipOut = new GZIPOutputStream(bytesOut);
            gzipOut.write(data);
            gzipOut.finish();
            byte[] result = bytesOut.toByteArray();
            gzipOut.close();
            bytesOut.close();
            return result;
        }
        catch (IOException ex) {
            Debug.echoError(ex);
            return null;
        }
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }
}

