/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.entity.Firework;

public class EntityShotAtAngle
implements Property {
    public static final String[] handledMechs = new String[]{"shot_at_angle"};
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        return entity instanceof EntityTag && ((EntityTag)entity).getBukkitEntity() instanceof Firework;
    }

    public static EntityShotAtAngle getFrom(ObjectTag entity) {
        if (!EntityShotAtAngle.describes(entity)) {
            return null;
        }
        return new EntityShotAtAngle((EntityTag)entity);
    }

    public EntityShotAtAngle(EntityTag entity) {
        this.entity = entity;
    }

    public Firework getFirework() {
        return (Firework)this.entity.getBukkitEntity();
    }

    @Override
    public String getPropertyString() {
        return this.getFirework().isShotAtAngle() ? "true" : "false";
    }

    @Override
    public String getPropertyId() {
        return "shot_at_angle";
    }

    public static void register() {
        PropertyParser.registerTag(EntityShotAtAngle.class, ElementTag.class, "shot_at_angle", (attribute, object) -> new ElementTag(object.getFirework().isShotAtAngle()), new String[0]);
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("shot_at_angle") && mechanism.requireBoolean()) {
            this.getFirework().setShotAtAngle(mechanism.getValue().asBoolean());
        }
    }
}

