/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.core.EscapeTagUtil;
import com.denizenscript.denizencore.utilities.AsciiMatcher;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

@Deprecated
public class ItemAttributeNBT
implements Property {
    public static final String[] handledTags = new String[]{"nbt_attributes"};
    public static final String[] handledMechs = new String[]{"nbt_attributes"};
    ItemTag item;
    public static final AsciiMatcher uppercaseMatcher = new AsciiMatcher("ABCDEFGHIJKLMNOPQRSTUVWXYZ");
    public static final HashMap<String, String> attributeNameUpdates = new HashMap();

    public static boolean describes(ObjectTag item) {
        return item instanceof ItemTag;
    }

    public static ItemAttributeNBT getFrom(ObjectTag item) {
        if (!ItemAttributeNBT.describes(item)) {
            return null;
        }
        return new ItemAttributeNBT((ItemTag)item);
    }

    public ItemAttributeNBT(ItemTag item) {
        this.item = item;
    }

    @Override
    public ObjectTag getObjectAttribute(com.denizenscript.denizencore.tags.Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("nbt_attributes")) {
            BukkitImplDeprecations.legacyAttributeProperties.warn(attribute.context);
            return this.getList().getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    public ListTag getList() {
        ItemStack itemStack = this.item.getItemStack();
        ItemMeta meta = itemStack.getItemMeta();
        ListTag list = new ListTag();
        if (meta == null || !meta.hasAttributeModifiers()) {
            return list;
        }
        for (Map.Entry entry : meta.getAttributeModifiers().entries()) {
            AttributeModifier modifier = (AttributeModifier)entry.getValue();
            String slotName = ItemAttributeNBT.toLegacyName(modifier.getSlot() != null ? modifier.getSlot() : EquipmentSlot.HAND);
            list.add(EscapeTagUtil.escape(((Attribute)entry.getKey()).getKey().getKey()) + "/" + EscapeTagUtil.escape(slotName) + "/" + modifier.getOperation().ordinal() + "/" + modifier.getAmount());
        }
        return list;
    }

    @Override
    public String getPropertyString() {
        return null;
    }

    @Override
    public String getPropertyId() {
        return "nbt_attributes";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("nbt_attributes")) {
            BukkitImplDeprecations.legacyAttributeProperties.warn(mechanism.context);
            if (this.item.getMaterial().getMaterial() == Material.AIR) {
                mechanism.echoError("Cannot apply NBT to AIR!");
                return;
            }
            ListTag list = mechanism.valueAsType(ListTag.class);
            ItemStack itemStack = this.item.getItemStack();
            ItemMeta meta = itemStack.getItemMeta();
            if (meta.hasAttributeModifiers()) {
                meta.getAttributeModifiers().keySet().forEach(arg_0 -> ((ItemMeta)meta).removeAttributeModifier(arg_0));
            }
            for (String string : list) {
                String[] split = string.split("/");
                if (split.length != 4) {
                    mechanism.echoError("Invalid nbt_attributes input: must have 4 values per attribute.");
                    continue;
                }
                String attribute = ItemAttributeNBT.fixAttributeName1_16(EscapeTagUtil.unEscape(split[0]));
                String slot = EscapeTagUtil.unEscape(split[1]);
                int op = new ElementTag(split[2]).asInt();
                double amt = new ElementTag(split[3]).asDouble();
                long uuidhelp = ItemAttributeNBT.uuidChoice(itemStack);
                int attribsSize = meta.hasAttributeModifiers() ? meta.getAttributeModifiers().values().size() : 0;
                UUID fullUuid = new UUID(uuidhelp + 88512L + (long)attribsSize, uuidhelp * 2L + 1250025L + (long)attribsSize);
                meta.addAttributeModifier((Attribute)Registry.ATTRIBUTE.get(NamespacedKey.minecraft((String)attribute)), new AttributeModifier(fullUuid, attribute, amt, AttributeModifier.Operation.values()[op], ItemAttributeNBT.fromLegacyName(slot)));
            }
            itemStack.setItemMeta(meta);
            this.item.setItemStack(itemStack);
        }
    }

    public static String fixAttributeName1_16(String input) {
        if (!uppercaseMatcher.containsAnyMatch(input)) {
            return input;
        }
        String replacement = attributeNameUpdates.get(input);
        if (replacement != null) {
            return replacement;
        }
        return CoreUtilities.toLowerCase(input);
    }

    public static long uuidChoice(ItemStack its) {
        String mat = CoreUtilities.toLowerCase(its.getType().name());
        if (mat.contains("boots")) {
            return 1000L;
        }
        if (mat.contains("legging")) {
            return 100000L;
        }
        if (mat.contains("helmet")) {
            return 10000000L;
        }
        if (mat.contains("chestp")) {
            return 1000000000L;
        }
        return 1L;
    }

    private static EquipmentSlot fromLegacyName(String name) {
        return switch (name) {
            case "mainhand" -> EquipmentSlot.HAND;
            case "offhand" -> EquipmentSlot.OFF_HAND;
            default -> {
                EquipmentSlot slot = ElementTag.asEnum(EquipmentSlot.class, name);
                if (slot != null) {
                    yield slot;
                }
                yield EquipmentSlot.HAND;
            }
        };
    }

    private static String toLegacyName(EquipmentSlot slot) {
        return switch (slot) {
            case EquipmentSlot.HAND -> "mainhand";
            case EquipmentSlot.OFF_HAND -> "offhand";
            default -> CoreUtilities.toLowerCase(slot.name());
        };
    }

    static {
        attributeNameUpdates.put("generic.maxHealth", "generic.max_health");
        attributeNameUpdates.put("generic.followRange", "generic.follow_range");
        attributeNameUpdates.put("generic.knockbackResistance", "generic.knockback_resistance");
        attributeNameUpdates.put("generic.movementSpeed", "generic.movement_speed");
        attributeNameUpdates.put("generic.flyingSpeed", "generic.flying_speed");
        attributeNameUpdates.put("generic.attackDamage", "generic.attack_damage");
        attributeNameUpdates.put("generic.attackKnockback", "generic.attack_knockback");
        attributeNameUpdates.put("generic.attackSpeed", "generic.attack_speed");
        attributeNameUpdates.put("generic.armorToughness", "generic.armor_toughness");
    }
}

