/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.entity;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.PaperAPITools;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.packets.NetworkInterceptHelper;
import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsRuntimeException;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultNull;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultText;
import com.denizenscript.denizencore.scripts.commands.generator.ArgLinear;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import com.denizenscript.denizencore.scripts.commands.generator.ArgSubType;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.Arrays;
import java.util.List;
import net.citizensnpcs.trait.CurrentLocation;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.util.Vector;

public class TeleportCommand
extends AbstractCommand {
    public TeleportCommand() {
        this.setName("teleport");
        this.setSyntax("teleport (<entity>|...) [<location>] (cause:<cause>) (entity_options:<option>|...) (relative) (relative_axes:<axis>|...) (offthread_repeat:<#>) (offthread_yaw) (offthread_pitch)");
        this.setRequiredArguments(1, 9);
        this.isProcedural = false;
        this.autoCompile();
    }

    @Override
    public void addCustomTabCompletions(AbstractCommand.TabCompletionsBuilder tab) {
        tab.addNotesOfType(LocationTag.class);
        tab.addWithPrefix("entity_options:", EntityState.values());
        tab.addWithPrefix("relative_axes:", Relative.values());
    }

    public static void autoExecute(ScriptEntry scriptEntry, @ArgLinear @ArgName(value="entities") ObjectTag entityList, @ArgLinear @ArgName(value="location") @ArgDefaultNull ObjectTag locationRaw, @ArgPrefixed @ArgName(value="cause") @ArgDefaultText(value="plugin") PlayerTeleportEvent.TeleportCause cause, @ArgName(value="entity_options") @ArgPrefixed @ArgDefaultNull @ArgSubType(value=EntityState.class) List<EntityState> entityOptions, @ArgName(value="relative_axes") @ArgPrefixed @ArgDefaultNull @ArgSubType(value=Relative.class) List<Relative> relativeAxes, @ArgName(value="relative") boolean relative, @ArgName(value="offthread_repeat") @ArgDefaultNull @ArgPrefixed ElementTag offthreadRepeats, @ArgName(value="offthread_yaw") boolean offthreadYaw, @ArgName(value="offthread_pitch") boolean offthreadPitch) {
        if (locationRaw == null) {
            locationRaw = entityList;
            entityList = Utilities.entryDefaultEntity(scriptEntry, true);
        } else if (entityList.identify().startsWith("l@")) {
            ObjectTag swap = locationRaw;
            locationRaw = entityList;
            entityList = swap;
            Deprecations.outOfOrderArgs.warn(scriptEntry);
        }
        if (relative && relativeAxes == null) {
            relativeAxes = Arrays.asList(Relative.values());
        }
        LocationTag location = locationRaw.asType(LocationTag.class, scriptEntry.context);
        ListTag entities = entityList.asType(ListTag.class, scriptEntry.context);
        if (location == null || entities == null) {
            throw new InvalidArgumentsRuntimeException("Location or entity list missing or invalid for Teleport command");
        }
        for (ObjectTag entityObj : entities.objectForms) {
            NPCTag npc;
            PlayerTag player;
            if (entityObj.shouldBeType(PlayerTag.class) && (player = entityObj.asType(PlayerTag.class, scriptEntry.context)) != null && !player.isOnline()) {
                player.setLocation(location);
                continue;
            }
            if (entityObj.shouldBeType(NPCTag.class) && (npc = entityObj.asType(NPCTag.class, scriptEntry.context)) != null && !npc.isSpawned()) {
                ((CurrentLocation)npc.getCitizen().getOrAddTrait(CurrentLocation.class)).setLocation((Location)location.clone());
                continue;
            }
            EntityTag entity = entityObj.asType(EntityTag.class, scriptEntry.context);
            if (entity == null) {
                Debug.echoError("Cannot interpret object '" + String.valueOf(entityObj) + "' as an EntityTag.");
                continue;
            }
            if (entity.isFake && entity.getWorld().equals((Object)location.getWorld())) {
                NMSHandler.entityHelper.snapPositionTo(entity.getBukkitEntity(), location.toVector());
                NMSHandler.entityHelper.look(entity.getBukkitEntity(), location.getYaw(), location.getPitch());
                return;
            }
            if (offthreadRepeats != null && relativeAxes != null && entity.isPlayer()) {
                float yaw;
                double z;
                NetworkInterceptHelper.enable();
                int times = offthreadRepeats.asInt() + 1;
                int ms = 50 / times;
                Player player2 = entity.getPlayer();
                Vector increment = location.clone().subtract(player2.getLocation()).toVector().multiply(1.0 / (double)times);
                double x = relativeAxes.contains((Object)Relative.X) ? increment.getX() : location.getX();
                double y = relativeAxes.contains((Object)Relative.Y) ? increment.getY() : location.getY();
                double d = z = relativeAxes.contains((Object)Relative.Z) ? increment.getZ() : location.getZ();
                if (relativeAxes.contains((Object)Relative.YAW)) {
                    float relYaw = (location.getYaw() - player2.getLocation().getYaw()) % 360.0f;
                    if (relYaw > 180.0f) {
                        relYaw -= 360.0f;
                    }
                    yaw = offthreadYaw ? relYaw / (float)times : 0.0f;
                } else {
                    yaw = location.getYaw();
                }
                float pitch = relativeAxes.contains((Object)Relative.PITCH) ? (offthreadPitch ? (location.getPitch() - player2.getLocation().getPitch()) / (float)times : 0.0f) : location.getPitch();
                List<Relative> finalRelativeAxes = relativeAxes;
                NMSHandler.packetHelper.sendRelativePositionPacket(player2, x, y, z, yaw, pitch, finalRelativeAxes);
                DenizenCore.runAsync(() -> {
                    try {
                        for (int i = 0; i < times - 1; ++i) {
                            Thread.sleep(ms);
                            NMSHandler.packetHelper.sendRelativePositionPacket(player2, x, y, z, yaw, pitch, finalRelativeAxes);
                        }
                    }
                    catch (Throwable ex) {
                        Debug.echoError(ex);
                    }
                });
                continue;
            }
            if (entityOptions != null || relativeAxes != null) {
                PaperAPITools.instance.teleport(entity.getBukkitEntity(), location, cause, entityOptions, relativeAxes);
                continue;
            }
            entity.teleport(location, cause);
        }
    }

    public static enum EntityState {
        RETAIN_PASSENGERS,
        RETAIN_VEHICLE,
        RETAIN_OPEN_INVENTORY;

    }

    public static enum Relative {
        X,
        Y,
        Z,
        YAW,
        PITCH;

    }
}

