/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.command;

import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizen.utilities.Settings;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.scripts.ScriptBuilder;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.core.FlagCommand;
import com.denizenscript.denizencore.scripts.queues.core.InstantQueue;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.ExCommandHelper;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class ExCommandHandler
implements CommandExecutor,
TabCompleter {
    public void enableFor(PluginCommand command) {
        command.setExecutor((CommandExecutor)this);
        command.setTabCompleter((TabCompleter)this);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String alias, String[] args) {
        PlayerTag playerTag;
        boolean quiet;
        ArrayList<Object> entries = new ArrayList<Object>();
        String entry = String.join((CharSequence)" ", args);
        boolean bl = quiet = !Settings.showExDebug();
        if (entry.length() > 3 && entry.startsWith("-q ")) {
            quiet = !quiet;
            entry = entry.substring("-q ".length());
        }
        if (entry.length() < 2) {
            sender.sendMessage("/ex (-q) <denizen script command> (arguments)");
            return true;
        }
        if (Settings.showExHelp()) {
            if (CoreConfiguration.shouldShowDebug) {
                if (quiet) {
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Executing Denizen script command... check the console for full debug output!");
                }
            } else {
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Executing Denizen script command... to see debug, use /denizen debug");
            }
        }
        entries.add(entry);
        InstantQueue queue = new InstantQueue("EXCOMMAND");
        NPCTag npc = null;
        if (Depends.citizens != null && Depends.citizens.getNPCSelector().getSelected(sender) != null) {
            npc = new NPCTag(Depends.citizens.getNPCSelector().getSelected(sender));
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            playerTag = new PlayerTag(player);
        } else {
            playerTag = null;
        }
        List<ScriptEntry> scriptEntries = ScriptBuilder.buildScriptEntries(entries, null, new BukkitScriptEntryData(playerTag, npc));
        queue.addEntries(scriptEntries);
        if (!quiet && sender instanceof Player) {
            queue.debugOutput = s -> sender.spigot().sendMessage(FormattedTextHelper.parse(s.replace("<FORCE_ALIGN>", ""), net.md_5.bungee.api.ChatColor.WHITE));
        }
        queue.start();
        return true;
    }

    public static void onFlagTabComplete(AbstractCommand.TabCompletionsBuilder builder) {
        BukkitTagContext context = (BukkitTagContext)builder.context;
        if (context.player != null) {
            for (String flagName : context.player.getFlagTracker().listAllFlags()) {
                if (flagName.startsWith("__")) continue;
                builder.add(flagName);
            }
        }
        if (context.npc != null) {
            for (String flagName : context.npc.getFlagTracker().listAllFlags()) {
                if (flagName.startsWith("__")) continue;
                builder.add(flagName);
            }
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] rawArgs) {
        PlayerTag playerTag;
        if (sender instanceof Player) {
            Player player = (Player)sender;
            playerTag = new PlayerTag(player);
        } else {
            playerTag = null;
        }
        BukkitTagContext context = new BukkitTagContext(playerTag, null, null);
        if (Depends.citizens != null && Depends.citizens.getNPCSelector().getSelected(sender) != null) {
            context.npc = new NPCTag(Depends.citizens.getNPCSelector().getSelected(sender));
        }
        return ExCommandHelper.buildTabCompletions(rawArgs, context);
    }

    static {
        FlagCommand.flagTabCompleters.add(ExCommandHandler::onFlagTabComplete);
    }
}

