/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.block;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDispenseEvent;

public class BlockDispensesScriptEvent
extends BukkitScriptEvent
implements Listener {
    public LocationTag location;
    public ItemTag item;
    private MaterialTag material;
    public BlockDispenseEvent event;

    public BlockDispensesScriptEvent() {
        this.registerCouldMatcher("<block> dispenses <item>");
        this.registerOptionalDetermination(null, ObjectTag.class, (evt, context, value) -> {
            if (value.canBeType(LocationTag.class)) {
                LocationTag location = value.asType(LocationTag.class, context);
                if (location != null) {
                    evt.event.setVelocity(location.toVector());
                    return true;
                }
            } else if (value.canBeType(ItemTag.class)) {
                BukkitImplDeprecations.blockDispensesItemDetermination.warn();
                ItemTag item = value.asType(ItemTag.class, context);
                if (item != null) {
                    evt.item = item;
                    evt.event.setItem(item.getItemStack());
                    return true;
                }
            }
            return false;
        });
        this.registerDetermination("item", ItemTag.class, (evt, context, value) -> {
            evt.item = value;
            evt.event.setItem(value.getItemStack());
        });
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        if (!path.tryArgObject(2, this.item)) {
            return false;
        }
        if (!path.tryArgObject(0, this.material)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "location" -> this.location;
            case "item" -> new ItemTag(this.event.getItem());
            case "velocity" -> new LocationTag(this.event.getVelocity());
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onBlockDispenses(BlockDispenseEvent event) {
        this.location = new LocationTag(event.getBlock().getLocation());
        this.material = new MaterialTag(event.getBlock());
        this.item = new ItemTag(event.getItem());
        this.event = event;
        this.fire((Event)event);
    }
}

